/*
 * Decompiled with CFR 0.152.
 */
package com.mcf.davidee.nbtedit.gui;

import com.mcf.davidee.nbtedit.NBTStringHelper;
import com.mcf.davidee.nbtedit.gui.GuiCharacterButton;
import com.mcf.davidee.nbtedit.gui.GuiNBTTree;
import com.mcf.davidee.nbtedit.gui.GuiTextField;
import com.mcf.davidee.nbtedit.nbt.NamedNBT;
import com.mcf.davidee.nbtedit.nbt.Node;
import com.mcf.davidee.nbtedit.nbt.ParseHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class GuiEditNBT
extends Gui {
    public static final ResourceLocation WINDOW_TEXTURE = new ResourceLocation("nbtedit", "textures/gui/window.png");
    public static final int WIDTH = 178;
    public static final int HEIGHT = 93;
    private Minecraft mc = Minecraft.func_71410_x();
    private Node<NamedNBT> node;
    private NBTBase nbt;
    private boolean canEditText;
    private boolean canEditValue;
    private GuiNBTTree parent;
    private int x;
    private int y;
    private GuiTextField key;
    private GuiTextField value;
    private GuiButton save;
    private GuiButton cancel;
    private String kError;
    private String vError;
    private GuiCharacterButton newLine;
    private GuiCharacterButton section;

    public GuiEditNBT(GuiNBTTree parent, Node<NamedNBT> node, boolean editText, boolean editValue) {
        this.parent = parent;
        this.node = node;
        this.nbt = node.getObject().getNBT();
        this.canEditText = editText;
        this.canEditValue = editValue;
    }

    public void initGUI(int x, int y) {
        this.x = x;
        this.y = y;
        this.section = new GuiCharacterButton(0, x + 178 - 1, y + 34);
        this.newLine = new GuiCharacterButton(1, x + 178 - 1, y + 50);
        String sKey = this.key == null ? this.node.getObject().getName() : this.key.getText();
        String sValue = this.value == null ? GuiEditNBT.getValue(this.nbt) : this.value.getText();
        this.key = new GuiTextField(this.mc.field_71466_p, x + 46, y + 18, 116, 15, false);
        this.value = new GuiTextField(this.mc.field_71466_p, x + 46, y + 44, 116, 15, true);
        this.key.setText(sKey);
        this.key.setEnableBackgroundDrawing(false);
        this.key.func_82265_c(this.canEditText);
        this.value.setMaxStringLength(256);
        this.value.setText(sValue);
        this.value.setEnableBackgroundDrawing(false);
        this.value.func_82265_c(this.canEditValue);
        this.save = new GuiButton(1, x + 9, y + 62, 75, 20, "Save");
        if (!this.key.isFocused() && !this.value.isFocused()) {
            if (this.canEditText) {
                this.key.setFocused(true);
            } else if (this.canEditValue) {
                this.value.setFocused(true);
            }
        }
        this.section.setEnabled(this.value.isFocused());
        this.newLine.setEnabled(this.value.isFocused());
        this.cancel = new GuiButton(0, x + 93, y + 62, 75, 20, "Cancel");
    }

    public void click(int mx, int my) {
        if (this.newLine.inBounds(mx, my) && this.value.isFocused()) {
            this.value.writeText("\n");
            this.checkValidInput();
        } else if (this.section.inBounds(mx, my) && this.value.isFocused()) {
            this.value.writeText("\u00a7");
            this.checkValidInput();
        } else {
            this.key.mouseClicked(mx, my, 0);
            this.value.mouseClicked(mx, my, 0);
            if (this.save.func_146116_c(this.mc, mx, my)) {
                this.saveAndQuit();
            }
            if (this.cancel.func_146116_c(this.mc, mx, my)) {
                this.parent.closeWindow();
            }
            this.section.setEnabled(this.value.isFocused());
            this.newLine.setEnabled(this.value.isFocused());
        }
    }

    private void saveAndQuit() {
        if (this.canEditText) {
            this.node.getObject().setName(this.key.getText());
        }
        GuiEditNBT.setValidValue(this.node, this.value.getText());
        this.parent.nodeEdited(this.node);
        this.parent.closeWindow();
    }

    public void draw(int mx, int my) {
        this.mc.field_71446_o.func_110577_a(WINDOW_TEXTURE);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.func_73729_b(this.x, this.y, 0, 0, 178, 93);
        if (!this.canEditText) {
            GuiEditNBT.func_73734_a((int)(this.x + 42), (int)(this.y + 15), (int)(this.x + 169), (int)(this.y + 31), (int)Integer.MIN_VALUE);
        }
        if (!this.canEditValue) {
            GuiEditNBT.func_73734_a((int)(this.x + 42), (int)(this.y + 41), (int)(this.x + 169), (int)(this.y + 57), (int)Integer.MIN_VALUE);
        }
        this.key.drawTextBox();
        this.value.drawTextBox();
        this.save.func_146112_a(this.mc, mx, my);
        this.cancel.func_146112_a(this.mc, mx, my);
        if (this.kError != null) {
            this.func_73732_a(this.mc.field_71466_p, this.kError, this.x + 89, this.y + 4, 0xFF0000);
        }
        if (this.vError != null) {
            this.func_73732_a(this.mc.field_71466_p, this.vError, this.x + 89, this.y + 32, 0xFF0000);
        }
        this.newLine.draw(mx, my);
        this.section.draw(mx, my);
    }

    public void func_73732_a(FontRenderer par1FontRenderer, String par2Str, int par3, int par4, int par5) {
        par1FontRenderer.func_78276_b(par2Str, par3 - par1FontRenderer.func_78256_a(par2Str) / 2, par4, par5);
    }

    public void update() {
        this.value.updateCursorCounter();
        this.key.updateCursorCounter();
    }

    public void keyTyped(char c, int i) {
        if (i == 1) {
            this.parent.closeWindow();
        } else if (i == 15) {
            if (this.key.isFocused() && this.canEditValue) {
                this.key.setFocused(false);
                this.value.setFocused(true);
            } else if (this.value.isFocused() && this.canEditText) {
                this.key.setFocused(true);
                this.value.setFocused(false);
            }
            this.section.setEnabled(this.value.isFocused());
            this.newLine.setEnabled(this.value.isFocused());
        } else if (i == 28) {
            this.checkValidInput();
            if (this.save.field_146124_l) {
                this.saveAndQuit();
            }
        } else {
            this.key.textboxKeyTyped(c, i);
            this.value.textboxKeyTyped(c, i);
            this.checkValidInput();
        }
    }

    private void checkValidInput() {
        boolean valid = true;
        this.kError = null;
        this.vError = null;
        if (this.canEditText && !this.validName()) {
            valid = false;
            this.kError = "Duplicate Tag Name";
        }
        try {
            GuiEditNBT.validValue(this.value.getText(), this.nbt.func_74732_a());
            valid &= true;
        }
        catch (NumberFormatException e) {
            this.vError = e.getMessage();
            valid = false;
        }
        this.save.field_146124_l = valid;
    }

    private boolean validName() {
        for (Node<NamedNBT> node : this.node.getParent().getChildren()) {
            NBTBase base = node.getObject().getNBT();
            if (base == this.nbt || !node.getObject().getName().equals(this.key.getText())) continue;
            return false;
        }
        return true;
    }

    private static void setValidValue(Node<NamedNBT> node, String value) {
        NamedNBT named = node.getObject();
        NBTBase base = named.getNBT();
        if (base instanceof NBTTagByte) {
            named.setNBT((NBTBase)new NBTTagByte(ParseHelper.parseByte(value)));
        }
        if (base instanceof NBTTagShort) {
            named.setNBT((NBTBase)new NBTTagShort(ParseHelper.parseShort(value)));
        }
        if (base instanceof NBTTagInt) {
            named.setNBT((NBTBase)new NBTTagInt(ParseHelper.parseInt(value)));
        }
        if (base instanceof NBTTagLong) {
            named.setNBT((NBTBase)new NBTTagLong(ParseHelper.parseLong(value)));
        }
        if (base instanceof NBTTagFloat) {
            named.setNBT((NBTBase)new NBTTagFloat(ParseHelper.parseFloat(value)));
        }
        if (base instanceof NBTTagDouble) {
            named.setNBT((NBTBase)new NBTTagDouble(ParseHelper.parseDouble(value)));
        }
        if (base instanceof NBTTagByteArray) {
            named.setNBT((NBTBase)new NBTTagByteArray(ParseHelper.parseByteArray(value)));
        }
        if (base instanceof NBTTagIntArray) {
            named.setNBT((NBTBase)new NBTTagIntArray(ParseHelper.parseIntArray(value)));
        }
        if (base instanceof NBTTagString) {
            named.setNBT((NBTBase)new NBTTagString(value));
        }
    }

    private static void validValue(String value, byte type) throws NumberFormatException {
        switch (type) {
            case 1: {
                ParseHelper.parseByte(value);
                break;
            }
            case 2: {
                ParseHelper.parseShort(value);
                break;
            }
            case 3: {
                ParseHelper.parseInt(value);
                break;
            }
            case 4: {
                ParseHelper.parseLong(value);
                break;
            }
            case 5: {
                ParseHelper.parseFloat(value);
                break;
            }
            case 6: {
                ParseHelper.parseDouble(value);
                break;
            }
            case 7: {
                ParseHelper.parseByteArray(value);
                break;
            }
            case 11: {
                ParseHelper.parseIntArray(value);
            }
        }
    }

    private static String getValue(NBTBase base) {
        switch (base.func_74732_a()) {
            case 7: {
                String s = "";
                for (byte b : ((NBTTagByteArray)base).func_150292_c()) {
                    s = s + b + " ";
                }
                return s;
            }
            case 9: {
                return "TagList";
            }
            case 10: {
                return "TagCompound";
            }
            case 11: {
                String i = "";
                for (int a : ((NBTTagIntArray)base).func_150302_c()) {
                    i = i + a + " ";
                }
                return i;
            }
        }
        return NBTStringHelper.toString(base);
    }
}

