/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.world.structure.island.biome.feature.mountains;

import chylex.hee.init.BlockList;
import chylex.hee.system.util.MathUtil;
import chylex.hee.world.structure.island.biome.IslandBiomeBurningMountains;
import chylex.hee.world.structure.island.biome.feature.AbstractIslandStructure;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;

public class StructureCinderPatch
extends AbstractIslandStructure {
    @Override
    protected boolean generate(Random rand) {
        int x = this.getRandomXZ(rand, 24);
        int z = this.getRandomXZ(rand, 24);
        int y = 5 + rand.nextInt(60);
        if (this.world.getBlock(x, y, z) != Blocks.field_150377_bs) {
            return false;
        }
        double rad = 3.5 + rand.nextDouble() * rand.nextDouble() * 7.0 * (this.biomeData.hasDeviation(IslandBiomeBurningMountains.EXCESSIVE_CINDER) ? 1.5 : 1.0);
        this.generateBlob(rand, x, y, z, rad);
        int attemptAmount = rand.nextInt(4) * rand.nextInt(4);
        for (int attempt = 0; attempt < attemptAmount; ++attempt) {
            this.generateBlob(rand, (double)x + (rand.nextDouble() - 0.5) * 1.2 * rad, (double)y + (rand.nextDouble() - 0.5) * 1.2 * rad, (double)z + (rand.nextDouble() - 0.5) * 1.2 * rad, 3.0 + rand.nextDouble() * (rad - 2.0));
        }
        return true;
    }

    private void generateBlob(Random rand, double x, double y, double z, double rad) {
        int xx = MathUtil.floor(x - rad) - 1;
        while ((double)xx <= x + rad + 1.0) {
            int yy = MathUtil.floor(y - rad) - 1;
            while ((double)yy <= y + rad + 1.0) {
                if (yy > 0) {
                    int zz = MathUtil.floor(z - rad) - 1;
                    while ((double)zz <= z + rad + 1.0) {
                        Block block;
                        if (MathUtil.distance((double)xx - x, (double)yy - y, (double)zz - z) <= rad - rand.nextDouble() && ((block = this.world.getBlock(xx, yy, zz)) == Blocks.field_150377_bs || block == BlockList.end_terrain)) {
                            this.world.setBlock(xx, yy, zz, BlockList.cinder);
                        }
                        ++zz;
                    }
                }
                ++yy;
            }
            ++xx;
        }
    }
}

