/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.world.structure.island.biome.feature.forest.ravageddungeon;

import chylex.hee.world.structure.island.biome.feature.forest.ravageddungeon.DungeonDir;
import chylex.hee.world.structure.island.biome.feature.forest.ravageddungeon.DungeonElement;
import chylex.hee.world.structure.island.biome.feature.forest.ravageddungeon.DungeonElementType;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;

public final class DungeonElementList {
    private final EnumMap<DungeonElementType, List<DungeonElement>> data = new EnumMap(DungeonElementType.class);
    private final DungeonElement[] locReference;
    private final byte width;

    public DungeonElementList(int width, int height) {
        for (DungeonElementType type : DungeonElementType.values()) {
            this.data.put(type, new ArrayList());
        }
        this.locReference = new DungeonElement[width * height];
        this.width = (byte)width;
    }

    public void add(DungeonElement element) {
        if (this.locReference[element.x + element.y * this.width] != null) {
            this.remove(this.locReference[element.x + element.y * this.width]);
        }
        this.data.get((Object)element.type).add(element);
        this.locReference[element.x + element.y * this.width] = element;
    }

    public void remove(DungeonElement element) {
        Iterator<DungeonElement> iter = this.data.get((Object)element.type).iterator();
        while (iter.hasNext()) {
            if (!iter.next().equals(element)) continue;
            iter.remove();
            break;
        }
    }

    public List<DungeonElement> getAll(DungeonElementType type) {
        return this.data.get((Object)type);
    }

    public DungeonElement getRandom(DungeonElementType type, Random rand) {
        List<DungeonElement> elements = this.data.get((Object)type);
        if (elements.size() > 0) {
            return elements.get(rand.nextInt(elements.size()));
        }
        return null;
    }

    public DungeonElement getAt(int x, int y) {
        if (x < 0 || y < 0 || x >= this.width || x + y * this.width >= this.locReference.length) {
            return null;
        }
        return this.locReference[x + y * this.width];
    }

    public DungeonElementType getTypeAt(int x, int y) {
        DungeonElement element = this.getAt(x, y);
        if (element == null) {
            return DungeonElementType.EMPTY;
        }
        return element.type;
    }

    public Set<DungeonElement> getGrouped(DungeonElement element) {
        HashSet<DungeonElement> list = new HashSet<DungeonElement>();
        this.addElementAndGrouped(element, list);
        return list;
    }

    private Set<DungeonElement> addElementAndGrouped(DungeonElement element, Set<DungeonElement> set) {
        set.add(element);
        for (DungeonDir dir : DungeonDir.values) {
            DungeonElement connectedElement;
            if (!element.checkConnection(dir) || (connectedElement = this.getAt(element.x + dir.addX * element.size, element.y + dir.addY * element.size)) == null || connectedElement.type != element.type || set.contains(connectedElement)) continue;
            this.addElementAndGrouped(connectedElement, set);
        }
        return set;
    }
}

