/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.world.structure;

import chylex.hee.system.commands.HeeDebugCommand;
import chylex.hee.system.savedata.WorldDataHandler;
import chylex.hee.system.savedata.types.DragonSavefile;
import chylex.hee.system.util.MathUtil;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.world.gen.structure.MapGenScatteredFeature;

public abstract class MapGenScatteredFeatureCustom
extends MapGenScatteredFeature {
    private final Random coordCheckRand = new Random();
    protected final int minSpacing;
    protected final int maxSpacing;
    protected final int minDistanceFromCenter;
    protected final int featureSize;
    public static final HeeDebugCommand.HeeTest $debugTest = new HeeDebugCommand.HeeTest(){

        @Override
        public void run(String ... args) {
            int minSpacing = 8;
            int maxSpacing = 15;
            int deathAmt = ((DragonSavefile)WorldDataHandler.get(DragonSavefile.class)).getDragonDeathAmount();
            int px = MathUtil.floor(this.player.field_70165_t);
            int py = MathUtil.floor(this.player.field_70163_u);
            int pz = MathUtil.floor(this.player.field_70161_v);
            Random rand = new Random();
            for (int x = -48; x <= 48; ++x) {
                for (int z = -48; z <= 48; ++z) {
                    int xx = x;
                    int zz = z;
                    int origChunkX = xx;
                    int origChunkZ = zz;
                    if (xx < 0) {
                        xx -= maxSpacing - 1;
                    }
                    if (zz < 0) {
                        zz -= maxSpacing - 1;
                    }
                    int x2 = xx / maxSpacing;
                    int z2 = zz / maxSpacing;
                    rand.setSeed((long)x2 * 341873128712L + (long)z2 * 132897987541L + this.world.func_72912_H().func_76063_b() + 358041L);
                    rand.nextInt(1 + deathAmt);
                    this.world.func_147449_b(px + (x2 *= maxSpacing), py - 1, pz + (z2 *= maxSpacing), Blocks.field_150475_bE);
                    if (origChunkX != (x2 += rand.nextInt(maxSpacing - minSpacing)) || origChunkZ != (z2 += rand.nextInt(maxSpacing - minSpacing)) || rand.nextInt(3) != 0) continue;
                    this.world.func_147449_b(px + x, py - 1, pz + z, Blocks.field_150336_V);
                }
            }
        }
    };

    public MapGenScatteredFeatureCustom(int minSpacing, int maxSpacing, int minDistanceFromCenter, int featureSize) {
        this.minSpacing = minSpacing;
        this.maxSpacing = maxSpacing;
        this.minDistanceFromCenter = minDistanceFromCenter;
        this.featureSize = featureSize;
    }

    protected abstract boolean canStructureSpawn(int var1, int var2, double var3, Random var5);

    protected abstract String getStructureName();

    protected final boolean func_75047_a(int x, int z) {
        int origChunkX = x;
        int origChunkZ = z;
        if (x < 0) {
            x -= this.maxSpacing - 1;
        }
        if (z < 0) {
            z -= this.maxSpacing - 1;
        }
        int x2 = x / this.maxSpacing;
        int z2 = z / this.maxSpacing;
        this.coordCheckRand.setSeed((long)x2 * 341873128712L + (long)z2 * 132897987541L + this.field_75039_c.func_72912_H().func_76063_b() + 358041L);
        this.coordCheckRand.nextInt(1 + ((DragonSavefile)WorldDataHandler.get(DragonSavefile.class)).getDragonDeathAmount());
        x2 *= this.maxSpacing;
        z2 *= this.maxSpacing;
        if (origChunkX == (x2 += this.coordCheckRand.nextInt(this.maxSpacing - this.minSpacing)) && origChunkZ == (z2 += this.coordCheckRand.nextInt(this.maxSpacing - this.minSpacing))) {
            double dist = Math.sqrt(MathUtil.square((long)x2 * 16L + (long)(this.featureSize >> 1)) + MathUtil.square((long)z2 * 16L + (long)(this.featureSize >> 1)));
            return dist >= (double)this.minDistanceFromCenter && this.canStructureSpawn(x2, z2, dist, this.coordCheckRand);
        }
        return false;
    }

    public final String func_143025_a() {
        return this.getStructureName();
    }
}

