/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.sound;

import chylex.hee.sound.CustomMusicTicker;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.audio.MusicTicker;

@SideOnly(value=Side.CLIENT)
public enum EndMusicType {
    DRAGON_CALM(true),
    DRAGON_ANGRY(true),
    EXPLORATION(false);

    public final boolean isBossMusic;
    private static EndMusicType cachedType;
    private static long lastUpdateMillis;

    private EndMusicType(boolean isBossMusic) {
        this.isBossMusic = isBossMusic;
    }

    public MusicTicker.MusicType toMusicType() {
        switch (this) {
            case EXPLORATION: {
                return CustomMusicTicker.HEE_END;
            }
            case DRAGON_CALM: {
                return CustomMusicTicker.HEE_END_DRAGON_CALM;
            }
            case DRAGON_ANGRY: {
                return CustomMusicTicker.HEE_END_DRAGON_ANGRY;
            }
        }
        return null;
    }

    public static void update(EndMusicType type) {
        cachedType = type;
        lastUpdateMillis = System.currentTimeMillis();
    }

    public static EndMusicType validateAndGetMusicType() {
        if (cachedType == null || EndMusicType.cachedType.isBossMusic && System.currentTimeMillis() - lastUpdateMillis > 3000L) {
            cachedType = EXPLORATION;
        }
        return cachedType;
    }

    static {
        cachedType = null;
    }
}

