/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.entity.mob;

import chylex.hee.HardcoreEnderExpansion;
import chylex.hee.entity.GlobalMobData;
import chylex.hee.entity.fx.FXType;
import chylex.hee.entity.mob.util.IEndermanRenderer;
import chylex.hee.init.BlockList;
import chylex.hee.mechanics.causatum.CausatumMeters;
import chylex.hee.mechanics.causatum.CausatumUtils;
import chylex.hee.mechanics.misc.Baconizer;
import chylex.hee.mechanics.misc.HomelandEndermen;
import chylex.hee.packets.AbstractPacket;
import chylex.hee.packets.PacketPipeline;
import chylex.hee.packets.client.C20Effect;
import chylex.hee.packets.client.C21EffectEntity;
import chylex.hee.packets.client.C22EffectLine;
import chylex.hee.system.logging.Log;
import chylex.hee.system.util.BlockPosM;
import chylex.hee.system.util.MathUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.item.EntityTNTPrimed;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;

public class EntityMobHomelandEnderman
extends EntityMob
implements IEndermanRenderer,
GlobalMobData.IIgnoreEnderGoo {
    private static Block[] endermanBlockList;
    private static final UUID attackingSpeedBoostModifierUUID;
    private static final AttributeModifier attackingSpeedBoostModifier;
    private HomelandEndermen.HomelandRole homelandRole;
    private long groupId = -1L;
    private HomelandEndermen.OvertakeGroupRole overtakeGroupRole;
    private HomelandEndermen.EndermanTask currentTask = HomelandEndermen.EndermanTask.NONE;
    private int currentTaskTimer;
    private Object currentTaskData;
    private Entity lastEntityToAttack;
    private Boolean prevTeleportAttempt;
    private byte stareTimer;
    private byte fallTimer;
    private byte randomTpTimer;
    private byte attackTpTimer;
    private byte screamTimer;
    private byte recruitCooldown;
    public byte attackedRecentlyTimer;

    public EntityMobHomelandEnderman(World world) {
        super(world);
        this.func_70105_a(0.6f, 2.9f);
        this.field_70138_W = 1.0f;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(16, (Object)0);
        this.field_70180_af.func_82709_a(17, 5);
        this.field_70180_af.func_75682_a(18, (Object)0);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(40.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(7.0);
        this.updateAttributes();
    }

    private void updateAttributes() {
        if (this.homelandRole == null) {
            return;
        }
        switch (this.homelandRole) {
            case ISLAND_LEADERS: {
                boolean maxHealth = MathUtil.floatEquals(this.func_110143_aJ(), this.func_110138_aP());
                this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(70.0);
                this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(12.0);
                if (!maxHealth) break;
                this.func_70606_j(this.func_110138_aP());
                break;
            }
            case GUARD: {
                this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(15.0);
                break;
            }
            case BUSINESSMAN: {
                this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.65);
                break;
            }
            case WORKER: {
                this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.45);
            }
            case INTELLIGENCE: {
                this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(5.0);
                break;
            }
        }
    }

    public void func_70636_d() {
        block96: {
            block97: {
                long overtakeGroup;
                block98: {
                    int attempt;
                    BlockPosM tmpPos;
                    block95: {
                        this.field_70708_bq = 0;
                        if (!this.field_70170_p.field_72995_K) break block95;
                        this.refreshRoles();
                        int chance = 1 + MathUtil.floor(HardcoreEnderExpansion.proxy.getClientSidePlayer().func_70032_d((Entity)this) / 20.0f);
                        if (this.field_70146_Z.nextInt(chance) == 0) {
                            float colFactor = this.field_70146_Z.nextFloat() * 0.6f + 0.4f;
                            HardcoreEnderExpansion.fx.portalColor(this.field_70170_p, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O - 0.25, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, (this.field_70146_Z.nextDouble() - 0.5) * 2.0, -this.field_70146_Z.nextDouble(), (this.field_70146_Z.nextDouble() - 0.5) * 2.0, colFactor * 0.9f, colFactor * 0.3f, colFactor);
                            if (this.homelandRole != null && this.field_70146_Z.nextInt(3) == 0) {
                                HardcoreEnderExpansion.fx.portalColor(this.field_70170_p, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O - 0.25, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, (this.field_70146_Z.nextDouble() - 0.5) * 2.0, -this.field_70146_Z.nextDouble(), (this.field_70146_Z.nextDouble() - 0.5) * 2.0, this.homelandRole.red, this.homelandRole.green, this.homelandRole.blue);
                            }
                            if (this.overtakeGroupRole != null && this.field_70146_Z.nextInt(7) == 0) {
                                HardcoreEnderExpansion.fx.portalColor(this.field_70170_p, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O - 0.25, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, (this.field_70146_Z.nextDouble() - 0.5) * 2.0, -this.field_70146_Z.nextDouble(), (this.field_70146_Z.nextDouble() - 0.5) * 2.0, 0.3f, 0.3f, 0.3f);
                            }
                        }
                        break block96;
                    }
                    if (!this.func_70089_S()) break block96;
                    if (this.homelandRole == null) {
                        this.func_70106_y();
                        return;
                    }
                    if (this.func_70026_G()) {
                        this.func_70097_a(DamageSource.field_76369_e, 1.0f);
                    }
                    if (this.func_70026_G() || this.func_70027_ad()) {
                        this.func_70784_b(null);
                        this.setScreaming(false);
                    }
                    if (!this.field_70122_E && (this.fallTimer = (byte)(this.fallTimer + 1)) > 17 + this.field_70146_Z.nextInt(15)) {
                        this.fallTimer = 0;
                        for (int attempt2 = 0; attempt2 < 500; ++attempt2) {
                            if (!this.teleportRandomly(48.0)) continue;
                            this.resetTask();
                            break;
                        }
                    }
                    this.prevTeleportAttempt = null;
                    if (this.attackedRecentlyTimer > 0) {
                        this.attackedRecentlyTimer = (byte)(this.attackedRecentlyTimer - this.field_70146_Z.nextInt(2));
                    }
                    overtakeGroup = HomelandEndermen.getOvertakeGroup(this);
                    if (this.currentTask == HomelandEndermen.EndermanTask.WAIT || this.currentTask == HomelandEndermen.EndermanTask.GET_TNT) {
                        this.field_70702_br = 0.0f;
                        this.field_70701_bs = 0.0f;
                        this.field_70143_R = 0.0f;
                        this.fallTimer = 0;
                        this.field_70163_u = 10000.0;
                        if (--this.currentTaskTimer == 0) {
                            tmpPos = BlockPosM.tmp();
                            for (attempt = 0; attempt < 100; ++attempt) {
                                tmpPos.set(this.field_70165_t + (double)this.field_70146_Z.nextInt(41) - 20.0, -1.0, (double)(this.field_70146_Z.nextInt(41) - 20)).setY(this.field_70170_p.func_72825_h(tmpPos.x, tmpPos.z) - 1);
                                if (tmpPos.getBlock((IBlockAccess)this.field_70170_p) != BlockList.end_terrain) continue;
                                this.teleportTo((double)tmpPos.x + 0.3 + this.field_70146_Z.nextDouble() * 0.4, (double)tmpPos.y + 1.0, (double)tmpPos.z + 0.3 + this.field_70146_Z.nextDouble() * 0.4, true);
                                PacketPipeline.sendToAllAround((Entity)this, 256.0, (AbstractPacket)new C20Effect(FXType.Basic.HOMELAND_ENDERMAN_TP_OVERWORLD, (Entity)this));
                                if (this.overtakeGroupRole == HomelandEndermen.OvertakeGroupRole.CHAOSMAKER) {
                                    this.setCarrying(new ItemStack(Blocks.field_150335_W));
                                    break;
                                }
                                if (this.homelandRole != HomelandEndermen.HomelandRole.COLLECTOR || this.field_70146_Z.nextInt(4) == 0) break;
                                this.setCarrying(new ItemStack(endermanBlockList[this.field_70146_Z.nextInt(endermanBlockList.length)]));
                                break;
                            }
                            this.resetTask();
                        }
                    }
                    if (overtakeGroup == -1L) {
                        int attempt3;
                        if (this.currentTask != HomelandEndermen.EndermanTask.NONE && this.currentTask != HomelandEndermen.EndermanTask.WAIT) {
                            --this.currentTaskTimer;
                            if (this.currentTask == HomelandEndermen.EndermanTask.LISTEN_TO_RECRUITER || this.currentTask == HomelandEndermen.EndermanTask.RECRUIT_TO_GROUP) {
                                this.field_70702_br = 0.0f;
                                this.field_70701_bs = 0.0f;
                                if (this.currentTaskTimer == 0 && this.currentTask == HomelandEndermen.EndermanTask.RECRUIT_TO_GROUP) {
                                    int chance = 50;
                                    int reportChance = 10;
                                    EntityMobHomelandEnderman target = (EntityMobHomelandEnderman)this.currentTaskData;
                                    switch (target.homelandRole) {
                                        case WORKER: {
                                            chance = 30;
                                            break;
                                        }
                                        case GUARD: {
                                            chance = 15;
                                            reportChance = 35;
                                            break;
                                        }
                                        case INTELLIGENCE: {
                                            chance = 80;
                                            reportChance = 22;
                                            break;
                                        }
                                        case BUSINESSMAN: {
                                            chance = 40;
                                            reportChance = 14;
                                            break;
                                        }
                                    }
                                    if (this.field_70146_Z.nextInt(100) < chance) {
                                        target.setGroupMember(this.groupId, HomelandEndermen.OvertakeGroupRole.getRandomMember(this.field_70146_Z));
                                        PacketPipeline.sendToAllAround((Entity)this, 64.0, (AbstractPacket)new C21EffectEntity(FXType.Entity.HOMELAND_ENDERMAN_RECRUIT, (Entity)this));
                                        PacketPipeline.sendToAllAround((Entity)this, 64.0, (AbstractPacket)new C21EffectEntity(FXType.Entity.HOMELAND_ENDERMAN_RECRUIT, (Entity)target));
                                        for (attempt3 = 0; attempt3 < 50 && !this.teleportRandomly(); ++attempt3) {
                                        }
                                    } else if (this.field_70146_Z.nextInt(100) < reportChance) {
                                        boolean escaped = false;
                                        double oldX = this.field_70165_t;
                                        double oldY = this.field_70163_u;
                                        double oldZ = this.field_70161_v;
                                        if (this.field_70146_Z.nextInt(5) != 0) {
                                            for (int attempt4 = 0; attempt4 < 20; ++attempt4) {
                                                if (!this.teleportRandomly()) continue;
                                                escaped = true;
                                                break;
                                            }
                                        }
                                        List<EntityMobHomelandEnderman> guards = HomelandEndermen.getByHomelandRole(this, HomelandEndermen.HomelandRole.GUARD);
                                        int amt = Math.max(3, (int)Math.round((double)guards.size() * 0.3));
                                        for (int a = 0; a < amt; ++a) {
                                            EntityMobHomelandEnderman guard = guards.get(this.field_70146_Z.nextInt(guards.size()));
                                            guard.setScreaming(true);
                                            PacketPipeline.sendToAllAround((Entity)this, 256.0, (AbstractPacket)new C22EffectLine(FXType.Line.HOMELAND_ENDERMAN_GUARD_CALL, (Entity)target, (Entity)guard));
                                            if (!escaped) {
                                                guard.teleportToEntity((Entity)this);
                                                guard.func_70784_b((Entity)this);
                                                continue;
                                            }
                                            if (this.field_70146_Z.nextInt(4) == 0) continue;
                                            guard.teleportTo(oldX + 4.0 * (this.field_70146_Z.nextDouble() - 0.5), oldY + 2.0 + this.field_70146_Z.nextDouble() * 4.0, oldZ + 4.0 * (this.field_70146_Z.nextDouble() - 0.5));
                                        }
                                    }
                                    this.recruitCooldown = (byte)120;
                                }
                            } else if (this.currentTask == HomelandEndermen.EndermanTask.STROLL) {
                                Vec3 obj;
                                if (this.currentTaskTimer > 0 && this.currentTaskTimer < 20 && this.field_70146_Z.nextInt(3) == 0 && ((obj = (Vec3)this.currentTaskData).func_72438_d(Vec3.func_72443_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v)) <= 0.5 || this.field_70146_Z.nextInt(10) == 0) && this.randomTpTimer > 30) {
                                    for (attempt = 0; attempt < 30; ++attempt) {
                                        if (!this.teleportRandomly(48.0)) continue;
                                        this.currentTaskData = Vec3.func_72443_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v);
                                        this.randomTpTimer = (byte)(this.randomTpTimer - (40 + this.field_70146_Z.nextInt(30)));
                                        break;
                                    }
                                }
                                if (this.currentTaskTimer == 0 && this.field_70146_Z.nextInt(5) == 0) {
                                    this.currentTaskTimer = 10 + this.field_70146_Z.nextInt(60);
                                }
                            } else if (this.currentTask == HomelandEndermen.EndermanTask.WALK) {
                                ChunkPosition pos = (ChunkPosition)this.currentTaskData;
                                if (MathUtil.distance(this.field_70165_t - (double)pos.field_151329_a, this.field_70163_u - (double)pos.field_151327_b, this.field_70161_v - (double)pos.field_151328_c) < 3.0) {
                                    this.resetTask();
                                }
                            } else if (this.currentTask == HomelandEndermen.EndermanTask.COMMUNICATE) {
                                this.field_70702_br = 0.0f;
                                this.field_70701_bs = 0.0f;
                            }
                            if (this.currentTaskTimer <= 0) {
                                this.resetTask();
                            }
                        } else if (this.field_70789_a == null) {
                            if (this.groupId != -1L && this.field_70146_Z.nextInt(400) == 0 && (this.recruitCooldown < -120 || (this.recruitCooldown = (byte)(this.recruitCooldown - 1)) < -120)) {
                                List<EntityMobHomelandEnderman> total = HomelandEndermen.getAll(this);
                                int groupAmt = HomelandEndermen.getInSameGroup(this).size();
                                int totalAmt = total.size();
                                if (totalAmt > 8 && (this.field_70146_Z.nextInt(5) <= 2 || groupAmt < (totalAmt >> 2) + this.field_70146_Z.nextInt(totalAmt >> 3) - this.field_70146_Z.nextInt(4))) {
                                    for (attempt3 = 0; attempt3 < 5; ++attempt3) {
                                        EntityMobHomelandEnderman enderman = total.get(this.field_70146_Z.nextInt(totalAmt));
                                        if (enderman == this || enderman.groupId != -1L || !enderman.field_70122_E || enderman.homelandRole == HomelandEndermen.HomelandRole.ISLAND_LEADERS || (double)enderman.func_70032_d((Entity)this) > 80.0 || groupAmt > 3 && (enderman.homelandRole == HomelandEndermen.HomelandRole.GUARD || enderman.homelandRole == HomelandEndermen.HomelandRole.WORKER) && this.field_70146_Z.nextInt(5) != 0) continue;
                                        boolean tp = false;
                                        for (int tpAttempt = 0; tpAttempt < 30; ++tpAttempt) {
                                            if (!this.teleportTo(enderman.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * 2.0, enderman.field_70163_u, enderman.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * 2.0)) continue;
                                            tp = true;
                                            break;
                                        }
                                        if (!tp) continue;
                                        this.currentTask = HomelandEndermen.EndermanTask.RECRUIT_TO_GROUP;
                                        this.currentTaskData = enderman;
                                        enderman.currentTask = HomelandEndermen.EndermanTask.LISTEN_TO_RECRUITER;
                                        enderman.currentTaskTimer = this.currentTaskTimer = 20 + this.field_70146_Z.nextInt(60);
                                        break;
                                    }
                                }
                            }
                            if (this.currentTask == HomelandEndermen.EndermanTask.NONE && this.field_70146_Z.nextInt(80) == 0) {
                                block6 : switch (this.homelandRole) {
                                    case ISLAND_LEADERS: {
                                        if (this.field_70146_Z.nextInt(13) == 0) {
                                            this.teleportRandomly();
                                            break;
                                        }
                                        Vec3 look = this.func_70040_Z();
                                        for (attempt = 0; attempt < 12; ++attempt) {
                                            int pathZ;
                                            int pathY;
                                            int pathX;
                                            if (attempt > 8 || this.field_70146_Z.nextInt(6) == 0) {
                                                look = Vec3.func_72443_a((double)(this.field_70146_Z.nextDouble() - 0.5), (double)0.0, (double)(this.field_70146_Z.nextDouble() - 0.5)).func_72432_b();
                                            }
                                            if (this.field_70170_p.func_147439_a(pathX = (int)(this.field_70165_t + look.field_72450_a * 16.0 + (this.field_70146_Z.nextDouble() - 0.5) * 5.0), pathY = this.field_70170_p.func_72825_h(pathX, pathZ = (int)(this.field_70161_v + look.field_72449_c * 16.0 + (this.field_70146_Z.nextDouble() - 0.5) * 5.0)) - 1, pathZ) != BlockList.end_terrain || !(MathUtil.distance(this.field_70165_t - (double)pathX, this.field_70163_u - (double)pathY, this.field_70161_v - (double)pathZ) > 5.0)) continue;
                                            this.func_70778_a(this.field_70170_p.func_72844_a((Entity)this, pathX, pathY + 1, pathZ, 30.0f, true, false, false, true));
                                            this.currentTask = HomelandEndermen.EndermanTask.STROLL;
                                            this.currentTaskTimer = 65 + this.field_70146_Z.nextInt(60);
                                            this.currentTaskData = Vec3.func_72443_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v);
                                            break block6;
                                        }
                                        break;
                                    }
                                    case BUSINESSMAN: {
                                        if (this.field_70146_Z.nextInt(18) == 0) {
                                            List<EntityMobHomelandEnderman> businessmen = HomelandEndermen.getByHomelandRole(this, HomelandEndermen.HomelandRole.BUSINESSMAN);
                                            if (businessmen.isEmpty()) break;
                                            EntityMobHomelandEnderman enderman = businessmen.get(this.field_70146_Z.nextInt(businessmen.size()));
                                            if (enderman.currentTask != HomelandEndermen.EndermanTask.NONE) break;
                                            for (int tpAttempt = 0; tpAttempt < 20; ++tpAttempt) {
                                                if (!this.teleportTo(enderman.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * 2.0, enderman.field_70163_u, enderman.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * 2.0)) continue;
                                                this.currentTask = enderman.currentTask = HomelandEndermen.EndermanTask.COMMUNICATE;
                                                this.currentTaskTimer = enderman.currentTaskTimer = 30 + this.field_70146_Z.nextInt(50 + this.field_70146_Z.nextInt(80));
                                                break block6;
                                            }
                                        } else {
                                            if (this.field_70146_Z.nextInt(10) != 0) break;
                                            for (attempt3 = 0; attempt3 < 10; ++attempt3) {
                                                int walkToZ;
                                                int walkToY;
                                                int walkToX = (int)this.field_70165_t + this.field_70146_Z.nextInt(251) - 125;
                                                if (this.field_70170_p.func_147439_a(walkToX, walkToY = this.field_70170_p.func_72825_h(walkToX, walkToZ = (int)this.field_70161_v + this.field_70146_Z.nextInt(251) - 125) - 1, walkToZ) != BlockList.end_terrain) continue;
                                                this.func_70778_a(this.field_70170_p.func_72844_a((Entity)this, walkToX, walkToY + 1, walkToZ, 100.0f, true, false, false, true));
                                                this.currentTask = HomelandEndermen.EndermanTask.WALK;
                                                this.currentTaskTimer = 200 + this.field_70146_Z.nextInt(100);
                                                this.currentTaskData = new ChunkPosition(walkToX, walkToY, walkToZ);
                                                break block6;
                                            }
                                        }
                                        break;
                                    }
                                    case WORKER: {
                                        if (this.field_70146_Z.nextInt(270) != 0 || BlockPosM.tmp((Entity)this).moveUp().getBlock((IBlockAccess)this.field_70170_p) == BlockList.ender_goo) break;
                                        tmpPos = BlockPosM.tmp();
                                        for (attempt = 0; attempt < 50; ++attempt) {
                                            tmpPos.set(this.field_70165_t + (double)this.field_70146_Z.nextInt(71) - 35.0, -1.0, this.field_70161_v + (double)this.field_70146_Z.nextInt(71) - 35.0).setY(this.field_70170_p.func_72825_h(tmpPos.x, tmpPos.z) - 1);
                                            if (tmpPos.getBlock((IBlockAccess)this.field_70170_p) != BlockList.ender_goo) continue;
                                            tmpPos.x = (int)((double)tmpPos.x + (0.5 + (this.field_70146_Z.nextDouble() - 0.5) * 0.3));
                                            tmpPos.y = (int)((double)tmpPos.y + 1.0);
                                            tmpPos.z = (int)((double)tmpPos.z + (0.5 + (this.field_70146_Z.nextDouble() - 0.5) * 0.3));
                                            PacketPipeline.sendToAllAround((Entity)this, 256.0, (AbstractPacket)new C22EffectLine(FXType.Line.ENDERMAN_TELEPORT, this.field_70165_t, this.field_70163_u, this.field_70161_v, tmpPos.x, tmpPos.y, tmpPos.z));
                                            this.teleportTo(tmpPos.x, tmpPos.y, tmpPos.z, true);
                                            break block6;
                                        }
                                        break;
                                    }
                                    case COLLECTOR: {
                                        if (this.field_70146_Z.nextInt(30) != 0 || this.isCarrying() && this.field_70146_Z.nextInt(4) != 0) break;
                                        PacketPipeline.sendToAllAround((Entity)this, 256.0, (AbstractPacket)new C20Effect(FXType.Basic.HOMELAND_ENDERMAN_TP_OVERWORLD, (Entity)this));
                                        this.currentTask = HomelandEndermen.EndermanTask.WAIT;
                                        this.currentTaskTimer = 150 + this.field_70146_Z.nextInt(600 + this.field_70146_Z.nextInt(1800));
                                        this.setCarrying(null);
                                        this.teleportTo(this.field_70165_t, 10000.0, this.field_70161_v, true);
                                        break;
                                    }
                                    case OVERWORLD_EXPLORER: {
                                        if (this.field_70146_Z.nextInt(140) != 0) break;
                                        this.currentTask = HomelandEndermen.EndermanTask.WAIT;
                                        this.currentTaskTimer = 500 + this.field_70146_Z.nextInt(800) + this.field_70146_Z.nextInt(1000) * (1 + this.field_70146_Z.nextInt(4));
                                        List<EntityMobHomelandEnderman> explorers = HomelandEndermen.getByHomelandRole(this, HomelandEndermen.HomelandRole.OVERWORLD_EXPLORER);
                                        for (int a = 0; a < 1 + this.field_70146_Z.nextInt(7) && !explorers.isEmpty() && this.field_70146_Z.nextInt(3) != 0; ++a) {
                                            EntityMobHomelandEnderman enderman = explorers.remove(this.field_70146_Z.nextInt(explorers.size()));
                                            if (enderman == this) continue;
                                            PacketPipeline.sendToAllAround((Entity)this, 256.0, (AbstractPacket)new C20Effect(FXType.Basic.HOMELAND_ENDERMAN_TP_OVERWORLD, (Entity)enderman));
                                            enderman.currentTask = HomelandEndermen.EndermanTask.WAIT;
                                            enderman.currentTaskTimer = this.currentTaskTimer + this.field_70146_Z.nextInt(500);
                                            enderman.teleportTo(enderman.field_70165_t, 10000.0, enderman.field_70161_v, true);
                                        }
                                        PacketPipeline.sendToAllAround((Entity)this, 256.0, (AbstractPacket)new C20Effect(FXType.Basic.HOMELAND_ENDERMAN_TP_OVERWORLD, (Entity)this));
                                        this.teleportTo(this.field_70165_t, 10000.0, this.field_70161_v, true);
                                        break;
                                    }
                                }
                            }
                        }
                    }
                    if (overtakeGroup == -1L) break block97;
                    if (overtakeGroup != this.groupId) break block98;
                    if (this.currentTask == HomelandEndermen.EndermanTask.NONE) {
                        block13 : switch (this.overtakeGroupRole) {
                            case TELEPORTER: {
                                if (this.field_70146_Z.nextInt(8) != 0) break;
                                this.teleportRandomly(12.0);
                                break;
                            }
                            case CHAOSMAKER: {
                                if (this.isCarrying() && this.getCarrying().func_77973_b() == Item.func_150898_a((Block)Blocks.field_150335_W)) {
                                    if (this.field_70146_Z.nextInt(50) != 0) break;
                                    BlockPosM tmpPos2 = BlockPosM.tmp();
                                    BlockPosM testPos = new BlockPosM();
                                    for (int attempt5 = 0; attempt5 < 30; ++attempt5) {
                                        tmpPos2.set((Entity)this).move(this.field_70146_Z.nextInt(7) - 3, this.field_70146_Z.nextInt(3) - 1, this.field_70146_Z.nextInt(7) - 3);
                                        if (tmpPos2.getBlock((IBlockAccess)this.field_70170_p) != BlockList.end_terrain || !testPos.set(tmpPos2).moveUp().isAir(this.field_70170_p)) continue;
                                        this.field_70170_p.func_72838_d((Entity)new EntityTNTPrimed(this.field_70170_p, (double)tmpPos2.x + 0.5, (double)tmpPos2.y + 1.5, (double)tmpPos2.z + 0.5, (EntityLivingBase)this));
                                        this.setCarrying(null);
                                        break block13;
                                    }
                                    break;
                                }
                                PacketPipeline.sendToAllAround((Entity)this, 256.0, (AbstractPacket)new C20Effect(FXType.Basic.HOMELAND_ENDERMAN_TP_OVERWORLD, (Entity)this));
                                this.currentTask = HomelandEndermen.EndermanTask.GET_TNT;
                                this.currentTaskTimer = 30 + this.field_70146_Z.nextInt(80);
                                this.func_70107_b(this.field_70165_t, 10000.0, this.field_70161_v);
                                break;
                            }
                            case LEADER: 
                            case FIGHTER: {
                                List<EntityMobHomelandEnderman> list;
                                if (this.field_70789_a instanceof EntityMobHomelandEnderman) break;
                                EntityMobHomelandEnderman target = null;
                                if (!(this.overtakeGroupRole != HomelandEndermen.OvertakeGroupRole.LEADER && this.field_70146_Z.nextInt(4) != 0 || (list = HomelandEndermen.getByHomelandRole(this, HomelandEndermen.HomelandRole.ISLAND_LEADERS)).isEmpty())) {
                                    target = list.get(this.field_70146_Z.nextInt(list.size()));
                                }
                                if (target == null) {
                                    List<EntityMobHomelandEnderman> other = HomelandEndermen.getAll(this);
                                    int size = other.size();
                                    for (int attempt6 = 0; attempt6 < 10; ++attempt6) {
                                        EntityMobHomelandEnderman potentialTarget = other.get(this.field_70146_Z.nextInt(size));
                                        if (potentialTarget == this || potentialTarget.isInSameGroup(this)) continue;
                                        HomelandEndermen.HomelandRole role = potentialTarget.homelandRole;
                                        if (role == HomelandEndermen.HomelandRole.GUARD && this.field_70146_Z.nextInt(3) != 0) {
                                            target = potentialTarget;
                                            break;
                                        }
                                        if (role == HomelandEndermen.HomelandRole.WORKER && this.field_70146_Z.nextInt(5) > 1) break;
                                        target = potentialTarget;
                                        break;
                                    }
                                }
                                this.func_70784_b((Entity)target);
                                break;
                            }
                        }
                    }
                    if (this.field_70170_p.func_72872_a(EntityTNTPrimed.class, this.field_70121_D.func_72314_b(5.0, 3.0, 5.0)).isEmpty()) break block97;
                    this.teleportRandomly();
                    break block97;
                }
                if (this.groupId != -1L) {
                    if (this.field_70146_Z.nextInt(3) == 0) {
                        this.setGroupMember(overtakeGroup, HomelandEndermen.OvertakeGroupRole.getRandomMember(this.field_70146_Z));
                    } else {
                        this.setGroupMember(-1L, null);
                    }
                } else if (this.field_70789_a == null && (this.homelandRole == HomelandEndermen.HomelandRole.GUARD && this.field_70146_Z.nextInt(30) == 0 || this.field_70146_Z.nextInt(200) == 0)) {
                    List<EntityMobHomelandEnderman> all = HomelandEndermen.getAll(this);
                    for (int attempt = 0; attempt < 4 && !all.isEmpty(); ++attempt) {
                        EntityMobHomelandEnderman enderman = all.remove(this.field_70146_Z.nextInt(all.size()));
                        if (enderman.groupId != overtakeGroup) continue;
                        this.func_70784_b((Entity)enderman);
                        break;
                    }
                }
            }
            if (this.field_70789_a != null) {
                this.attackTpTimer = (byte)(this.attackTpTimer + 1);
                if ((this.attackTpTimer > 50 + this.field_70146_Z.nextInt(30) && this.field_70146_Z.nextInt(20) == 0 || this.attackTpTimer > 120) && this.field_70789_a.func_70068_e((Entity)this) < 16.0) {
                    this.teleportRandomly(8.0);
                    this.attackTpTimer = (byte)-80;
                } else if (this.field_70789_a.func_70068_e((Entity)this) > 256.0 && this.attackTpTimer > 30 && this.teleportToEntity(this.field_70789_a)) {
                    this.attackTpTimer = (byte)-80;
                }
            } else {
                this.attackTpTimer = (byte)-80;
                if (this.currentTask == HomelandEndermen.EndermanTask.NONE && this.field_70789_a == null && (this.randomTpTimer = (byte)(this.randomTpTimer + 1)) > 70 + this.field_70146_Z.nextInt(50)) {
                    if (this.field_70146_Z.nextInt(19) == 0) {
                        for (int attempt = 0; attempt < 5 && !this.teleportRandomly(10.0); ++attempt) {
                        }
                    }
                    this.randomTpTimer = (byte)(this.randomTpTimer - (110 + this.field_70146_Z.nextInt(40)));
                }
                if (this.screamTimer > 0 && (this.screamTimer = (byte)(this.screamTimer - 1)) == 0 && this.isScreaming()) {
                    this.setScreaming(false);
                }
            }
            if (this.lastEntityToAttack != this.field_70789_a) {
                IAttributeInstance attribute = this.func_110148_a(SharedMonsterAttributes.field_111263_d);
                attribute.func_111124_b(attackingSpeedBoostModifier);
                if (this.field_70789_a != null) {
                    attribute.func_111121_a(attackingSpeedBoostModifier);
                }
                this.lastEntityToAttack = this.field_70789_a;
            }
        }
        this.field_70703_bu = false;
        if (this.field_70789_a != null) {
            this.func_70625_a(this.field_70789_a, 100.0f, 100.0f);
        }
        super.func_70636_d();
    }

    protected Entity func_70782_k() {
        if (this.field_70170_p.field_72995_K) {
            return null;
        }
        List players = this.field_70170_p.field_73010_i;
        for (EntityPlayer player : players) {
            if (player.field_71075_bZ.field_75102_a || !(this.func_70068_e((Entity)player) <= 4096.0)) continue;
            if (this.isPlayerStaringIntoEyes(player)) {
                if (!this.shouldActHostile((Entity)player) && this.teleportRandomly(10.0)) {
                    return null;
                }
                if (this.stareTimer == 0) {
                    this.field_70170_p.func_72908_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, "mob.endermen.stare", 1.0f, 1.0f);
                }
                byte by = this.stareTimer;
                this.stareTimer = (byte)(by + 1);
                if (by != 5) continue;
                this.stareTimer = 0;
                this.setScreaming(true);
                this.func_70784_b((Entity)player);
                return null;
            }
            this.stareTimer = 0;
        }
        return null;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_85032_ar()) {
            return false;
        }
        this.attackedRecentlyTimer = (byte)120;
        if (this.field_70170_p.field_72995_K) {
            return super.func_70097_a(source, amount);
        }
        if (this.field_70170_p.field_73013_u == EnumDifficulty.PEACEFUL && source.func_76346_g() instanceof EntityPlayer) {
            if (super.func_70097_a(DamageSource.field_76377_j, amount)) {
                double diffX = source.func_76346_g().field_70165_t - this.field_70165_t;
                double diffZ = source.func_76346_g().field_70161_v - this.field_70161_v;
                while (diffX * diffX + diffZ * diffZ < 1.0E-4) {
                    diffX = (Math.random() - Math.random()) * 0.01;
                    diffZ = (Math.random() - Math.random()) * 0.01;
                }
                this.field_70739_aP = (float)(Math.atan2(diffZ, diffX) * 180.0 / Math.PI) - this.field_70177_z;
                this.func_70653_a(source.func_76346_g(), amount, diffX, diffZ);
                if (this.homelandRole == HomelandEndermen.HomelandRole.ISLAND_LEADERS || this.homelandRole == HomelandEndermen.HomelandRole.GUARD || this.field_70146_Z.nextInt(3) == 0) {
                    for (int attempt = 0; attempt < 10 && !this.teleportRandomly(); ++attempt) {
                    }
                }
                return true;
            }
            return false;
        }
        if (source.func_76346_g() instanceof EntityPlayer || source.func_76346_g() instanceof EntityMobHomelandEnderman) {
            boolean callGuards = this.field_70789_a == null || this.field_70146_Z.nextInt(4) == 0;
            this.func_70784_b(source.func_76346_g());
            this.setScreaming(true);
            if (callGuards) {
                float guardPerc = 0.0f;
                float guardDist = 0.0f;
                switch (this.homelandRole) {
                    case ISLAND_LEADERS: {
                        guardPerc = 0.95f;
                        guardDist = 260.0f;
                        break;
                    }
                    case GUARD: {
                        guardPerc = 0.4f;
                        guardDist = 100.0f;
                        break;
                    }
                    case WORKER: {
                        guardPerc = this.field_70146_Z.nextFloat() * 0.2f;
                        guardDist = 30.0f;
                        break;
                    }
                    case BUSINESSMAN: 
                    case INTELLIGENCE: {
                        guardPerc = 0.1f + this.field_70146_Z.nextFloat() * 0.15f;
                        guardDist = 60.0f;
                        break;
                    }
                    case COLLECTOR: 
                    case OVERWORLD_EXPLORER: {
                        guardPerc = 0.2f + this.field_70146_Z.nextFloat() * 0.1f;
                        guardDist = 80.0f;
                        break;
                    }
                }
                guardPerc *= 0.7f + this.field_70146_Z.nextFloat() * 0.3f;
                List list = this.field_70170_p.func_72872_a(EntityMobHomelandEnderman.class, this.field_70121_D.func_72314_b((double)guardDist, 128.0, (double)guardDist));
                Iterator iter = list.iterator();
                while (iter.hasNext()) {
                    if (((EntityMobHomelandEnderman)iter.next()).homelandRole == HomelandEndermen.HomelandRole.GUARD) continue;
                    iter.remove();
                }
                int amt = Math.max(2, Math.round((float)list.size() * guardPerc));
                for (int a = 0; a < amt && !list.isEmpty(); ++a) {
                    EntityMobHomelandEnderman guard = (EntityMobHomelandEnderman)list.remove(this.field_70146_Z.nextInt(list.size()));
                    guard.teleportToEntity(source.func_76346_g());
                    guard.func_70784_b(source.func_76346_g());
                    guard.setScreaming(true);
                    PacketPipeline.sendToAllAround((Entity)this, 256.0, (AbstractPacket)new C22EffectLine(FXType.Line.HOMELAND_ENDERMAN_GUARD_CALL, (Entity)this, (Entity)guard));
                }
            }
        } else if (source instanceof EntityDamageSourceIndirect) {
            for (int attempt = 0; attempt < 64; ++attempt) {
                if (!this.teleportRandomly()) continue;
                this.func_70784_b(null);
                this.setScreaming(false);
                return true;
            }
        }
        if (super.func_70097_a(source, amount)) {
            CausatumUtils.increase(source, CausatumMeters.END_MOB_DAMAGE, amount);
            return true;
        }
        return false;
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74774_a("homelandRole", (byte)this.homelandRole.ordinal());
        nbt.func_74772_a("groupId", this.groupId);
        if (this.groupId != -1L) {
            nbt.func_74774_a("groupRole", (byte)this.overtakeGroupRole.ordinal());
        }
        if (this.currentTask == HomelandEndermen.EndermanTask.WAIT) {
            nbt.func_74768_a("wait", this.currentTaskTimer);
        } else if (this.currentTask == HomelandEndermen.EndermanTask.GET_TNT) {
            nbt.func_74768_a("gettnt", this.currentTaskTimer);
        }
        ItemStack carrying = this.getCarrying();
        if (carrying != null) {
            nbt.func_74782_a("carrying", (NBTBase)carrying.func_77955_b(new NBTTagCompound()));
        }
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        byte homelandRoleId = nbt.func_74771_c("homelandRole");
        this.homelandRole = homelandRoleId >= 0 && homelandRoleId < HomelandEndermen.HomelandRole.values.length ? HomelandEndermen.HomelandRole.values[homelandRoleId] : null;
        this.groupId = nbt.func_74763_f("groupId");
        if (this.groupId != -1L) {
            byte groupRoleId = nbt.func_74771_c("groupRole");
            HomelandEndermen.OvertakeGroupRole overtakeGroupRole = this.overtakeGroupRole = groupRoleId >= 0 && groupRoleId < HomelandEndermen.OvertakeGroupRole.values.length ? HomelandEndermen.OvertakeGroupRole.values[groupRoleId] : null;
        }
        if (this.groupId != -1L && this.overtakeGroupRole == null) {
            Log.warn("Homeland Enderman overtake group role is null, resetting group membership.", new Object[0]);
            this.groupId = -1L;
        }
        if (nbt.func_74764_b("wait")) {
            this.currentTask = HomelandEndermen.EndermanTask.WAIT;
            this.currentTaskTimer = nbt.func_74762_e("wait");
            this.field_70163_u = 10000.0;
        } else if (nbt.func_74764_b("gettnt")) {
            this.currentTask = HomelandEndermen.EndermanTask.GET_TNT;
            this.currentTaskTimer = nbt.func_74762_e("gettnt");
            this.field_70163_u = 10000.0;
        }
        if (nbt.func_74764_b("carrying")) {
            this.setCarrying(ItemStack.func_77949_a((NBTTagCompound)nbt.func_74775_l("carrying")));
        }
        if (this.homelandRole == null || this.groupId != -1L && this.overtakeGroupRole == null) {
            this.func_70106_y();
        } else if (!this.field_70170_p.field_72995_K) {
            this.refreshRoles();
        }
        this.updateAttributes();
    }

    public void func_70029_a(World world) {
        super.func_70029_a(world);
        this.refreshRoles();
    }

    public void func_70784_b(Entity target) {
        if (this.field_70170_p.field_73013_u == EnumDifficulty.PEACEFUL && target instanceof EntityPlayer) {
            return;
        }
        super.func_70784_b(target);
        if (this.field_70789_a != null) {
            this.resetTask();
            this.func_70778_a(this.field_70170_p.func_72865_a((Entity)this, this.field_70789_a, 16.0f, true, false, false, true));
        }
    }

    private void resetTask() {
        this.currentTask = HomelandEndermen.EndermanTask.NONE;
        this.currentTaskTimer = 0;
        this.currentTaskData = null;
    }

    public IEntityLivingData func_110161_a(IEntityLivingData data) {
        this.setHomelandRole(HomelandEndermen.HomelandRole.getRandomRole(this.field_70146_Z));
        this.refreshRoles();
        return data;
    }

    public String func_70005_c_() {
        return this.func_94056_bM() ? this.func_94057_bL() : StatCollector.func_74838_a((String)Baconizer.mobName("entity.homelandEnderman.name"));
    }

    protected void func_70623_bb() {
    }

    private boolean canTeleport() {
        if (HomelandEndermen.isOvertakeHappening(this)) {
            return HomelandEndermen.getOvertakeGroup(this) == this.groupId || this.field_70146_Z.nextInt(100) > 30 + this.field_70146_Z.nextInt(50) + 12 * HomelandEndermen.getByGroupRole(this, HomelandEndermen.OvertakeGroupRole.TELEPORTER).size();
        }
        return true;
    }

    private boolean shouldActHostile(Entity entity) {
        if (this.field_70170_p.field_73013_u == EnumDifficulty.PEACEFUL && entity instanceof EntityPlayer) {
            return false;
        }
        if (this.homelandRole == HomelandEndermen.HomelandRole.ISLAND_LEADERS || this.groupId != -1L && this.field_70146_Z.nextInt(5) != 0 || HomelandEndermen.isOvertakeHappening(this)) {
            return false;
        }
        return this.field_70146_Z.nextInt(3) != 0;
    }

    public void refreshRoles() {
        if (this.field_70170_p == null) {
            return;
        }
        if (!this.field_70170_p.field_72995_K) {
            int data = (this.homelandRole.ordinal() & 0xF) << 4;
            if (this.overtakeGroupRole != null) {
                data |= this.overtakeGroupRole.ordinal() + 1 & 0xF;
            }
            this.field_70180_af.func_75692_b(18, (Object)((byte)data));
        } else {
            byte data = this.field_70180_af.func_75683_a(18);
            this.homelandRole = HomelandEndermen.HomelandRole.values[data >> 4 & 0xF];
            if ((data & 0xF) > 0) {
                this.overtakeGroupRole = HomelandEndermen.OvertakeGroupRole.values[(data & 0xF) - 1];
            }
        }
    }

    public void setHomelandRole(HomelandEndermen.HomelandRole role) {
        this.homelandRole = role;
        this.refreshRoles();
        this.updateAttributes();
    }

    public HomelandEndermen.HomelandRole getHomelandRole() {
        return this.homelandRole;
    }

    public long setNewGroupLeader() {
        if (this.homelandRole == HomelandEndermen.HomelandRole.ISLAND_LEADERS) {
            return -1L;
        }
        this.overtakeGroupRole = HomelandEndermen.OvertakeGroupRole.LEADER;
        this.groupId = UUID.randomUUID().getLeastSignificantBits();
        return this.groupId;
    }

    public void setGroupMember(long groupId, HomelandEndermen.OvertakeGroupRole role) {
        this.groupId = groupId;
        this.overtakeGroupRole = role;
        this.refreshRoles();
    }

    public HomelandEndermen.OvertakeGroupRole getGroupRole() {
        return this.overtakeGroupRole;
    }

    public long getGroupId() {
        return this.groupId;
    }

    public boolean isInSameGroup(EntityMobHomelandEnderman enderman) {
        return this.groupId == enderman.groupId;
    }

    public void setCarrying(ItemStack is) {
        this.field_70180_af.func_75692_b(17, (Object)is);
    }

    @Override
    public boolean isCarrying() {
        return this.getCarrying() != null;
    }

    @Override
    public ItemStack getCarrying() {
        return this.field_70180_af.func_82710_f(17);
    }

    public void setScreaming(boolean isScreaming) {
        this.field_70180_af.func_75692_b(16, (Object)((byte)(isScreaming ? 1 : 0)));
        this.screamTimer = isScreaming ? (byte)(60 + this.field_70146_Z.nextInt(50)) : (byte)0;
    }

    @Override
    public boolean isScreaming() {
        return this.field_70180_af.func_75683_a(16) == 1;
    }

    public boolean teleportRandomly() {
        return this.teleportTo(this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * 64.0, this.field_70163_u + (double)(this.field_70146_Z.nextInt(64) - 32), this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * 64.0);
    }

    public boolean teleportRandomly(double maxDist) {
        return this.teleportTo(this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * 2.0 * maxDist, this.field_70163_u + ((double)this.field_70146_Z.nextInt((int)maxDist) - maxDist * 0.5), this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * 2.0 * maxDist);
    }

    public boolean teleportToEntity(Entity entity) {
        Vec3 vec = Vec3.func_72443_a((double)(this.field_70165_t - entity.field_70165_t), (double)(this.field_70121_D.field_72338_b + (double)(this.field_70131_O / 2.0f) - entity.field_70163_u + (double)entity.func_70047_e()), (double)(this.field_70161_v - entity.field_70161_v)).func_72432_b();
        double newX = this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * 8.0 - vec.field_72450_a * 16.0;
        double newY = this.field_70163_u + (double)(this.field_70146_Z.nextInt(16) - 8) - vec.field_72448_b * 16.0;
        double newZ = this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * 8.0 - vec.field_72449_c * 16.0;
        return this.teleportTo(newX, newY, newZ);
    }

    public boolean teleportTo(double x, double y, double z) {
        return this.teleportTo(x, y, z, false);
    }

    private boolean teleportTo(double x, double y, double z, boolean ignoreChecks) {
        if (this.prevTeleportAttempt != null) {
            return this.prevTeleportAttempt;
        }
        this.prevTeleportAttempt = this.canTeleport();
        if (!this.prevTeleportAttempt.booleanValue()) {
            return false;
        }
        double oldX = this.field_70165_t;
        double oldY = this.field_70163_u;
        double oldZ = this.field_70161_v;
        this.field_70165_t = x;
        this.field_70163_u = y;
        this.field_70161_v = z;
        boolean hasTeleported = false;
        BlockPosM tmpPos = BlockPosM.tmp((Entity)this);
        if (this.field_70170_p.func_72899_e(tmpPos.x, tmpPos.y, tmpPos.z) || ignoreChecks) {
            boolean foundTopBlock = ignoreChecks;
            while (!foundTopBlock && tmpPos.y > 0) {
                if (tmpPos.moveDown().getMaterial((IBlockAccess)this.field_70170_p).func_76230_c() && tmpPos.getBlock((IBlockAccess)this.field_70170_p) != BlockList.persegrit) {
                    foundTopBlock = true;
                    continue;
                }
                this.field_70163_u -= 1.0;
            }
            if (foundTopBlock) {
                this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                if (this.field_70170_p.func_72945_a((Entity)this, this.field_70121_D).isEmpty() && !this.field_70170_p.func_72953_d(this.field_70121_D) || ignoreChecks) {
                    hasTeleported = true;
                }
            }
        }
        if (!hasTeleported) {
            this.func_70107_b(oldX, oldY, oldZ);
            return false;
        }
        if (!this.field_70170_p.field_72995_K && !ignoreChecks) {
            PacketPipeline.sendToAllAround((Entity)this, 256.0, (AbstractPacket)new C22EffectLine(FXType.Line.ENDERMAN_TELEPORT, oldX, oldY, oldZ, this.field_70165_t, this.field_70163_u, this.field_70161_v));
        }
        return true;
    }

    private boolean isPlayerStaringIntoEyes(EntityPlayer player) {
        ItemStack is = player.field_71071_by.field_70460_b[3];
        if (is != null && is.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150423_aK)) {
            return false;
        }
        Vec3 playerLook = player.func_70676_i(1.0f).func_72432_b();
        Vec3 eyeVecDiff = Vec3.func_72443_a((double)(this.field_70165_t - player.field_70165_t), (double)(this.field_70121_D.field_72338_b + (double)(this.field_70131_O * 0.5f) - (player.field_70163_u + (double)player.func_70047_e())), (double)(this.field_70161_v - player.field_70161_v));
        double eyeVecLen = eyeVecDiff.func_72433_c();
        return playerLook.func_72430_b(eyeVecDiff.func_72432_b()) > 1.0 - 0.025 / eyeVecLen && player.func_70685_l((Entity)this);
    }

    protected String func_70639_aQ() {
        return Baconizer.soundNormal(this.isScreaming() ? "mob.endermen.scream" : "mob.endermen.idle");
    }

    protected String func_70621_aR() {
        return Baconizer.soundNormal("mob.endermen.hit");
    }

    protected String func_70673_aS() {
        return Baconizer.soundDeath("mob.endermen.death");
    }

    protected Item func_146068_u() {
        return Items.field_151079_bi;
    }

    protected void func_70628_a(boolean recentlyHit, int looting) {
        Item item = this.func_146068_u();
        if (item != null) {
            int total = this.field_70146_Z.nextInt(2 + looting);
            for (int a = 0; a < total; ++a) {
                this.func_145779_a(item, 1);
            }
        }
    }

    public void func_70071_h_() {
        if (ForgeHooks.onLivingUpdate((EntityLivingBase)this)) {
            return;
        }
        this.func_70030_z();
        if (!this.field_70170_p.field_72995_K && this.field_70173_aa % 20 == 0) {
            this.func_110142_aN().func_94549_h();
        }
        this.func_70636_d();
        double xDiff = this.field_70165_t - this.field_70169_q;
        double zDiff = this.field_70161_v - this.field_70166_s;
        float distanceMoved = (float)(xDiff * xDiff + zDiff * zDiff);
        float yawOffset = this.field_70761_aq;
        float f2 = 0.0f;
        float f3 = 0.0f;
        this.field_70768_au = this.field_110154_aX;
        if (distanceMoved > 0.0025f) {
            f3 = 1.0f;
            f2 = (float)Math.sqrt(distanceMoved) * 3.0f;
            yawOffset = (float)Math.atan2(zDiff, xDiff) * 180.0f / (float)Math.PI - 90.0f;
        }
        if (this.field_70733_aJ > 0.0f) {
            yawOffset = this.field_70177_z;
        }
        if (!this.field_70122_E) {
            f3 = 0.0f;
        }
        this.field_110154_aX += (f3 - this.field_110154_aX) * 0.3f;
        this.field_70170_p.field_72984_F.func_76320_a("headTurn");
        f2 = this.func_110146_f(yawOffset, f2);
        this.field_70170_p.field_72984_F.func_76319_b();
        this.field_70170_p.field_72984_F.func_76320_a("rangeChecks");
        while (this.field_70177_z - this.field_70126_B < -180.0f) {
            this.field_70126_B -= 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B >= 180.0f) {
            this.field_70126_B += 360.0f;
        }
        while (this.field_70761_aq - this.field_70760_ar < -180.0f) {
            this.field_70760_ar -= 360.0f;
        }
        while (this.field_70761_aq - this.field_70760_ar >= 180.0f) {
            this.field_70760_ar += 360.0f;
        }
        while (this.field_70125_A - this.field_70127_C < -180.0f) {
            this.field_70127_C -= 360.0f;
        }
        while (this.field_70125_A - this.field_70127_C >= 180.0f) {
            this.field_70127_C += 360.0f;
        }
        while (this.field_70759_as - this.field_70758_at < -180.0f) {
            this.field_70758_at -= 360.0f;
        }
        while (this.field_70759_as - this.field_70758_at >= 180.0f) {
            this.field_70758_at += 360.0f;
        }
        this.field_70170_p.field_72984_F.func_76319_b();
        this.field_70764_aw += f2;
        if (!this.field_70170_p.field_72995_K) {
            this.func_110159_bB();
        }
    }

    static {
        ArrayList<Block> blocks = new ArrayList<Block>();
        for (String blockName : Block.field_149771_c.func_148742_b()) {
            Block block = Block.func_149684_b((String)blockName);
            if (!EntityEnderman.getCarriable((Block)block)) continue;
            blocks.add(block);
        }
        endermanBlockList = blocks.isEmpty() ? new Block[]{Blocks.field_150349_c, Blocks.field_150346_d, Blocks.field_150354_m, Blocks.field_150351_n, Blocks.field_150327_N, Blocks.field_150328_O, Blocks.field_150338_P, Blocks.field_150337_Q, Blocks.field_150335_W, Blocks.field_150434_aF, Blocks.field_150435_aG, Blocks.field_150423_aK, Blocks.field_150440_ba, Blocks.field_150391_bh} : blocks.toArray(new Block[blocks.size()]);
        attackingSpeedBoostModifierUUID = UUID.fromString("020E0DFB-87AE-4653-9556-831010E291A0");
        attackingSpeedBoostModifier = new AttributeModifier(attackingSpeedBoostModifierUUID, "Attacking speed boost", 6.2, 0).func_111168_a(false);
    }
}

