/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.api.message.element;

import chylex.hee.api.message.element.base.Precondition;
import net.minecraft.nbt.NBTBase;

public class IntValue
extends Precondition<Integer> {
    private int minValue;
    private int maxValue;

    public static final IntValue any() {
        return new IntValue(Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public static final IntValue positive() {
        return new IntValue(1, Integer.MAX_VALUE);
    }

    public static final IntValue negative() {
        return new IntValue(Integer.MIN_VALUE, -1);
    }

    public static final IntValue positiveOrZero() {
        return new IntValue(0, Integer.MAX_VALUE);
    }

    public static final IntValue negativeOrZero() {
        return new IntValue(Integer.MIN_VALUE, 0);
    }

    public static final IntValue range(int minValue, int maxValue) {
        return new IntValue(minValue, maxValue);
    }

    private IntValue(int minValue, int maxValue) {
        this.minValue = minValue;
        this.maxValue = maxValue;
    }

    @Override
    public boolean checkType(NBTBase tag) {
        return tag != null && (tag.func_74732_a() == 3 || tag.func_74732_a() == 1 || tag.func_74732_a() == 2 || tag.func_74732_a() == 4);
    }

    @Override
    public boolean checkValue(NBTBase tag) {
        int value = ((NBTBase.NBTPrimitive)tag).func_150287_d();
        return value >= this.minValue && value <= this.maxValue;
    }

    @Override
    public Integer getValue(NBTBase tag) {
        return ((NBTBase.NBTPrimitive)tag).func_150287_d();
    }
}

