/*
 * Decompiled with CFR 0.152.
 */
package betterachievements.registry;

import betterachievements.api.components.page.ICustomIcon;
import betterachievements.util.LogHelper;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.Achievement;
import net.minecraft.stats.AchievementList;
import net.minecraftforge.common.AchievementPage;

public final class AchievementRegistry {
    private static AchievementRegistry instance;
    public static final AchievementPage mcPage;
    private List<Achievement> mcAchievements = new LinkedList<Achievement>();
    private Map<String, Achievement> statIdMap;
    private Map<String, ItemStack> iconMap = new LinkedHashMap<String, ItemStack>();
    private Map<String, ItemStack> userSetIcons;
    private boolean firstLoad = true;

    public static AchievementRegistry instance() {
        if (instance == null) {
            instance = new AchievementRegistry();
        }
        return instance;
    }

    private AchievementRegistry() {
        this.statIdMap = new LinkedHashMap<String, Achievement>();
        this.userSetIcons = new LinkedHashMap<String, ItemStack>();
    }

    private void init() {
        for (Object oa : AchievementList.field_76007_e) {
            Achievement achievement = (Achievement)oa;
            this.statIdMap.put(achievement.field_75975_e, achievement);
            if (AchievementPage.isAchievementInPages((Achievement)achievement)) continue;
            this.mcAchievements.add(achievement);
        }
        this.iconMap.put(mcPage.getName(), new ItemStack((Block)Blocks.field_150349_c));
        this.iconMap.putAll(this.userSetIcons);
        this.firstLoad = false;
    }

    public List<Achievement> getAchievements(AchievementPage page) {
        if (this.firstLoad) {
            this.init();
        }
        return page == mcPage ? this.mcAchievements : page.getAchievements();
    }

    public List<AchievementPage> getAllPages() {
        if (this.firstLoad) {
            this.init();
        }
        LinkedList<AchievementPage> pages = new LinkedList<AchievementPage>();
        pages.add(mcPage);
        int size = AchievementPage.getAchievementPages().size();
        for (int i = 0; i < size; ++i) {
            pages.add(AchievementPage.getAchievementPage((int)i));
        }
        return pages;
    }

    public ItemStack getItemStack(AchievementPage page) {
        if (page == null) {
            return null;
        }
        ItemStack itemStack = this.iconMap.get(page.getName());
        if (itemStack == null) {
            if (page instanceof ICustomIcon) {
                itemStack = ((ICustomIcon)page).getPageIcon();
            }
            if (itemStack == null) {
                for (Achievement achievement : page.getAchievements()) {
                    if (achievement.field_75992_c != null) continue;
                    itemStack = achievement.field_75990_d;
                    this.iconMap.put(page.getName(), itemStack);
                    break;
                }
            }
        }
        return itemStack;
    }

    public void registerIcon(String pageName, ItemStack itemStack, boolean userSet) {
        this.iconMap.put(pageName, itemStack);
        if (userSet) {
            this.userSetIcons.put(pageName, itemStack);
        }
    }

    public Achievement getAchievement(String statId) {
        return this.statIdMap.get(statId);
    }

    public String[] dumpUserSetIcons() {
        LinkedList<String> list = new LinkedList<String>();
        for (Map.Entry<String, ItemStack> entry : this.userSetIcons.entrySet()) {
            String pageName = entry.getKey();
            ItemStack itemStack = entry.getValue();
            String itemName = GameRegistry.findUniqueIdentifierFor((Item)itemStack.func_77973_b()).toString();
            String nbtCompoundTag = itemStack.func_77942_o() ? itemStack.func_77978_p().toString() : "";
            list.add(pageName + "->" + itemName + ":" + entry.getValue().func_77960_j() + ":" + nbtCompoundTag);
        }
        return list.toArray(new String[list.size()]);
    }

    public void setUserSetIcons(String[] array) {
        int i = 0;
        for (String entry : array) {
            String[] itemSplit;
            String[] split = entry.split("->");
            if (split.length != 2 || (itemSplit = split[1].split(":", 4)).length < 2) continue;
            Item item = GameRegistry.findItem((String)itemSplit[0], (String)itemSplit[1]);
            int meta = 0;
            try {
                meta = itemSplit.length > 2 ? Integer.parseInt(itemSplit[2]) : 0;
            }
            catch (NumberFormatException e) {
                LogHelper.instance().error(e, "Invalid input for meta data on entry " + i);
            }
            NBTBase nbtTag = null;
            try {
                nbtTag = itemSplit.length > 3 && !itemSplit[3].equals("") ? JsonToNBT.func_150315_a((String)itemSplit[3]) : null;
            }
            catch (NBTException e) {
                LogHelper.instance().error((Exception)((Object)e), "Invalid input for nbt data on entry " + i);
            }
            ItemStack itemStack = null;
            if (item != null) {
                itemStack = new ItemStack(item, 0, meta);
            }
            if (itemStack != null) {
                if (nbtTag != null && nbtTag instanceof NBTTagCompound) {
                    itemStack.func_77982_d((NBTTagCompound)nbtTag);
                }
                this.userSetIcons.put(split[0], itemStack);
            }
            ++i;
        }
    }

    static {
        mcPage = new AchievementPage("Minecraft", new Achievement[0]);
    }
}

