/*
 * Decompiled with CFR 0.152.
 */
package com.sinthoras.visualprospecting.database.cachebuilder;

import com.sinthoras.visualprospecting.Config;
import com.sinthoras.visualprospecting.Utils;
import com.sinthoras.visualprospecting.VP;
import com.sinthoras.visualprospecting.database.ServerCache;
import com.sinthoras.visualprospecting.database.cachebuilder.AnalysisProgressTracker;
import com.sinthoras.visualprospecting.database.cachebuilder.ChunkAnalysis;
import com.sinthoras.visualprospecting.database.cachebuilder.DetailedChunkAnalysis;
import com.sinthoras.visualprospecting.database.cachebuilder.RegionReader;
import com.sinthoras.visualprospecting.database.veintypes.VeinType;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import java.util.zip.DataFormatException;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class DimensionAnalysis {
    public final int dimensionId;
    public final String dimensionName;

    public DimensionAnalysis(int dimensionId) {
        this.dimensionId = dimensionId;
        this.dimensionName = this.getDimensionName();
    }

    public void processMinecraftWorld(Collection<File> regionFiles) {
        if (regionFiles.isEmpty()) {
            return;
        }
        ConcurrentHashMap veinBlockY = new ConcurrentHashMap();
        long dimensionSizeMB = regionFiles.stream().mapToLong(File::length).sum() >> 20;
        if (dimensionSizeMB <= (long)Config.maxDimensionSizeMBForFastScanning) {
            AnalysisProgressTracker.announceFastDimension(this.dimensionId);
            AnalysisProgressTracker.setNumberOfRegionFiles(regionFiles.size());
            ConcurrentHashMap chunksForSecondIdentificationPass = new ConcurrentHashMap();
            regionFiles.parallelStream().forEach(regionFile -> this.executeForEachGeneratedOreChunk((File)regionFile, (root, chunkX, chunkZ) -> {
                ChunkAnalysis chunk = new ChunkAnalysis(this.dimensionName);
                chunk.processMinecraftChunk(root);
                if (chunk.matchesSingleVein()) {
                    ServerCache.instance.notifyOreVeinGeneration(this.dimensionId, chunkX, chunkZ, chunk.getMatchedVein());
                    veinBlockY.put(Utils.chunkCoordsToKey(chunkX, chunkZ), chunk.getVeinBlockY());
                } else {
                    DetailedChunkAnalysis detailedChunk = new DetailedChunkAnalysis(this.dimensionId, this.dimensionName, chunkX, chunkZ);
                    detailedChunk.processMinecraftChunk(root);
                    chunksForSecondIdentificationPass.put(Utils.chunkCoordsToKey(chunkX, chunkZ), detailedChunk);
                }
            }));
            chunksForSecondIdentificationPass.values().parallelStream().forEach(chunk -> {
                chunk.cleanUpWithNeighbors(veinBlockY);
                ServerCache.instance.notifyOreVeinGeneration(this.dimensionId, chunk.chunkX, chunk.chunkZ, chunk.getMatchedVein());
            });
        } else {
            AnalysisProgressTracker.announceSlowDimension(this.dimensionId);
            AnalysisProgressTracker.setNumberOfRegionFiles(regionFiles.size() * 2);
            regionFiles.parallelStream().forEach(regionFile -> this.executeForEachGeneratedOreChunk((File)regionFile, (root, chunkX, chunkZ) -> {
                ChunkAnalysis chunk = new ChunkAnalysis(this.dimensionName);
                chunk.processMinecraftChunk(root);
                if (chunk.matchesSingleVein()) {
                    ServerCache.instance.notifyOreVeinGeneration(this.dimensionId, chunkX, chunkZ, chunk.getMatchedVein());
                    veinBlockY.put(Utils.chunkCoordsToKey(chunkX, chunkZ), chunk.getVeinBlockY());
                }
            }));
            regionFiles.parallelStream().forEach(regionFile -> this.executeForEachGeneratedOreChunk((File)regionFile, (root, chunkX, chunkZ) -> {
                if (ServerCache.instance.getOreVein((int)this.dimensionId, (int)chunkX, (int)chunkZ).veinType == VeinType.NO_VEIN) {
                    DetailedChunkAnalysis detailedChunk = new DetailedChunkAnalysis(this.dimensionId, this.dimensionName, chunkX, chunkZ);
                    detailedChunk.processMinecraftChunk(root);
                    detailedChunk.cleanUpWithNeighbors(veinBlockY);
                    ServerCache.instance.notifyOreVeinGeneration(this.dimensionId, detailedChunk.chunkX, detailedChunk.chunkZ, detailedChunk.getMatchedVein());
                }
            }));
        }
    }

    private void executeForEachGeneratedOreChunk(File regionFile, IChunkHandler chunkHandler) {
        try {
            if (!Pattern.matches("^r\\.-?\\d+\\.-?\\d+\\.mca$", regionFile.getName())) {
                VP.warn("Invalid region file found! " + regionFile.getCanonicalPath() + " continuing");
                return;
            }
            String[] parts = regionFile.getName().split("\\.");
            int regionChunkX = Integer.parseInt(parts[1]) << 5;
            int regionChunkZ = Integer.parseInt(parts[2]) << 5;
            try (RegionReader region = new RegionReader(regionFile);){
                for (int localChunkX = 0; localChunkX < 32; ++localChunkX) {
                    for (int localChunkZ = 0; localChunkZ < 32; ++localChunkZ) {
                        NBTTagList chunkTiles;
                        int chunkX = regionChunkX + localChunkX;
                        int chunkZ = regionChunkZ + localChunkZ;
                        if (chunkX != Utils.mapToCenterOreChunkCoord(chunkX) || chunkZ != Utils.mapToCenterOreChunkCoord(chunkZ) || (chunkTiles = region.getChunkTiles(localChunkX, localChunkZ)) == null) continue;
                        chunkHandler.processChunk(chunkTiles, chunkX, chunkZ);
                    }
                }
            }
            AnalysisProgressTracker.regionFileProcessed();
        }
        catch (IOException | DataFormatException e) {
            AnalysisProgressTracker.notifyCorruptFile(regionFile);
        }
    }

    private String getDimensionName() {
        WorldServer world = DimensionManager.getWorld((int)this.dimensionId);
        if (world == null) {
            return "";
        }
        WorldProvider provider = world.field_73011_w;
        return provider == null ? "" : provider.func_80007_l();
    }

    private static interface IChunkHandler {
        public void processChunk(NBTTagList var1, int var2, int var3);
    }
}

