/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils.nei;

import codechicken.nei.api.API;
import codechicken.nei.api.IConfigureNEI;
import codechicken.nei.api.IOverlayHandler;
import codechicken.nei.api.ItemFilter;
import codechicken.nei.recipe.ICraftingHandler;
import codechicken.nei.recipe.IUsageHandler;
import com.rwtema.extrautils.ExtraUtils;
import com.rwtema.extrautils.LogHelper;
import com.rwtema.extrautils.block.BlockColor;
import com.rwtema.extrautils.block.BlockDecoration;
import com.rwtema.extrautils.item.filters.AdvancedNodeUpgrades;
import com.rwtema.extrautils.item.filters.Matcher;
import com.rwtema.extrautils.nei.EnderConstructorHandler;
import com.rwtema.extrautils.nei.FMPMicroBlocksHandler;
import com.rwtema.extrautils.nei.FMPMicroBlocksOverlayHandler;
import com.rwtema.extrautils.nei.InfoHandler;
import com.rwtema.extrautils.nei.ItemFilterWrapper;
import com.rwtema.extrautils.nei.MicroBlocksHandler;
import com.rwtema.extrautils.nei.SoulHandler;
import com.rwtema.extrautils.nei.SubsetBlockClass;
import com.rwtema.extrautils.nei.SubsetItems;
import com.rwtema.extrautils.nei.SubsetItemsNBT;
import com.rwtema.extrautils.nei.ping.NEIPing;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.client.gui.inventory.GuiCrafting;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

@SideOnly(value=Side.CLIENT)
public class NEIInfoHandlerConfig
implements IConfigureNEI {
    public void loadConfig() {
        NEIPing.init();
        if (ExtraUtils.drum != null) {
            API.addSubset((String)"Extra Common.Drums", (ItemFilter)new SubsetItemsNBT(Item.func_150898_a((Block)ExtraUtils.drum)));
        }
        if (ExtraUtils.microBlocks != null) {
            API.addSubset((String)"Extra Common.Extra Microblocks", (ItemFilter)new SubsetItemsNBT(ExtraUtils.microBlocks));
        }
        if (ExtraUtils.colorBlockDataEnabled) {
            API.addSubset((String)"Extra Common.Colored Blocks", (ItemFilter)new SubsetBlockClass(BlockColor.class));
        }
        if (ExtraUtils.greenScreen != null) {
            API.addSubset((String)"Extra Common.Lapis Caelestis", (ItemFilter)new SubsetItems(Item.func_150898_a((Block)ExtraUtils.greenScreen)));
        }
        if (ExtraUtils.cobblestoneCompr != null) {
            API.addSubset((String)"Extra Common.Compressed Blocks", (ItemFilter)new SubsetItems(Item.func_150898_a((Block)ExtraUtils.cobblestoneCompr)));
        }
        if (ExtraUtils.decorative1Enabled || ExtraUtils.decorative2Enabled) {
            API.addSubset((String)"Extra Common.Decorative Blocks", (ItemFilter)new SubsetBlockClass(BlockDecoration.class));
        }
        if (ExtraUtils.generator2 != null) {
            SubsetItems s = new SubsetItems(Item.func_150898_a((Block)ExtraUtils.generator2));
            if (ExtraUtils.generator3 != null) {
                s.addItem(Item.func_150898_a((Block)ExtraUtils.generator3));
            }
            API.addSubset((String)"Extra Common.Higher Tier Generators", (ItemFilter)s);
        }
        for (Matcher matcher : AdvancedNodeUpgrades.entryList) {
            if (matcher == AdvancedNodeUpgrades.nullMatcher || matcher.type != Matcher.Type.ITEM || !matcher.shouldAddToNEI() || !matcher.isSelectable()) continue;
            String localizedName = matcher.getLocalizedName();
            localizedName = localizedName.replace(".exe", "");
            localizedName = localizedName.replaceAll("\\.", "");
            API.addSubset((String)("Extra Filtering." + localizedName), (ItemFilter)new ItemFilterWrapper(matcher));
        }
        API.registerRecipeHandler((ICraftingHandler)new EnderConstructorHandler());
        API.registerUsageHandler((IUsageHandler)new EnderConstructorHandler());
        API.registerRecipeHandler((ICraftingHandler)new InfoHandler());
        API.registerUsageHandler((IUsageHandler)new InfoHandler());
        API.registerRecipeHandler((ICraftingHandler)new SoulHandler());
        API.registerUsageHandler((IUsageHandler)new SoulHandler());
        if (Loader.isModLoaded((String)"ForgeMultipart")) {
            API.registerRecipeHandler((ICraftingHandler)new FMPMicroBlocksHandler());
            API.registerUsageHandler((IUsageHandler)new FMPMicroBlocksHandler());
            API.registerRecipeHandler((ICraftingHandler)new MicroBlocksHandler());
            API.registerUsageHandler((IUsageHandler)new MicroBlocksHandler());
            API.registerGuiOverlayHandler(GuiCrafting.class, (IOverlayHandler)new FMPMicroBlocksOverlayHandler(), (String)"microblocks");
            API.registerGuiOverlayHandler(GuiInventory.class, (IOverlayHandler)new FMPMicroBlocksOverlayHandler(63, 20), (String)"microblocks2x2");
        }
        if (ExtraUtils.colorBlockData != null) {
            API.hideItem((ItemStack)new ItemStack(ExtraUtils.colorBlockData));
        }
        LogHelper.info("Added NEI integration", new Object[0]);
    }

    public String getName() {
        return "Extra Utilities: Nei Integration";
    }

    public String getVersion() {
        return "1";
    }
}

