/*
 * Decompiled with CFR 0.152.
 */
package squeek.spiceoflife.foodtracker.commands;

import java.util.Arrays;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import squeek.spiceoflife.foodtracker.FoodHistory;
import squeek.spiceoflife.foodtracker.FoodTracker;
import squeek.spiceoflife.foodtracker.ProgressInfo;

public class CommandFoodList
extends CommandBase {
    public int func_82362_a() {
        return 0;
    }

    public boolean func_71519_b(ICommandSender commandSender) {
        return true;
    }

    public List func_71516_a(ICommandSender commandSender, String[] curArgs) {
        if (curArgs.length == 1) {
            return Arrays.asList("size", "sync");
        }
        if (curArgs.length == 2) {
            return CommandFoodList.func_71530_a((String[])curArgs, (String[])MinecraftServer.func_71276_C().func_71213_z());
        }
        return null;
    }

    public int compareTo(Object obj) {
        if (obj instanceof ICommand) {
            return super.compareTo((ICommand)obj);
        }
        return 0;
    }

    public int hashCode() {
        return this.func_71517_b().hashCode();
    }

    public String func_71517_b() {
        return "foodlist";
    }

    public String func_71518_a(ICommandSender commandSender) {
        return "/foodlist <size|sync> [player]";
    }

    public void func_71515_b(ICommandSender commandSender, String[] args) {
        if (args.length > 0) {
            boolean isOp = commandSender.func_70003_b(4, "targetOtherPlayer");
            EntityPlayerMP player = isOp && args.length > 1 ? CommandFoodList.func_82359_c((ICommandSender)commandSender, (String)args[1]) : CommandFoodList.func_71521_c((ICommandSender)commandSender);
            FoodHistory foodHistory = FoodHistory.get((EntityPlayer)player);
            if (args[0].equals("size")) {
                ProgressInfo progressInfo = foodHistory.getProgressInfo();
                int foodsEaten = progressInfo.foodsPointsEaten;
                int milestone = progressInfo.milestonesAchieved();
                int foodsUntilNextMilestone = progressInfo.foodPointsUntilNextMilestone();
                commandSender.func_145747_a((IChatComponent)new ChatComponentText("" + EnumChatFormatting.BOLD + EnumChatFormatting.DARK_AQUA + player.getDisplayName() + "'s" + EnumChatFormatting.RESET + " food stats:"));
                commandSender.func_145747_a((IChatComponent)new ChatComponentText("Half-Shanks worth eaten: " + foodsEaten));
                commandSender.func_145747_a((IChatComponent)new ChatComponentText("Bonus Hearts: " + milestone * ProgressInfo.HEARTS_PER_MILESTONE));
                commandSender.func_145747_a((IChatComponent)new ChatComponentText("Half-Shanks until next bonus heart: " + foodsUntilNextMilestone));
                return;
            }
            if (args[0].equals("sync")) {
                FoodTracker.syncFoodHistory(foodHistory);
                commandSender.func_145747_a((IChatComponent)new ChatComponentText("Synced food history for " + player.getDisplayName()));
                return;
            }
        }
        throw new WrongUsageException(this.func_71518_a(commandSender), new Object[0]);
    }

    public boolean equals(Object obj) {
        return super.equals(obj) || obj instanceof ICommand && this.compareTo(obj) == 0;
    }
}

