/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.wawla.addons.generic;

import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaEntityAccessor;
import mcp.mobius.waila.api.IWailaEntityProvider;
import mcp.mobius.waila.api.IWailaRegistrar;
import net.darkhax.wawla.util.Utilities;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class AddonGenericEntities
implements IWailaEntityProvider {
    private static String[] itemTypes = new String[]{"heldItem", "feet", "leggings", "chestplate", "helmet"};
    private static final String CONFIG_EQUIPMENT = "wawla.showEquipment";
    private static final String CONFIG_ARMOR = "wawla.showMobArmor";
    private static final String CONFIG_PET_OWNER = "wawla.pets.showOwner";
    private static final String CONFIG_PET_SITTING = "wawla.pets.sitting";
    private static final String CONFIG_AGE = "wawla.pets.age";
    private static final String CONFIG_BIRTH_COOLDOWN = "wawla.pets.cooldown";

    public Entity getWailaOverride(IWailaEntityAccessor data, IWailaConfigHandler cfg) {
        return data.getEntity();
    }

    public List<String> getWailaHead(Entity entity, List<String> tip, IWailaEntityAccessor data, IWailaConfigHandler cfg) {
        return tip;
    }

    public List<String> getWailaBody(Entity entity, List<String> tip, IWailaEntityAccessor data, IWailaConfigHandler cfg) {
        EntityTameable pet;
        if (entity instanceof EntityLiving && cfg.getConfig(CONFIG_EQUIPMENT)) {
            EntityLiving living = (EntityLiving)entity;
            for (int i = 0; i < 5; ++i) {
                ItemStack stack = living.func_71124_b(i);
                if (stack == null || !data.getPlayer().func_70093_af()) continue;
                tip.add(StatCollector.func_74838_a((String)("tooltip.wawla." + itemTypes[i])) + ": " + stack.func_82833_r());
            }
            if (cfg.getConfig(CONFIG_ARMOR) && living.func_70658_aO() > 0) {
                tip.add(StatCollector.func_74838_a((String)"tooltip.wawla.armor") + ": " + living.func_70658_aO());
            }
        }
        if (cfg.getConfig(CONFIG_PET_OWNER) && data.getNBTData().func_74764_b("OwnerUUID") && data.getNBTData().func_74779_i("OwnerUUID").length() > 0) {
            tip.add(StatCollector.func_74838_a((String)"tooltip.wawla.owner") + ": " + Utilities.getUsernameByUUID(data.getNBTData().func_74779_i("OwnerUUID")));
        }
        if (entity instanceof EntityAnimal) {
            EntityAnimal animal = (EntityAnimal)entity;
            if (cfg.getConfig(CONFIG_AGE) && animal.func_70631_g_() && animal.func_70874_b() != 0) {
                tip.add(StatCollector.func_74838_a((String)"tooltip.wawla.age") + ": " + animal.func_70874_b() / 20 * -1 + " " + StatCollector.func_74838_a((String)"tooltip.wawla.seconds"));
            } else if (cfg.getConfig(CONFIG_BIRTH_COOLDOWN) && animal.func_70874_b() != 0) {
                tip.add(StatCollector.func_74838_a((String)"tooltip.wawla.birth") + ": " + animal.func_70874_b() / 20 + " " + StatCollector.func_74838_a((String)"tooltip.wawla.seconds"));
            }
        }
        if (entity instanceof EntityTameable && cfg.getConfig(CONFIG_PET_SITTING) && (pet = (EntityTameable)entity).func_70909_n()) {
            tip.add(StatCollector.func_74838_a((String)"tooltip.wawla.sit") + ": " + pet.func_70906_o());
        }
        return tip;
    }

    public List<String> getWailaTail(Entity entity, List<String> tip, IWailaEntityAccessor data, IWailaConfigHandler cfg) {
        return tip;
    }

    public NBTTagCompound getNBTData(EntityPlayerMP player, Entity entity, NBTTagCompound tag, World world) {
        if (entity == null) {
            return tag;
        }
        if (entity instanceof EntityPlayer) {
            return tag;
        }
        entity.func_70109_d(tag);
        return tag;
    }

    public static void registerAddon(IWailaRegistrar register) {
        AddonGenericEntities dataProvider = new AddonGenericEntities();
        register.addConfig("Wawla-Entity", CONFIG_EQUIPMENT);
        register.addConfig("Wawla-Entity", CONFIG_PET_OWNER);
        register.addConfig("Wawla-Entity", CONFIG_PET_SITTING);
        register.addConfig("Wawla-Entity", CONFIG_AGE);
        register.addConfig("Wawla-Entity", CONFIG_BIRTH_COOLDOWN);
        register.addConfig("Wawla-Entity", CONFIG_ARMOR);
        register.registerBodyProvider((IWailaEntityProvider)dataProvider, Entity.class);
        register.registerNBTProvider((IWailaEntityProvider)dataProvider, Entity.class);
    }
}

