/*
 * Decompiled with CFR 0.152.
 */
package blockrenderer6343.client.world;

import blockrenderer6343.BlockRenderer6343;
import blockrenderer6343.client.utils.BRUtil;
import blockrenderer6343.client.world.DummyWorld;
import blockrenderer6343.integration.nei.StructureHacks;
import com.gtnewhorizon.gtnhlib.util.CoordinatePacker;
import com.gtnewhorizon.structurelib.alignment.constructable.IConstructable;
import com.gtnewhorizon.structurelib.alignment.constructable.IMultiblockInfoContainer;
import com.gtnewhorizon.structurelib.alignment.enumerable.ExtendedFacing;
import gregtech.api.interfaces.INEIPreviewModifier;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.threads.RunnableMachineUpdate;
import it.unimi.dsi.fastutil.longs.Long2IntMap;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.lang.reflect.InvocationTargetException;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class ObserverWorld
extends DummyWorld {
    private static final int MAX_TRIES = 64;
    private final Long2ObjectMap<Block> blockMap = new Long2ObjectOpenHashMap();
    private final Long2ObjectMap<TileEntity> tileMap = new Long2ObjectOpenHashMap();
    private final Long2IntMap blockMetaMap = new Long2IntOpenHashMap();
    private final LongSet checkedBlocks = new LongOpenHashSet();
    private Consumer<ItemStack> stackConsumer;
    private boolean hasChanged = false;

    public boolean func_147465_d(int x, int y, int z, Block block, int meta, int flags) {
        long pos = CoordinatePacker.pack((int)x, (int)y, (int)z);
        if (block == Blocks.field_150350_a) {
            this.blockMap.remove(pos);
            if (block.hasTileEntity(meta)) {
                this.func_147475_p(x, y, z);
            }
        } else {
            TileEntity tile;
            if (this.blockMap.containsKey(pos) && this.blockMap.get(pos) == block && this.blockMetaMap.get(pos) == meta) {
                return true;
            }
            this.hasChanged = true;
            this.blockMap.put(pos, (Object)block);
            this.blockMetaMap.put(pos, meta);
            this.addBlockToResult(block, pos);
            if (block.hasTileEntity(meta) && (tile = block.createTileEntity((World)this, meta)) != null) {
                this.func_147455_a(x, y, z, tile);
            }
        }
        return y >= 0 && y < 256;
    }

    public boolean func_72899_e(int x, int y, int z) {
        return this.blockMap.containsKey(CoordinatePacker.pack((int)x, (int)y, (int)z));
    }

    public Block func_147439_a(int x, int y, int z) {
        Block block = (Block)this.blockMap.get(CoordinatePacker.pack((int)x, (int)y, (int)z));
        return block == null ? Blocks.field_150350_a : block;
    }

    public int func_72805_g(int x, int y, int z) {
        return this.blockMetaMap.get(CoordinatePacker.pack((int)x, (int)y, (int)z));
    }

    public void func_147455_a(int x, int y, int z, TileEntity tile) {
        tile.func_145834_a((World)this);
        tile.field_145851_c = x;
        tile.field_145848_d = y;
        tile.field_145849_e = z;
        tile.func_145829_t();
        this.tileMap.put(CoordinatePacker.pack((int)x, (int)y, (int)z), (Object)tile);
    }

    public void func_147475_p(int x, int y, int z) {
        ((TileEntity)this.tileMap.remove(CoordinatePacker.pack((int)x, (int)y, (int)z))).func_145843_s();
    }

    public TileEntity func_147438_o(int x, int y, int z) {
        return (TileEntity)this.tileMap.get(CoordinatePacker.pack((int)x, (int)y, (int)z));
    }

    private void addBlockToResult(Block block, long pos) {
        if (this.stackConsumer == null) {
            return;
        }
        if (!this.checkedBlocks.add(BRUtil.hashBlock(this, pos))) {
            return;
        }
        ItemStack stack = new ItemStack(block, 1, BRUtil.getDamageValue(this, block, pos));
        this.stackConsumer.accept(stack);
    }

    @Nullable
    public IConstructable getConstructableFromContainer(String className, IMultiblockInfoContainer<TileEntity> container) {
        TileEntity tile = ObserverWorld.getUnsafeTile(className);
        if (tile == null) {
            return null;
        }
        this.func_147455_a(0, 64, 0, tile);
        return container.toConstructable((Object)tile, ExtendedFacing.DEFAULT);
    }

    @Nullable
    private static TileEntity getUnsafeTile(String className) {
        try {
            Class<?> clazz = Class.forName(className);
            return (TileEntity)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            return null;
        }
    }

    public int estimateTierFromInfoContainer(Long2ObjectMap<ObjectSet<IConstructable>> result, Object2ObjectMap<IConstructable, ItemStack> multiBlockStack, IConstructable constructable) {
        this.stackConsumer = e -> ((ObjectSet)result.computeIfAbsent(BRUtil.hashStack(e), k -> new ObjectOpenHashSet())).add((Object)constructable);
        int tier = this.estimateTier(constructable);
        Block block = this.func_147439_a(0, 64, 0);
        long pos = CoordinatePacker.pack((int)0, (int)64, (int)0);
        ItemStack stack = new ItemStack(block, 1, BRUtil.getDamageValue(this, block, pos));
        multiBlockStack.put((Object)constructable, (Object)stack);
        this.reset();
        return tier;
    }

    public int estimateTierFromConstructable(Consumer<ItemStack> result, IConstructable multi) {
        if (!BlockRenderer6343.isGTLoaded || !(multi instanceof IMetaTileEntity)) {
            return 0;
        }
        IMetaTileEntity metaTile = (IMetaTileEntity)multi;
        if (RunnableMachineUpdate.isCurrentThreadEnabled()) {
            RunnableMachineUpdate.setCurrentThreadEnabled((boolean)false);
        }
        ItemStack stack = metaTile.getStackForm(1L);
        BRUtil.FAKE_PLAYER.func_70029_a(this);
        stack.func_77973_b().func_77648_a(stack, (EntityPlayer)BRUtil.FAKE_PLAYER, (World)this, 0, 64, 0, 0, 0.0f, 64.0f, 0.0f);
        TileEntity tile = this.func_147438_o(0, 64, 0);
        IConstructable constructable = (IConstructable)((IGregTechTileEntity)tile).getMetaTileEntity();
        this.stackConsumer = result;
        int tier = this.estimateTier(constructable);
        if (!RunnableMachineUpdate.isCurrentThreadEnabled()) {
            RunnableMachineUpdate.setCurrentThreadEnabled((boolean)true);
        }
        this.reset();
        return tier;
    }

    private int estimateTier(IConstructable multi) {
        int tier = 0;
        ItemStack holo = StructureHacks.HOLO_STACK.func_77946_l();
        do {
            holo.field_77994_a = tier + 1;
            this.hasChanged = false;
            if (BlockRenderer6343.isGTLoaded && multi instanceof INEIPreviewModifier) {
                INEIPreviewModifier modifier = (INEIPreviewModifier)multi;
                modifier.onPreviewConstruct(holo);
            }
            multi.construct(holo, false);
        } while (tier++ < 64 && this.hasChanged);
        return tier - 1;
    }

    public void reset() {
        this.checkedBlocks.clear();
        this.blockMap.clear();
        this.tileMap.clear();
        this.blockMetaMap.clear();
    }
}

