/*
 * Decompiled with CFR 0.152.
 */
package secondderivative.irontankminecarts.minecarts;

import com.google.common.reflect.ClassPath;
import com.indemnity83.irontank.reference.TankType;
import cpw.mods.fml.common.registry.EntityRegistry;
import java.util.HashMap;
import java.util.Map;
import mods.railcraft.common.carts.EntityCartTank;
import mods.railcraft.common.core.RailcraftConfig;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import secondderivative.irontankminecarts.IronTankMinecarts;

public abstract class EntityMinecartTankAbstract
extends EntityCartTank {
    public static final Map<TankType, Class<? extends EntityMinecartTankAbstract>> map = new HashMap<TankType, Class<? extends EntityMinecartTankAbstract>>();

    public EntityMinecartTankAbstract(World world, TankType type) {
        super(world);
    }

    public EntityMinecartTankAbstract(World world, double x, double y, double z, TankType type) {
        super(world, x, y, z);
    }

    public static int getCapacity(TankType type) {
        return RailcraftConfig.getTankCartCapacity() / 16000 * 1000 * type.capacity;
    }

    public static void init() {
    }

    public ItemStack getCartItem() {
        Item minecart = IronTankMinecarts.carts.get(this.tankType());
        return new ItemStack(minecart != null ? minecart : Items.field_151143_au);
    }

    public static EntityMinecartTankAbstract makeMinecart(World world, double x, double y, double z, TankType type) {
        try {
            Class<? extends EntityMinecartTankAbstract> cls = map.get(type);
            return cls.getConstructor(World.class, Double.TYPE, Double.TYPE, Double.TYPE).newInstance(world, x, y, z);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    static {
        try {
            String name = EntityMinecartTankAbstract.class.getCanonicalName();
            name = name.substring(0, name.lastIndexOf(46));
            for (ClassPath.ClassInfo clazzInfo : ClassPath.from((ClassLoader)EntityMinecartTankAbstract.class.getClassLoader()).getTopLevelClasses(name + ".types")) {
                Class clazz = clazzInfo.load();
                if (!EntityMinecartTankAbstract.class.isAssignableFrom(clazz)) continue;
                Class cartClass = clazz;
                TankType type = ((EntityMinecartTankAbstract)((Object)cartClass.getConstructor(World.class).newInstance(new Object[]{null}))).tankType();
                String rawname = IronTankMinecarts.tankTypeName(type);
                EntityRegistry.registerModEntity((Class)cartClass, (String)("minecart_tank_" + rawname), (int)type.ordinal(), (Object)IronTankMinecarts.instance, (int)80, (int)3, (boolean)true);
                map.put(type, cartClass);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

