/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.renderer;

public class Parameter<T> {
    private T defaultValue;
    private T value;

    public Parameter(T defaultValue) {
        this.defaultValue = defaultValue;
    }

    public T getDefault() {
        return this.defaultValue;
    }

    public T getValue() {
        return this.value;
    }

    public void reset() {
        this.value = this.defaultValue;
    }

    public T get() {
        return this.value != null ? this.value : this.defaultValue;
    }

    public void set(T value) {
        this.value = value;
    }

    public Object get(int index) {
        if (this.value == null) {
            return this.value;
        }
        if (this.value != null && !(this.value instanceof Object[])) {
            throw new IllegalStateException("Trying to access indexed element of non-array Parameter");
        }
        Object[] v = (Object[])this.value;
        if (index < 0 || index >= v.length) {
            return null;
        }
        return v[index];
    }

    public void merge(Parameter<T> parameter) {
        if (parameter.getValue() != null) {
            this.value = parameter.getValue();
        }
    }

    public T merged(Parameter<T> other) {
        if (other.value != null) {
            return other.value;
        }
        if (this.value != null) {
            return this.value;
        }
        return this.defaultValue;
    }

    public String toString() {
        return this.value + " [" + this.defaultValue + "]";
    }
}

