/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.inventory.message;

import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.malisis.core.MalisisCore;
import net.malisis.core.inventory.MalisisInventory;
import net.malisis.core.inventory.MalisisInventoryContainer;
import net.malisis.core.inventory.MalisisSlot;
import net.malisis.core.network.MalisisMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;

@MalisisMessage
public class UpdateInventorySlotsMessage
implements IMessageHandler<Packet, IMessage> {
    public static int PICKEDITEM = -1;

    public UpdateInventorySlotsMessage() {
        MalisisCore.network.registerMessage(this, Packet.class, Side.CLIENT);
    }

    public IMessage onMessage(Packet message, MessageContext ctx) {
        if (ctx.side == Side.CLIENT) {
            this.updateSlots(message.inventoryId, message.slots, message.windowId);
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    private void updateSlots(int inventoryId, HashMap<Integer, ItemStack> slots, int windowId) {
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        Container c = player.field_71070_bA;
        if (windowId != c.field_75152_c || !(c instanceof MalisisInventoryContainer)) {
            return;
        }
        MalisisInventoryContainer container = (MalisisInventoryContainer)c;
        if (inventoryId == PICKEDITEM) {
            container.setPickedItemStack(slots.get(-1));
            return;
        }
        MalisisInventory inventory = container.getInventory(inventoryId);
        if (inventory == null) {
            return;
        }
        for (Map.Entry<Integer, ItemStack> entry : slots.entrySet()) {
            Integer slotNumber = entry.getKey();
            ItemStack itemStack = entry.getValue();
            inventory.setItemStack(slotNumber, itemStack);
        }
    }

    public static void updatePickedItemStack(ItemStack itemStack, EntityPlayerMP player, int windowId) {
        Packet packet = new Packet(PICKEDITEM, windowId);
        packet.draggedItemStack(itemStack);
        MalisisCore.network.sendTo(packet, player);
    }

    public static void updateSlots(int inventoryId, ArrayList<MalisisSlot> slots, EntityPlayerMP player, int windowId) {
        Packet packet = new Packet(inventoryId, windowId);
        for (MalisisSlot slot : slots) {
            packet.addSlot(slot);
        }
        MalisisCore.network.sendTo(packet, player);
    }

    public static class Packet
    implements IMessage {
        private int inventoryId;
        private HashMap<Integer, ItemStack> slots = new HashMap();
        private int windowId;

        public Packet() {
        }

        public Packet(int inventoryId, int windowId) {
            this.inventoryId = inventoryId;
            this.windowId = windowId;
        }

        public void addSlot(MalisisSlot slot) {
            this.slots.put(slot.slotNumber, slot.getItemStack());
        }

        public void setSlots(HashMap<Integer, ItemStack> slots) {
            if (slots != null) {
                this.slots = slots;
            }
        }

        public void draggedItemStack(ItemStack itemStack) {
            this.slots.put(-1, itemStack);
        }

        public void fromBytes(ByteBuf buf) {
            this.inventoryId = buf.readInt();
            this.windowId = buf.readInt();
            int size = buf.readInt();
            for (int i = 0; i < size; ++i) {
                this.slots.put(buf.readInt(), ByteBufUtils.readItemStack((ByteBuf)buf));
            }
        }

        public void toBytes(ByteBuf buf) {
            buf.writeInt(this.inventoryId);
            buf.writeInt(this.windowId);
            buf.writeInt(this.slots.size());
            for (Map.Entry<Integer, ItemStack> entry : this.slots.entrySet()) {
                Integer slotNumber = entry.getKey();
                ItemStack itemStack = entry.getValue();
                buf.writeInt(slotNumber.intValue());
                ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)itemStack);
            }
        }
    }
}

