/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.client.gui.component.control;

import com.google.common.eventbus.Subscribe;
import net.malisis.core.client.gui.Anchor;
import net.malisis.core.client.gui.GuiRenderer;
import net.malisis.core.client.gui.MalisisGui;
import net.malisis.core.client.gui.component.UIComponent;
import net.malisis.core.client.gui.component.control.UIScrollBar;
import net.malisis.core.client.gui.element.SimpleGuiShape;
import net.malisis.core.client.gui.event.component.StateChangeEvent;
import net.malisis.core.renderer.animation.Animation;
import net.malisis.core.renderer.animation.transformation.AlphaTransform;
import net.malisis.core.renderer.animation.transformation.Transformation;

public class UISlimScrollbar
extends UIScrollBar {
    protected int backgroundColor = 0x999999;
    protected int scrollColor = 0xFFFFFF;
    protected boolean fade = true;

    public <T extends UIComponent> UISlimScrollbar(MalisisGui gui, T parent, UIScrollBar.Type type) {
        super(gui, parent, type);
        this.setScrollSize(2, 15);
    }

    public void setFade(boolean fade) {
        this.fade = fade;
    }

    public boolean isFade() {
        return this.fade;
    }

    @Override
    protected void setPosition() {
        int vp = this.getScrollable().getVerticalPadding();
        int hp = this.getScrollable().getHorizontalPadding();
        if (this.type == UIScrollBar.Type.HORIZONTAL) {
            this.setPosition(hp + this.offsetX, -vp + this.offsetY, Anchor.BOTTOM);
        } else {
            this.setPosition(-hp + this.offsetX, vp + this.offsetY, Anchor.RIGHT);
        }
    }

    @Override
    protected void createShape(MalisisGui gui) {
        int w = this.type == UIScrollBar.Type.HORIZONTAL ? this.scrollHeight : this.scrollThickness;
        int h = this.type == UIScrollBar.Type.HORIZONTAL ? this.scrollThickness : this.scrollHeight;
        this.shape = new SimpleGuiShape();
        this.scrollShape = new SimpleGuiShape();
        this.scrollShape.setSize(w, h);
        this.scrollShape.storeState();
    }

    @Override
    public int getWidth() {
        int w = super.getWidth();
        if (this.type == UIScrollBar.Type.HORIZONTAL) {
            w -= 2 * this.getScrollable().getHorizontalPadding();
        }
        return w;
    }

    @Override
    public int getHeight() {
        int h = super.getHeight();
        if (this.type == UIScrollBar.Type.VERTICAL) {
            h -= 2 * this.getScrollable().getVerticalPadding();
        }
        return h;
    }

    public void setColor(int scrollColor) {
        this.setColor(scrollColor, this.backgroundColor);
    }

    public void setColor(int scrollColor, int backgroundColor) {
        this.scrollColor = scrollColor;
        this.backgroundColor = backgroundColor;
    }

    @Override
    public void drawBackground(GuiRenderer renderer, int mouseX, int mouseY, float partialTick) {
        renderer.disableTextures();
        this.rp.colorMultiplier.set(this.backgroundColor);
        renderer.drawShape(this.shape, this.rp);
    }

    @Override
    public void drawForeground(GuiRenderer renderer, int mouseX, int mouseY, float partialTick) {
        int ox = 0;
        int oy = 0;
        int l = this.getLength() - this.scrollHeight;
        if (this.isHorizontal()) {
            ox = (int)(this.getOffset() * (float)l);
        } else {
            oy = (int)(this.getOffset() * (float)l);
        }
        renderer.disableTextures();
        this.scrollShape.resetState();
        this.scrollShape.setPosition(ox, oy);
        this.rp.colorMultiplier.set(this.scrollColor);
        renderer.drawShape(this.scrollShape, this.rp);
    }

    @Subscribe
    public void onMouseOver(StateChangeEvent.HoveredStateChange event) {
        if (!this.fade) {
            return;
        }
        if (this.isFocused() && !event.getState()) {
            return;
        }
        int from = event.getState() ? 0 : 255;
        int to = event.getState() ? 255 : 0;
        Animation anim = new Animation(this, (Transformation)new AlphaTransform(from, to).forTicks(5));
        ((UIComponent)event.getComponent()).getGui().animate(anim);
    }
}

