/*
 * Decompiled with CFR 0.152.
 */
package com.github.dcysteine.neicustomdiagram.api.diagram.matcher;

import com.github.dcysteine.neicustomdiagram.api.diagram.Diagram;
import com.github.dcysteine.neicustomdiagram.api.diagram.component.Component;
import com.github.dcysteine.neicustomdiagram.api.diagram.interactable.Interactable;
import com.github.dcysteine.neicustomdiagram.api.diagram.matcher.DiagramMatcher;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.function.BiFunction;

public class CustomDiagramMatcher
implements DiagramMatcher {
    protected final ImmutableList<Diagram> allDiagrams;
    protected final BiFunction<Interactable.RecipeType, Component, Collection<Diagram>> diagramFunction;

    public CustomDiagramMatcher(Iterable<? extends Diagram> allDiagrams, BiFunction<Interactable.RecipeType, Component, Collection<Diagram>> diagramFunction) {
        this.allDiagrams = ImmutableList.copyOf(allDiagrams);
        this.diagramFunction = diagramFunction;
    }

    public CustomDiagramMatcher(BiFunction<Interactable.RecipeType, Component, Collection<Diagram>> diagramFunction) {
        this((Iterable<? extends Diagram>)ImmutableList.of(), diagramFunction);
    }

    @Override
    public Collection<Diagram> all() {
        return this.allDiagrams;
    }

    @Override
    public Collection<Diagram> match(Interactable.RecipeType recipeType, Component component) {
        return this.diagramFunction.apply(recipeType, component);
    }
}

