/*
 * Decompiled with CFR 0.152.
 */
package glowredman.darkerer.mixins;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.ref.LocalFloatRef;
import glowredman.darkerer.DarkererConfig;
import glowredman.darkerer.DarkererCore;
import glowredman.darkerer.Mode;
import net.minecraft.client.renderer.EntityRenderer;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={EntityRenderer.class})
public class MixinEntityRenderer {
    @Shadow
    @Final
    private int[] field_78504_Q;

    @ModifyExpressionValue(at={@At(args={"floatValue=0.03"}, value="CONSTANT"), @At(args={"floatValue=0.05"}, value="CONSTANT"), @At(args={"floatValue=0.35"}, value="CONSTANT")}, expect=9, method={"updateLightmap"})
    private float modifyMin(float original) {
        return DarkererCore.enabled ? 0.0f : original;
    }

    @ModifyExpressionValue(at={@At(args={"floatValue=0.96"}, value="CONSTANT"), @At(args={"floatValue=0.95"}, value="CONSTANT"), @At(args={"floatValue=0.65"}, value="CONSTANT")}, expect=9, method={"updateLightmap"})
    private float modifyMax(float original) {
        return DarkererCore.enabled ? 1.0f : original;
    }

    @ModifyExpressionValue(at={@At(opcode=180, target="Lnet/minecraft/world/WorldProvider;dimensionId:I", value="FIELD")}, expect=1, method={"updateLightmap"})
    private int darkenEnd(int original) {
        return DarkererCore.enabled && DarkererConfig.darkEnd ? 0 : original;
    }

    @Inject(at={@At(opcode=180, ordinal=2, target="Lnet/minecraft/client/renderer/EntityRenderer;mc:Lnet/minecraft/client/Minecraft;", value="FIELD")}, expect=1, method={"updateLightmap"})
    private void adjustNightVisionColor(CallbackInfo ci, @Local(ordinal=8) LocalFloatRef r, @Local(ordinal=9) LocalFloatRef g, @Local(ordinal=10) LocalFloatRef b) {
        r.set(r.get() * 0.9f + 0.1f);
        g.set(g.get() * 0.9f + 0.1f);
        b.set(b.get() * 0.9f + 0.1f);
    }

    @Inject(at={@At(opcode=180, target="Lnet/minecraft/client/renderer/EntityRenderer;lightmapTexture:Lnet/minecraft/client/renderer/texture/DynamicTexture;", value="FIELD")}, expect=1, method={"updateLightmap"})
    private void modifyLightmap(CallbackInfo ci) {
        if (!DarkererCore.enabled || !DarkererConfig.removeBlueSkyLight || DarkererConfig.mode == Mode.EVERYWHERE) {
            return;
        }
        for (int i = 0; i < this.field_78504_Q.length; ++i) {
            int height = i / 16;
            if (height <= 0 || height >= 16) continue;
            int red = this.field_78504_Q[i] >> 16 & 0xFF;
            if (DarkererConfig.mode == Mode.ONLY_INSIDE) {
                red = Math.min(255, red + 25);
            }
            this.field_78504_Q[i] = this.field_78504_Q[i] & 0xFF000000 | red << 16 | red << 8 | red;
        }
    }
}

