/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.integration.railcraft.signalling;

import com.google.common.collect.Sets;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import mods.railcraft.api.core.WorldCoordinate;
import mods.railcraft.api.signals.SignalAspect;
import mods.railcraft.api.signals.SignalController;
import mods.railcraft.api.signals.SignalReceiver;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import pl.asie.computronics.util.collect.SimpleInvertibleDualMap;

public class MassiveSignalController
extends SignalController {
    private boolean needsInit = true;
    private final Map<WorldCoordinate, SignalAspect> aspects = new HashMap<WorldCoordinate, SignalAspect>();
    private final SimpleInvertibleDualMap<String, WorldCoordinate> signalNames = SimpleInvertibleDualMap.create();
    private SignalAspect visualAspect = SignalAspect.BLINK_RED;
    private SignalAspect mostRestrictive;

    public MassiveSignalController(String locTag, TileEntity tile) {
        super(locTag, tile, 32);
    }

    @Nonnull
    public SignalAspect getAspectFor(WorldCoordinate coord) {
        SignalAspect aspect = this.aspects.get(coord);
        return aspect != null ? aspect : SignalAspect.GREEN;
    }

    public void setAspectFor(WorldCoordinate coord, SignalAspect aspect) {
        if (this.aspects.get(coord) != aspect) {
            this.aspects.put(coord, aspect);
            this.mostRestrictive = null;
            this.updateReceiver(coord);
        }
    }

    public boolean setAspectFor(String name, SignalAspect aspect) {
        boolean any = false;
        HashSet coords = Sets.newHashSet(this.signalNames.get(name));
        if (!coords.isEmpty()) {
            for (WorldCoordinate coord : coords) {
                this.setAspectFor(coord, aspect);
                any = true;
            }
        }
        return any;
    }

    public void setAspectForAll(SignalAspect aspect) {
        for (WorldCoordinate coord : this.getPairs()) {
            this.setAspectFor(coord, aspect);
        }
    }

    public SignalAspect getVisualAspect() {
        return this.visualAspect != null ? this.visualAspect : SignalAspect.BLINK_RED;
    }

    public void setVisualAspect(SignalAspect aspect) {
        this.visualAspect = aspect;
    }

    public String getNameFor(WorldCoordinate coord) {
        return this.signalNames.inverse().get(coord);
    }

    public Collection<WorldCoordinate> getCoordsFor(String name) {
        return this.signalNames.get(name);
    }

    public SignalAspect getMostRestrictiveAspectFor(String name) {
        SignalAspect mostRestrictive = null;
        for (WorldCoordinate coord : this.signalNames.get(name)) {
            if (mostRestrictive == null) {
                mostRestrictive = this.aspects.get(coord);
                continue;
            }
            mostRestrictive = SignalAspect.mostRestrictive((SignalAspect)mostRestrictive, (SignalAspect)this.aspects.get(coord));
        }
        return mostRestrictive != null ? mostRestrictive : SignalAspect.GREEN;
    }

    public String getNameFor(SignalController con) {
        String name = this.signalNames.inverse().get(con.getCoords());
        if (name == null && (name = con.getName()) != null) {
            this.signalNames.put(name, con.getCoords());
        }
        return name;
    }

    public SignalAspect getMostRestrictiveAspect() {
        if (this.mostRestrictive != null) {
            return this.mostRestrictive;
        }
        SignalAspect mostRestrictive = null;
        for (SignalAspect aspect : this.aspects.values()) {
            if (mostRestrictive == null) {
                mostRestrictive = aspect;
                continue;
            }
            mostRestrictive = SignalAspect.mostRestrictive((SignalAspect)mostRestrictive, (SignalAspect)aspect);
        }
        this.mostRestrictive = mostRestrictive != null ? mostRestrictive : SignalAspect.GREEN;
        return this.mostRestrictive;
    }

    public Set<String> getSignalNames() {
        return this.signalNames.keySet();
    }

    public void onPairNameChange(WorldCoordinate coords, String name) {
        super.onPairNameChange(coords, name);
        if (name != null) {
            this.signalNames.put(name, coords);
        } else {
            this.signalNames.removeValue(coords);
        }
    }

    public void tickServer() {
        super.tickServer();
        if (this.needsInit) {
            this.needsInit = false;
            this.updateReceivers();
        }
    }

    private void updateReceiver(WorldCoordinate coord, SignalReceiver receiver) {
        SignalAspect aspect = this.aspects.get(coord);
        if (receiver != null && aspect != null) {
            receiver.onControllerAspectChange((SignalController)this, aspect);
            String name = receiver.getName();
            if (name != null && !this.signalNames.containsEntry(name, coord)) {
                this.signalNames.put(name, coord);
            }
        }
    }

    private void updateReceiver(WorldCoordinate coord) {
        SignalReceiver receiver = this.getReceiverAt(coord);
        if (receiver != null) {
            this.updateReceiver(coord, receiver);
        }
    }

    private void updateReceivers() {
        for (WorldCoordinate coord : this.getPairs()) {
            this.updateReceiver(coord);
        }
    }

    public void registerReceiver(SignalReceiver receiver) {
        super.registerReceiver(receiver);
        WorldCoordinate coords = receiver.getCoords();
        String name = receiver.getName();
        if (name != null && !this.signalNames.containsEntry(name, coords)) {
            this.signalNames.put(name, coords);
        }
    }

    public void cleanPairings() {
        super.cleanPairings();
        Collection pairs = this.getPairs();
        if (this.aspects.keySet().retainAll(pairs)) {
            this.mostRestrictive = null;
        }
        this.signalNames.retainAllValues(pairs);
    }

    public void clearPairings() {
        super.clearPairings();
        this.aspects.clear();
        this.mostRestrictive = null;
        this.signalNames.clear();
    }

    @SideOnly(value=Side.CLIENT)
    public void removePair(int x, int y, int z) {
        super.removePair(x, y, z);
        Collection pairs = this.getPairs();
        if (this.aspects.keySet().retainAll(pairs)) {
            this.mostRestrictive = null;
        }
        this.signalNames.retainAllValues(pairs);
    }

    protected void saveNBT(NBTTagCompound data) {
        super.saveNBT(data);
        NBTTagList list = new NBTTagList();
        for (Map.Entry<WorldCoordinate, SignalAspect> entry : this.aspects.entrySet()) {
            NBTTagCompound tag = new NBTTagCompound();
            WorldCoordinate key = entry.getKey();
            tag.func_74783_a("coords", new int[]{key.dimension, key.x, key.y, key.z});
            tag.func_74774_a("aspect", (byte)entry.getValue().ordinal());
            String s = this.signalNames.inverse().get(key);
            if (s != null) {
                tag.func_74778_a("name", s);
            }
            list.func_74742_a((NBTBase)tag);
        }
        data.func_74782_a("aspects", (NBTBase)list);
    }

    protected void loadNBT(NBTTagCompound data) {
        super.loadNBT(data);
        NBTTagList list = data.func_150295_c("aspects", 10);
        for (int entry = 0; entry < list.func_74745_c(); entry = (int)((byte)(entry + 1))) {
            NBTTagCompound tag = list.func_150305_b(entry);
            int[] c = tag.func_74759_k("coords");
            WorldCoordinate coord = new WorldCoordinate(c[0], c[1], c[2], c[3]);
            this.aspects.put(coord, SignalAspect.fromOrdinal((int)tag.func_74771_c("aspect")));
            if (!tag.func_74764_b("name")) continue;
            this.signalNames.put(tag.func_74779_i("name"), coord);
        }
        this.mostRestrictive = null;
    }

    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeByte(this.visualAspect != null ? this.visualAspect.ordinal() : SignalAspect.BLINK_RED.ordinal());
    }

    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.visualAspect = SignalAspect.fromOrdinal((int)data.readByte());
    }
}

