/*
 * Decompiled with CFR 0.152.
 */
package codechicken.wirelessredstone.logic;

import codechicken.core.ClientUtils;
import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.raytracer.IndexedCuboid6;
import codechicken.lib.vec.BlockCoord;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.RedundantTransformation;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Vector3;
import codechicken.microblock.FaceMicroClass;
import codechicken.microblock.JMicroShrinkRender;
import codechicken.microblock.MicroOcclusion;
import codechicken.multipart.IFaceRedstonePart;
import codechicken.multipart.IRedstonePart;
import codechicken.multipart.IconHitEffects;
import codechicken.multipart.JCuboidPart;
import codechicken.multipart.JIconHitEffects;
import codechicken.multipart.JNormalOcclusion;
import codechicken.multipart.JPartialOcclusion;
import codechicken.multipart.NormalOcclusionTest;
import codechicken.multipart.RedstoneInteractions;
import codechicken.multipart.TFacePart;
import codechicken.multipart.TMultiPart;
import codechicken.multipart.TileMultipart;
import codechicken.wirelessredstone.core.RedstoneEther;
import codechicken.wirelessredstone.logic.RenderWireless;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Arrays;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class WirelessPart
extends JCuboidPart
implements TFacePart,
JIconHitEffects,
IFaceRedstonePart,
JNormalOcclusion,
JPartialOcclusion,
JMicroShrinkRender {
    private static Cuboid6[] nBoxes = new Cuboid6[6];
    public byte state;
    public String owner;
    public Cuboid6 baseRenderBounds;
    public int baseRenderMask;
    protected int spinoffset;

    public int rotation() {
        return this.state & 3;
    }

    public void setRotation(int rot) {
        this.state = (byte)(this.state & 0xFC | rot);
    }

    public int side() {
        return this.state >> 2 & 7;
    }

    public void setSide(int side) {
        this.state = (byte)(this.state & 0xE3 | side << 2);
    }

    public int shape() {
        return this.state & 0x1F;
    }

    public boolean active() {
        return (this.state & 0x20) > 0;
    }

    public void setActive(boolean active) {
        this.state = (byte)(this.state & 0xDF);
        if (active) {
            this.state = (byte)(this.state | 0x20);
        }
    }

    public boolean disabled() {
        return (this.state & 0x40) > 0;
    }

    public void setDisabled(boolean disabled) {
        this.state = (byte)(this.state & 0xBF);
        if (disabled) {
            this.state = (byte)(this.state | 0x40);
        }
    }

    public int getPoweringLevel() {
        int s = RedstoneInteractions.getPowerTo((TMultiPart)this, (int)Rotation.rotateSide((int)this.side(), (int)this.rotation()));
        int i = this.getInternalPower();
        if (i > s) {
            s = i;
        }
        return s;
    }

    public int getInternalPower() {
        TMultiPart part = this.tile().partMap(Rotation.rotateSide((int)this.side(), (int)this.rotation()));
        if (part instanceof IRedstonePart) {
            IRedstonePart rp = (IRedstonePart)part;
            return Math.max(rp.strongPowerLevel(this.side()), rp.weakPowerLevel(this.side())) << 4;
        }
        return 0;
    }

    public Transformation rotationT() {
        return Rotation.sideOrientation((int)this.side(), (int)this.rotation());
    }

    public void load(NBTTagCompound tag) {
        this.state = tag.func_74771_c("state");
        if (tag.func_74764_b("owner")) {
            this.owner = tag.func_74779_i("owner");
        }
    }

    public void save(NBTTagCompound tag) {
        tag.func_74774_a("state", this.state);
        if (this.owner != null) {
            tag.func_74778_a("owner", this.owner);
        }
    }

    public void readDesc(MCDataInput packet) {
        this.state = packet.readByte();
    }

    public void read(MCDataInput packet) {
        super.read(packet);
        this.onPartChanged((TMultiPart)this);
    }

    public void writeDesc(MCDataOutput packet) {
        packet.writeByte((int)this.state);
    }

    public void onWorldJoin() {
        if (!this.world().field_72995_K) {
            this.addToEther();
        }
    }

    public void onWorldSeparate() {
        if (!this.world().field_72995_K) {
            this.removeFromEther();
        }
    }

    public int getFace() {
        return this.side();
    }

    public boolean canConnectRedstone(int side) {
        return side == Rotation.rotateSide((int)this.side(), (int)this.rotation());
    }

    public void onNeighborChanged() {
        this.dropIfCantStay();
    }

    public ItemStack pickItem(MovingObjectPosition hit) {
        return this.getItem();
    }

    public Iterable<ItemStack> getDrops() {
        return Arrays.asList(this.getItem());
    }

    public int strongPowerLevel(int side) {
        return 0;
    }

    public int weakPowerLevel(int side) {
        return this.strongPowerLevel(side);
    }

    public void updateChange() {
        this.tile().func_70296_d();
        this.tile().notifyPartChange((TMultiPart)this);
        this.sendDescUpdate();
    }

    public boolean dropIfCantStay() {
        BlockCoord pos = new BlockCoord((TileEntity)this.tile()).offset(this.side());
        if (!this.world().isSideSolid(pos.x, pos.y, pos.z, ForgeDirection.getOrientation((int)(this.side() ^ 1)))) {
            this.drop();
            return true;
        }
        return false;
    }

    public void drop() {
        TileMultipart.dropItem((ItemStack)this.getItem(), (World)this.world(), (Vector3)Vector3.fromTileEntityCenter((TileEntity)this.tile()));
        this.tile().remPart((TMultiPart)this);
    }

    public void setupPlacement(EntityPlayer player, int side) {
        this.setSide(side ^ 1);
        this.setRotation(Rotation.getSidedRotation((EntityPlayer)player, (int)side) ^ 2);
        this.owner = player.func_70005_c_();
    }

    public abstract ItemStack getItem();

    public abstract void addToEther();

    public abstract void removeFromEther();

    public abstract Cuboid6 getExtensionBB();

    public abstract int modelId();

    public int textureSet() {
        return this.active() ? 1 : 0;
    }

    public abstract Vector3 getPearlPos();

    public Transformation getPearlRotation() {
        return new RedundantTransformation();
    }

    public double getPearlScale() {
        return 0.05;
    }

    public abstract double getPearlSpin();

    public abstract float getPearlLight();

    public double getFloating() {
        if (this.tile() != null) {
            return RedstoneEther.getSineWave(ClientUtils.getRenderTime() + (double)(this.x() * 3) + (double)(this.y() * 5) + (double)(this.z() * 9), 7);
        }
        return 0.0;
    }

    public boolean allowCompleteOcclusion() {
        return false;
    }

    public Cuboid6 getBounds() {
        return WirelessPart.baseBounds(this.side());
    }

    public Iterable<Cuboid6> getPartialOcclusionBoxes() {
        return this.getCollisionBoxes();
    }

    public Iterable<Cuboid6> getOcclusionBoxes() {
        return Arrays.asList(nBoxes[this.side()], this.getExtensionBB());
    }

    public boolean occlusionTest(TMultiPart npart) {
        return NormalOcclusionTest.apply((JNormalOcclusion)this, (TMultiPart)npart);
    }

    public Iterable<IndexedCuboid6> getSubParts() {
        return Arrays.asList(new IndexedCuboid6((Object)0, this.getBounds()));
    }

    public float getStrength(MovingObjectPosition hit, EntityPlayer player) {
        return 10.0f;
    }

    public boolean renderStatic(Vector3 pos, int pass) {
        if (pass == 0) {
            RenderWireless.renderWorld(this);
            return true;
        }
        return false;
    }

    public void renderDynamic(Vector3 pos, float frame, int pass) {
        if (pass == 0) {
            RenderWireless.renderPearl(pos, this);
        }
    }

    public void onPartChanged(TMultiPart part) {
        if (this.world().field_72995_K) {
            this.recalcBounds();
        } else {
            this.onNeighborChanged();
        }
    }

    public void onAdded() {
        super.onAdded();
        if (this.world().field_72995_K) {
            this.recalcBounds();
        }
    }

    public void recalcBounds() {
        this.baseRenderBounds = this.getBounds().copy();
        this.baseRenderMask = MicroOcclusion.recalcBounds((JMicroShrinkRender)this, (Cuboid6)this.baseRenderBounds);
        this.baseRenderBounds = this.baseRenderBounds.apply((Transformation)this.rotationT().at(Vector3.center).inverse());
    }

    public int getSlotMask() {
        return 1 << this.getSlot();
    }

    public boolean solid(int side) {
        return false;
    }

    public int redstoneConductionMap() {
        return 0;
    }

    public int getPriorityClass() {
        return -1;
    }

    public int getSize() {
        return 1;
    }

    public int getSlot() {
        return this.side();
    }

    public boolean isTransparent() {
        return false;
    }

    public static Cuboid6 baseBounds(int i) {
        return FaceMicroClass.aBounds()[0x10 | i];
    }

    public boolean activate(EntityPlayer player, MovingObjectPosition hit, ItemStack held) {
        if (hit.field_72310_e == (this.side() ^ 1) && player.func_70093_af()) {
            int r = this.rotation();
            this.setRotation((r + 1) % 4);
            if (!this.tile().canReplacePart((TMultiPart)this, (TMultiPart)this)) {
                this.setRotation(r);
                return false;
            }
            if (!this.world().field_72995_K) {
                this.updateChange();
                this.onPartChanged((TMultiPart)this);
            } else {
                this.setRotation(r);
            }
            return true;
        }
        return false;
    }

    public void addDestroyEffects(MovingObjectPosition hit, EffectRenderer effectRenderer) {
        IconHitEffects.addDestroyEffects((JIconHitEffects)this, (EffectRenderer)effectRenderer);
    }

    @SideOnly(value=Side.CLIENT)
    public void addHitEffects(MovingObjectPosition hit, EffectRenderer effectRenderer) {
        IconHitEffects.addHitEffects((JIconHitEffects)this, (MovingObjectPosition)hit, (EffectRenderer)effectRenderer);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getBreakingIcon(Object subPart, int side) {
        return this.getBrokenIcon(side);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getBrokenIcon(int side) {
        return RenderWireless.getBreakingIcon(this.textureSet());
    }

    static {
        Cuboid6 base = new Cuboid6(0.125, 0.0, 0.125, 0.875, 0.125, 0.875);
        for (int s = 0; s < 6; ++s) {
            WirelessPart.nBoxes[s] = base.copy().apply(Rotation.sideRotations[s].at(Vector3.center));
        }
    }
}

