/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.unilib;

import com.gitlab.cdagaming.unilib.core.CoreUtils;
import io.github.cdagaming.unicore.utils.TranslationUtils;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.client.ClientBrandRetriever;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.client.resources.SimpleReloadableResourceManager;
import net.minecraft.realms.RealmsSharedConstants;

public class ModUtils {
    public static final String MCVersion = RealmsSharedConstants.VERSION_STRING;
    public static final int MCProtocolID = RealmsSharedConstants.NETWORK_PROTOCOL_VERSION;
    public static final String BRAND = CoreUtils.findGameBrand(ClientBrandRetriever.getClientModName());
    public static final TranslationUtils RAW_TRANSLATOR = CoreUtils.findGameTranslations(MCProtocolID);
    private static final Supplier<Minecraft> INSTANCE_GETTER = Minecraft::func_71410_x;
    private static final BiConsumer<String, IResourceManagerReloadListener> RELOAD_LISTENER_HOOK = (id, listener) -> ((SimpleReloadableResourceManager)ModUtils.getMinecraft().func_110442_L()).func_110542_a(listener);
    public static boolean CAN_USE_RELOAD_LISTENER = true;
    private static final BiConsumer<Minecraft, Runnable> MAIN_THREAD_EXECUTOR = Minecraft::func_152344_a;

    public static Supplier<Minecraft> getMinecraftSupplier() {
        return INSTANCE_GETTER;
    }

    public static Minecraft getMinecraft() {
        return ModUtils.getMinecraftSupplier().get();
    }

    public static String getLanguage(String fallback) {
        String result = ModUtils.getMinecraft().field_71474_y != null ? ModUtils.getMinecraft().field_71474_y.field_74363_ab : fallback;
        return result;
    }

    public static String getLanguage() {
        return ModUtils.getLanguage(CoreUtils.getDefaultLanguage());
    }

    public static void registerReloadListener(String id, IResourceManagerReloadListener listener) {
        if (!CAN_USE_RELOAD_LISTENER) {
            return;
        }
        RELOAD_LISTENER_HOOK.accept(id, listener);
    }

    public static void executeOnMainThread(Minecraft client, Runnable event) {
        MAIN_THREAD_EXECUTOR.accept(client, event);
    }

    public static void executeOnMainThread(Runnable event) {
        MAIN_THREAD_EXECUTOR.accept(ModUtils.getMinecraft(), event);
    }
}

