/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.client.opengl;

import java.nio.IntBuffer;
import org.lwjgl.opengl.APPLEVertexArrayObject;
import org.lwjgl.opengl.ARBVertexArrayObject;
import org.lwjgl.opengl.ContextCapabilities;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL30;
import org.lwjgl.opengl.GLContext;

public final class UniversalVAO {
    private static final ThreadLocal<VaoFunctions> FUNCTIONS = new ThreadLocal<VaoFunctions>(){

        @Override
        protected VaoFunctions initialValue() {
            VaoFunctions vaoFunctions;
            switch (Implementation.querySupported()) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case GL3: {
                    vaoFunctions = new VaoGL3();
                    break;
                }
                case APPLE: {
                    vaoFunctions = new VaoApple();
                    break;
                }
                case ARB: {
                    vaoFunctions = new VaoArb();
                }
            }
            return vaoFunctions;
        }
    };

    public static void reinitializeGlContext() {
        FUNCTIONS.remove();
    }

    public static int getVertexArrayBinding() {
        return FUNCTIONS.get().getCurrentBinding();
    }

    public static int genVertexArrays() {
        return FUNCTIONS.get().glGenVertexArrays();
    }

    public static void genVertexArrays(IntBuffer output) {
        FUNCTIONS.get().glGenVertexArrays(output);
    }

    public static void deleteVertexArrays(int id) {
        FUNCTIONS.get().glDeleteVertexArrays(id);
    }

    public static void deleteVertexArrays(IntBuffer ids) {
        FUNCTIONS.get().glDeleteVertexArrays(ids);
    }

    public static boolean isVertexArray(int array) {
        return FUNCTIONS.get().glIsVertexArray(array);
    }

    public static void bindVertexArray(int id) {
        FUNCTIONS.get().glBindVertexArray(id);
    }

    private static interface VaoFunctions {
        public int getCurrentBinding();

        public int glGenVertexArrays();

        public void glGenVertexArrays(IntBuffer var1);

        public void glDeleteVertexArrays(int var1);

        public void glDeleteVertexArrays(IntBuffer var1);

        public boolean glIsVertexArray(int var1);

        public void glBindVertexArray(int var1);
    }

    private static final class VaoArb
    implements VaoFunctions {
        private VaoArb() {
        }

        @Override
        public int getCurrentBinding() {
            return GL11.glGetInteger((int)34229);
        }

        @Override
        public int glGenVertexArrays() {
            return ARBVertexArrayObject.glGenVertexArrays();
        }

        @Override
        public void glGenVertexArrays(IntBuffer output) {
            ARBVertexArrayObject.glGenVertexArrays((IntBuffer)output);
        }

        @Override
        public void glDeleteVertexArrays(int id) {
            ARBVertexArrayObject.glDeleteVertexArrays((int)id);
        }

        @Override
        public void glDeleteVertexArrays(IntBuffer ids) {
            ARBVertexArrayObject.glDeleteVertexArrays((IntBuffer)ids);
        }

        @Override
        public boolean glIsVertexArray(int id) {
            return ARBVertexArrayObject.glIsVertexArray((int)id);
        }

        @Override
        public void glBindVertexArray(int id) {
            ARBVertexArrayObject.glBindVertexArray((int)id);
        }
    }

    private static final class VaoApple
    implements VaoFunctions {
        private VaoApple() {
        }

        @Override
        public int getCurrentBinding() {
            return GL11.glGetInteger((int)34229);
        }

        @Override
        public int glGenVertexArrays() {
            return APPLEVertexArrayObject.glGenVertexArraysAPPLE();
        }

        @Override
        public void glGenVertexArrays(IntBuffer output) {
            APPLEVertexArrayObject.glGenVertexArraysAPPLE((IntBuffer)output);
        }

        @Override
        public void glDeleteVertexArrays(int id) {
            APPLEVertexArrayObject.glDeleteVertexArraysAPPLE((int)id);
        }

        @Override
        public void glDeleteVertexArrays(IntBuffer ids) {
            APPLEVertexArrayObject.glDeleteVertexArraysAPPLE((IntBuffer)ids);
        }

        @Override
        public boolean glIsVertexArray(int id) {
            return APPLEVertexArrayObject.glIsVertexArrayAPPLE((int)id);
        }

        @Override
        public void glBindVertexArray(int id) {
            APPLEVertexArrayObject.glBindVertexArrayAPPLE((int)id);
        }
    }

    private static final class VaoGL3
    implements VaoFunctions {
        private VaoGL3() {
        }

        @Override
        public int getCurrentBinding() {
            return GL11.glGetInteger((int)34229);
        }

        @Override
        public int glGenVertexArrays() {
            return GL30.glGenVertexArrays();
        }

        @Override
        public void glGenVertexArrays(IntBuffer output) {
            GL30.glGenVertexArrays((IntBuffer)output);
        }

        @Override
        public void glDeleteVertexArrays(int id) {
            GL30.glDeleteVertexArrays((int)id);
        }

        @Override
        public void glDeleteVertexArrays(IntBuffer ids) {
            GL30.glDeleteVertexArrays((IntBuffer)ids);
        }

        @Override
        public boolean glIsVertexArray(int id) {
            return GL30.glIsVertexArray((int)id);
        }

        @Override
        public void glBindVertexArray(int id) {
            GL30.glBindVertexArray((int)id);
        }
    }

    public static enum Implementation {
        GL3,
        APPLE,
        ARB;


        public static Implementation querySupported() {
            ContextCapabilities caps = GLContext.getCapabilities();
            if (caps.OpenGL30) {
                return GL3;
            }
            if (caps.GL_APPLE_vertex_array_object) {
                return APPLE;
            }
            if (caps.GL_ARB_vertex_array_object) {
                return ARB;
            }
            throw new UnsupportedOperationException("VAO not supported by the current OpenGL implementation.");
        }
    }
}

