/*
 * Decompiled with CFR 0.152.
 */
package atomicstryker.infernalmobs.common.modifiers;

import atomicstryker.infernalmobs.common.modifiers.MobModifier;
import atomicstryker.infernalmobs.common.modifiers.ModifierLoader;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraftforge.common.config.Configuration;

public class MM_Cloaking
extends MobModifier {
    private static final Class<?>[] disallowed = new Class[]{EntitySpider.class};
    private static final String[] suffix = new String[]{"ofStalking", "theUnseen", "thePredator"};
    private static final String[] prefix = new String[]{"stalking", "unseen", "hunting"};
    private static long coolDown;
    private static int potionDuration;
    private long nextAbilityUse = 0L;

    public MM_Cloaking(@Nullable MobModifier next) {
        super("Cloaking", next);
    }

    @Override
    public boolean onUpdate(EntityLivingBase mob) {
        if (this.getMobTarget() != null && this.getMobTarget() instanceof EntityPlayer) {
            this.tryAbility(mob);
        }
        return super.onUpdate(mob);
    }

    @Override
    public float onHurt(EntityLivingBase mob, DamageSource source, float damage) {
        if (source.func_76346_g() != null && source.func_76346_g() instanceof EntityLivingBase) {
            this.tryAbility(mob);
        }
        return super.onHurt(mob, source, damage);
    }

    private void tryAbility(EntityLivingBase mob) {
        long time = mob.field_70173_aa;
        if (time > this.nextAbilityUse) {
            this.nextAbilityUse = time + coolDown;
            mob.func_70690_d(new PotionEffect(Potion.field_76441_p.field_76415_H, potionDuration));
        }
    }

    @Override
    public Class<?>[] getBlackListMobClasses() {
        return disallowed;
    }

    @Override
    protected String[] getModNameSuffix() {
        return suffix;
    }

    @Override
    protected String[] getModNamePrefix() {
        return prefix;
    }

    public static class Loader
    extends ModifierLoader<MM_Cloaking> {
        public Loader() {
            super(MM_Cloaking.class);
        }

        @Override
        public MM_Cloaking make(@Nullable MobModifier next) {
            return new MM_Cloaking(next);
        }

        @Override
        public void loadConfig(Configuration config) {
            potionDuration = config.get(this.getModifierClassName(), "cloakingDurationTicks", 200.0, "Time mob is cloaked").getInt(200);
            coolDown = config.get(this.getModifierClassName(), "coolDownMillis", 12000.0, "Time between ability uses").getInt(12000) / 50;
        }
    }
}

