/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.items;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.core.Tabs;
import forestry.api.genetics.AlleleManager;
import forestry.apiculture.gui.ContainerHabitatLocator;
import forestry.apiculture.gui.GuiHabitatLocator;
import forestry.apiculture.inventory.ItemInventoryHabitatLocator;
import forestry.apiculture.items.HabitatLocatorLogic;
import forestry.apiculture.render.TextureHabitatLocator;
import forestry.core.items.ItemWithGui;
import forestry.core.utils.StringUtil;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;

public class ItemHabitatLocator
extends ItemWithGui {
    private static final String iconName = "forestry:biomefinder";
    private final HabitatLocatorLogic locatorLogic;

    public ItemHabitatLocator() {
        this.func_77637_a(Tabs.tabApiculture);
        this.func_77625_d(1);
        this.locatorLogic = new HabitatLocatorLogic();
    }

    public HabitatLocatorLogic getLocatorLogic() {
        return this.locatorLogic;
    }

    public void func_77663_a(ItemStack p_77663_1_, World world, Entity player, int p_77663_4_, boolean p_77663_5_) {
        if (!world.field_72995_K) {
            this.locatorLogic.onUpdate(world, player);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister register) {
        if (register instanceof TextureMap) {
            TextureHabitatLocator texture = new TextureHabitatLocator(iconName);
            ((TextureMap)register).setTextureEntry(iconName, (TextureAtlasSprite)texture);
            this.field_77791_bV = texture;
        }
    }

    public void func_77624_a(ItemStack itemstack, EntityPlayer player, List list, boolean flag) {
        BiomeGenBase currentBiome = player.field_70170_p.func_72807_a((int)player.field_70165_t, (int)player.field_70161_v);
        EnumTemperature temperature = EnumTemperature.getFromBiome(currentBiome, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
        EnumHumidity humidity = EnumHumidity.getFromValue(currentBiome.field_76751_G);
        list.add(StringUtil.localize("gui.currentBiome") + ": " + currentBiome.field_76791_y);
        list.add(StringUtil.localize("gui.temperature") + ": " + AlleleManager.climateHelper.toDisplay(temperature));
        list.add(StringUtil.localize("gui.humidity") + ": " + AlleleManager.climateHelper.toDisplay(humidity));
    }

    @Override
    public Object getGui(EntityPlayer player, ItemStack heldItem, int data) {
        return new GuiHabitatLocator(player, new ItemInventoryHabitatLocator(player, heldItem));
    }

    @Override
    public Object getContainer(EntityPlayer player, ItemStack heldItem, int data) {
        return new ContainerHabitatLocator(player, new ItemInventoryHabitatLocator(player, heldItem));
    }
}

