/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.recipe;

import codechicken.nei.LRUCache;
import codechicken.nei.LayoutManager;
import codechicken.nei.api.IOverlayHandler;
import codechicken.nei.api.IRecipeOverlayRenderer;
import codechicken.nei.recipe.DefaultOverlayHandler;
import codechicken.nei.recipe.GuiCraftingRecipe;
import codechicken.nei.recipe.GuiOverlayButton;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.ICraftingHandler;
import codechicken.nei.recipe.IRecipeHandler;
import codechicken.nei.recipe.Recipe;
import codechicken.nei.recipe.SearchRecipeHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;

public class RecipeHandlerRef {
    private static final LRUCache<Class<?>, Boolean> transferAlghoritmCache = new LRUCache(200);
    private static final LRUCache<Recipe.RecipeId, RecipeHandlerRef> recipeRefCache = new LRUCache(200);
    public final IRecipeHandler handler;
    public final int recipeIndex;

    private RecipeHandlerRef(IRecipeHandler handler, int recipeIndex) {
        this.handler = handler;
        this.recipeIndex = recipeIndex;
    }

    public static RecipeHandlerRef of(IRecipeHandler handler, int recipeIndex) {
        return new RecipeHandlerRef(handler, recipeIndex);
    }

    public static RecipeHandlerRef of(Recipe.RecipeId recipeId) {
        if (recipeId != null && recipeId.getResult() != null && !recipeId.getIngredients().isEmpty()) {
            return recipeRefCache.computeIfAbsent(recipeId, ri -> {
                ArrayList<ICraftingHandler> handlers = GuiCraftingRecipe.getCraftingHandlers("recipeId", recipeId.getResult(), recipeId);
                for (ICraftingHandler handler : handlers) {
                    int refIndex = SearchRecipeHandler.findFirst(handler, recipeIndex -> recipeId.equalsIngredients(handler.getIngredientStacks(recipeIndex)));
                    if (refIndex < 0) continue;
                    return new RecipeHandlerRef(handler, refIndex);
                }
                return null;
            });
        }
        return null;
    }

    private GuiContainer prepareGui(GuiContainer firstGui) {
        if (firstGui instanceof GuiRecipe) {
            GuiRecipe gui = (GuiRecipe)firstGui;
            firstGui = gui.firstGui;
        }
        return firstGui != null && firstGui.field_147002_h != null ? firstGui : null;
    }

    public IOverlayHandler getOverlayHandler(GuiContainer gui) {
        GuiContainer firstGui = this.prepareGui(gui);
        if (firstGui != null && this.handler.hasOverlay(firstGui, firstGui.field_147002_h, this.recipeIndex)) {
            return this.handler.getOverlayHandler(firstGui, this.recipeIndex);
        }
        return null;
    }

    public boolean canFillCraftingGrid(GuiContainer gui) {
        IOverlayHandler overlayHandler = this.getOverlayHandler(gui);
        if (overlayHandler != null) {
            return overlayHandler.canFillCraftingGrid(this.prepareGui(gui), this.handler, this.recipeIndex);
        }
        return false;
    }

    public boolean canCraft(GuiContainer gui) {
        IOverlayHandler overlayHandler = this.getOverlayHandler(gui);
        if (overlayHandler != null && this.allowedTransferAlghoritm(gui)) {
            return overlayHandler.canCraft(this.prepareGui(gui), this.handler, this.recipeIndex);
        }
        return false;
    }

    public List<GuiOverlayButton.ItemOverlayState> getPresenceOverlay(GuiContainer gui) {
        IOverlayHandler overlayHandler = this.getOverlayHandler(gui);
        if (overlayHandler != null) {
            return overlayHandler.presenceOverlay(this.prepareGui(gui), this.handler, this.recipeIndex);
        }
        return Collections.emptyList();
    }

    public void fillCraftingGrid(GuiContainer gui, int multiplier) {
        IOverlayHandler overlayHandler = this.getOverlayHandler(gui);
        if (overlayHandler != null) {
            GuiContainer firstGui = this.prepareGui(gui);
            if (!firstGui.equals(firstGui.field_146297_k.field_71462_r)) {
                firstGui.field_146297_k.func_147108_a((GuiScreen)firstGui);
            }
            if (!this.allowedTransferAlghoritm(gui)) {
                overlayHandler.overlayRecipe(firstGui, this.handler, this.recipeIndex, multiplier != 1);
            } else {
                overlayHandler.transferRecipe(firstGui, this.handler, this.recipeIndex, multiplier);
            }
        }
    }

    public boolean craft(GuiContainer gui, int multiplier) {
        GuiContainer firstGui = this.prepareGui(gui);
        IOverlayHandler overlayHandler = this.getOverlayHandler(firstGui);
        if (overlayHandler != null && overlayHandler.canCraft(firstGui, this.handler, this.recipeIndex)) {
            if (!firstGui.equals(firstGui.field_146297_k.field_71462_r)) {
                firstGui.field_146297_k.func_147108_a((GuiScreen)firstGui);
            }
            return overlayHandler.craft(firstGui, this.handler, this.recipeIndex, multiplier);
        }
        return false;
    }

    public boolean allowedTransferAlghoritm(GuiContainer gui) {
        IOverlayHandler overlayHandler = this.getOverlayHandler(gui);
        if (overlayHandler == null) {
            return false;
        }
        return transferAlghoritmCache.computeIfAbsent(overlayHandler.getClass(), clazz -> {
            try {
                Class<?> overlayRecipeClazz;
                if (overlayHandler instanceof DefaultOverlayHandler && (overlayRecipeClazz = overlayHandler.getClass().getMethod("overlayRecipe", GuiContainer.class, IRecipeHandler.class, Integer.TYPE, Boolean.TYPE).getDeclaringClass()).equals(DefaultOverlayHandler.class)) {
                    return true;
                }
                return !overlayHandler.getClass().getMethod("transferRecipe", GuiContainer.class, IRecipeHandler.class, Integer.TYPE, Integer.TYPE).isDefault();
            }
            catch (NoSuchMethodException noSuchMethodException) {
                return false;
            }
        });
    }

    public IRecipeOverlayRenderer getRecipeOverlayRenderer(GuiContainer gui) {
        GuiContainer firstGui = this.prepareGui(gui);
        if (firstGui != null && this.handler.hasOverlay(firstGui, firstGui.field_147002_h, this.recipeIndex)) {
            return this.handler.getOverlayRenderer(firstGui, this.recipeIndex);
        }
        return null;
    }

    public boolean canUseOverlayRenderer(GuiContainer gui) {
        return this.getRecipeOverlayRenderer(gui) != null;
    }

    public void useOverlayRenderer(GuiContainer gui) {
        IRecipeOverlayRenderer renderer = this.getRecipeOverlayRenderer(gui);
        if (renderer != null) {
            GuiContainer firstGui = this.prepareGui(gui);
            if (!firstGui.equals(firstGui.field_146297_k.field_71462_r)) {
                firstGui.field_146297_k.func_147108_a((GuiScreen)firstGui);
            }
            LayoutManager.overlayRenderer = renderer;
        }
    }
}

