/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.summoning.meteor;

import WayofTime.alchemicalWizardry.AlchemicalWizardry;
import WayofTime.alchemicalWizardry.api.alchemy.energy.Reagent;
import WayofTime.alchemicalWizardry.common.summoning.meteor.MeteorComponent;
import WayofTime.alchemicalWizardry.common.summoning.meteor.MeteorReagentRegistry;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.registry.GameRegistry;
import gregtech.common.blocks.TileEntityOres;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class Meteor {
    public List<MeteorComponent> ores;
    public List<MeteorComponent> filler;
    public int radius;
    public int cost;
    public float fillerChance;
    public ItemStack focusItem;
    private String focusModId;
    private String focusName;
    private int focusMeta;
    private int maxWeight;
    public static Random rand = new Random();

    public Meteor() {
        this.radius = 1;
        this.cost = AlchemicalWizardry.defaultMeteorCost;
        this.fillerChance = 0.0f;
        this.maxWeight = 0;
        this.preventNullLists();
    }

    public Meteor(ItemStack focusStack, int radius, int cost, int fillerChance, List<MeteorComponent> oreList, List<MeteorComponent> fillerList) {
        this.focusItem = focusStack;
        this.radius = radius;
        this.cost = cost;
        this.fillerChance = fillerChance;
        this.ores = oreList;
        this.filler = fillerList;
    }

    public void createMeteorImpact(World world, int x, int y, int z, List<Reagent> reagents) {
        int radius = Meteor.getNewRadius(this.radius, reagents);
        float fillerChance = Meteor.getNewFillerChance(this.fillerChance, reagents);
        if (MeteorReagentRegistry.doExplosions(reagents)) {
            world.func_72876_a(null, (double)x, (double)y, (double)z, (float)(radius * 4), MeteorReagentRegistry.doMeteorsDestroyBlocks(reagents));
        }
        List<MeteorComponent> oreList = Meteor.removeBlocksMissingRequiredReagents(this.ores, reagents);
        List<MeteorComponent> fillerList = Meteor.getNewFillerList(this.filler, reagents);
        int totalComponentWeight = MeteorComponent.getTotalListWeight(oreList);
        int totalFillerWeight = MeteorComponent.getTotalListWeight(fillerList);
        for (int i = -radius; i <= radius; ++i) {
            for (int j = -radius; j <= radius; ++j) {
                for (int k = -radius; k <= radius; ++k) {
                    if ((float)(i * i + j * j + k * k) >= ((float)radius + 0.5f) * ((float)radius + 0.5f) || !world.func_147437_c(x + i, y + j, z + k)) continue;
                    if (fillerChance < 100.0f && (fillerChance <= 0.0f || world.field_73012_v.nextFloat() * 100.0f >= fillerChance)) {
                        this.setMeteorBlock(x + i, y + j, z + k, world, oreList, totalComponentWeight);
                        continue;
                    }
                    this.setMeteorBlock(x + i, y + j, z + k, world, fillerList, totalFillerWeight);
                }
            }
        }
    }

    public static int getNewRadius(int radius, List<Reagent> reagents) {
        radius += MeteorReagentRegistry.getLargestRadiusIncrease(reagents);
        return Math.max(radius += MeteorReagentRegistry.getLargestRadiusDecrease(reagents), 1);
    }

    public static float getNewFillerChance(float fillerChance, List<Reagent> reagents) {
        if (fillerChance <= 0.0f) {
            return 0.0f;
        }
        float increase = MeteorReagentRegistry.getLargestFillerChanceIncrease(reagents);
        float decrease = MeteorReagentRegistry.getLargestFillerChanceDecrease(reagents);
        if (decrease == -100.0f) {
            return 0.0f;
        }
        fillerChance += MeteorReagentRegistry.getLargestRawFillerChanceIncrease(reagents);
        fillerChance += MeteorReagentRegistry.getLargestRawFillerChanceDecrease(reagents);
        if (increase > 0.0f) {
            fillerChance = 100.0f * (fillerChance + increase) / (100.0f + increase);
        } else if (decrease < 0.0f) {
            fillerChance = 100.0f * (fillerChance + decrease) / (100.0f + decrease);
        }
        return Math.max(0.0f, Math.min(fillerChance, 100.0f));
    }

    public static List<MeteorComponent> getNewFillerList(List<MeteorComponent> fillerList, List<Reagent> reagents) {
        List<MeteorComponent> reagentFillers = MeteorReagentRegistry.getFillerList(reagents);
        if (!(reagentFillers = Meteor.removeBlocksMissingRequiredReagents(reagentFillers, reagents)).isEmpty() && reagentFillers.get(0) != MeteorComponent.defaultMeteorBlock) {
            return reagentFillers;
        }
        return Meteor.removeBlocksMissingRequiredReagents(fillerList, reagents);
    }

    public static List<MeteorComponent> removeBlocksMissingRequiredReagents(List<MeteorComponent> blockList, List<Reagent> reagents) {
        ArrayList<MeteorComponent> newList = new ArrayList<MeteorComponent>();
        for (MeteorComponent component : blockList) {
            if (!component.checkForReagent(reagents)) continue;
            newList.add(component);
        }
        if (newList.isEmpty()) {
            newList.add(MeteorComponent.defaultMeteorBlock);
        }
        return newList;
    }

    private void setMeteorBlock(int x, int y, int z, World world, List<MeteorComponent> blockList, int totalListWeight) {
        int randNum = world.field_73012_v.nextInt(totalListWeight);
        for (MeteorComponent component : blockList) {
            ItemStack blockStack;
            if ((randNum -= component.getWeight()) >= 0 || (blockStack = component.getBlock()) == null || !(blockStack.func_77973_b() instanceof ItemBlock)) continue;
            ((ItemBlock)blockStack.func_77973_b()).placeBlockAt(blockStack, null, world, x, y, z, 0, 0.0f, 0.0f, 0.0f, blockStack.func_77960_j());
            if (AlchemicalWizardry.isGregTechLoaded) {
                Meteor.setGTOresNaturalIfNeeded(world, x, y, z);
            }
            world.func_147471_g(x, y, z);
            break;
        }
    }

    public void validate() {
        this.preventNullLists();
        this.clampNumericalValues();
        this.buildFocusItem();
        this.maxWeightToFillerChance();
    }

    private void preventNullLists() {
        if (this.ores == null || this.ores.isEmpty()) {
            this.ores = new ArrayList<MeteorComponent>();
            this.ores.add(MeteorComponent.defaultMeteorBlock);
        }
        while (this.ores.contains(null)) {
            this.ores.remove(null);
        }
        if (this.filler == null || this.filler.isEmpty()) {
            this.filler = new ArrayList<MeteorComponent>();
            this.filler.add(MeteorComponent.defaultMeteorBlock);
        }
        while (this.filler.contains(null)) {
            this.filler.remove(null);
        }
    }

    private void clampNumericalValues() {
        this.radius = Math.max(1, this.radius);
        this.cost = Math.max(0, this.cost);
        this.fillerChance = Math.max(0.0f, Math.min(this.fillerChance, 100.0f));
        this.focusMeta = Math.max(0, this.focusMeta);
        this.maxWeight = Math.max(0, this.maxWeight);
    }

    private void buildFocusItem() {
        if (this.focusItem != null) {
            return;
        }
        this.focusItem = GameRegistry.findItemStack((String)this.focusModId, (String)this.focusName, (int)1);
        if (this.focusItem == null) {
            return;
        }
        this.focusItem.func_77964_b(this.focusMeta);
        AlchemicalWizardry.logger.warn("Setting focusModId, focusName, and focusMeta individually in meteorconfigs has been deprecated. Set \"focusItem\" with format \"modId:name(:meta optional)\" instead.");
    }

    private void maxWeightToFillerChance() {
        if (this.maxWeight <= 0 || this.fillerChance > 0.0f) {
            return;
        }
        this.fillerChance = Math.max(0.0f, Math.min(100.0f * (1.0f - (float)MeteorComponent.getTotalListWeight(this.ores) / (float)this.maxWeight), 100.0f));
    }

    @Optional.Method(modid="gregtech")
    private static void setGTOresNaturalIfNeeded(World world, int x, int y, int z) {
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (tileEntity instanceof TileEntityOres) {
            ((TileEntityOres)tileEntity).mNatural = true;
        }
    }
}

