/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.client.nei;

import WayofTime.alchemicalWizardry.api.alchemy.energy.Reagent;
import WayofTime.alchemicalWizardry.api.alchemy.energy.ReagentContainer;
import WayofTime.alchemicalWizardry.api.alchemy.energy.ReagentRegistry;
import WayofTime.alchemicalWizardry.api.alchemy.energy.ReagentStack;
import WayofTime.alchemicalWizardry.client.ClientUtils;
import WayofTime.alchemicalWizardry.client.nei.NEIConfig;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Rectangle;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class NEICalcinatorHandler
extends TemplateRecipeHandler {
    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("alchemicalwizardry.calcinator") && ((Object)((Object)this)).getClass() == NEICalcinatorHandler.class) {
            for (ReagentStack reagent : ReagentRegistry.itemToReagentMap.values()) {
                this.arecipes.add(new CachedReagentInfo(reagent));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        this.checkReagents(result);
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        this.checkReagents(ingredient);
    }

    private void checkReagents(ItemStack result) {
        ReagentStack rs = ReagentRegistry.getReagentStackForItem(result);
        if (rs != null) {
            this.arecipes.add(new CachedReagentInfo(rs));
        } else {
            NBTTagCompound tagCompound = result.func_77978_p();
            if (tagCompound == null || tagCompound.func_82582_d()) {
                return;
            }
            NBTTagList tagList = tagCompound.func_150295_c("reagentTanks", 10);
            if (tagList.field_74747_a.isEmpty()) {
                return;
            }
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                NBTTagCompound savedTag = tagList.func_150305_b(i);
                ReagentStack reagent = ReagentContainer.readFromNBT(savedTag).getReagent();
                ItemStack reagentItem = ReagentRegistry.getItemForReagent(reagent.reagent);
                ReagentStack reagentStackForItem = ReagentRegistry.getReagentStackForItem(reagentItem);
                if (reagentStackForItem == null) continue;
                this.arecipes.add(new CachedReagentInfo(reagentStackForItem));
            }
        }
    }

    public int recipiesPerPage() {
        return 5;
    }

    public void drawExtras(int recipe) {
        CachedReagentInfo reagentInfo = (CachedReagentInfo)((Object)this.arecipes.get(recipe));
        reagentInfo.onDraw(30, 0);
    }

    public String getOverlayIdentifier() {
        return "alchemicalwizardry.calcinator";
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(54, 23, 23, 16), "alchemicalwizardry.calcinator", new Object[0]));
    }

    public String getGuiTexture() {
        return new ResourceLocation("alchemicalwizardry", "gui/nei/calcinator.png").toString();
    }

    public String getRecipeName() {
        return "Alchemic Calcinator";
    }

    public class CachedReagentInfo
    extends TemplateRecipeHandler.CachedRecipe {
        private final Reagent reagent;
        private final int amount;
        private final int color;

        public CachedReagentInfo(ReagentStack reagent) {
            super((TemplateRecipeHandler)NEICalcinatorHandler.this);
            this.reagent = reagent.reagent;
            this.amount = reagent.amount;
            this.color = reagent.reagent.getColourRed() << 16 | reagent.reagent.getColourGreen() << 8 | reagent.reagent.getColourBlue();
        }

        public PositionedStack getResult() {
            return new PositionedStack((Object)ReagentRegistry.getItemForReagent(this.reagent), 32, 6);
        }

        public Reagent getReagent() {
            return this.reagent;
        }

        public int getAmount() {
            return this.amount;
        }

        public void onDraw(int x, int y) {
            this.drawColoredProgressBar(x, y);
            String amountText = String.format("%,d AR", this.amount);
            FontRenderer fontRenderer = ClientUtils.mc.field_71466_p;
            int textWidth = fontRenderer.func_78256_a(amountText);
            int textX = x + 84 - textWidth / 2;
            int textY = y + 19;
            fontRenderer.func_78276_b(amountText, textX, textY, 0);
            textWidth = fontRenderer.func_78256_a(this.reagent.name);
            textX = x + 84 - textWidth / 2;
            textY = y + 29;
            fontRenderer.func_78276_b(this.reagent.name, textX, textY, this.color);
        }

        private void drawColoredProgressBar(int x, int y) {
            int arrowX = x + 25;
            int arrowY = y + 19;
            int arrowWidth = 24;
            int arrowHeight = 16;
            int fillTime = 192;
            int holdTime = 8;
            int totalCycle = fillTime + holdTime;
            int cycleTick = NEICalcinatorHandler.this.cycleticks % totalCycle;
            int fillWidth = cycleTick < fillTime ? cycleTick * arrowWidth / fillTime : arrowWidth;
            TextureManager texManager = ClientUtils.mc.func_110434_K();
            texManager.func_110577_a(NEIConfig.ARROW_TEXTURE);
            Tessellator tessellator = Tessellator.field_78398_a;
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            float r = (float)(this.color >> 16 & 0xFF) / 255.0f;
            float g = (float)(this.color >> 8 & 0xFF) / 255.0f;
            float b = (float)(this.color & 0xFF) / 255.0f;
            GL11.glColor4f((float)r, (float)g, (float)b, (float)1.0f);
            tessellator.func_78382_b();
            tessellator.func_78374_a((double)arrowX, (double)(arrowY + arrowHeight), 0.0, 0.0, 1.0);
            tessellator.func_78374_a((double)(arrowX + fillWidth), (double)(arrowY + arrowHeight), 0.0, (double)((float)fillWidth / (float)arrowWidth), 1.0);
            tessellator.func_78374_a((double)(arrowX + fillWidth), (double)arrowY, 0.0, (double)((float)fillWidth / (float)arrowWidth), 0.0);
            tessellator.func_78374_a((double)arrowX, (double)arrowY, 0.0, 0.0, 0.0);
            tessellator.func_78381_a();
            GL11.glDisable((int)3042);
        }

        public PositionedStack getOtherStack() {
            ItemStack[] orbStacks = (ItemStack[])NEIConfig.getBloodOrbs().stream().map(ItemStack::new).toArray(ItemStack[]::new);
            PositionedStack stack = new PositionedStack((Object)orbStacks, 32, 33, true);
            stack.setPermutationToRender(NEICalcinatorHandler.this.cycleticks / 20 % orbStacks.length);
            return stack;
        }
    }
}

