/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.worldgen;

import com.google.gson.JsonObject;
import greymerk.roguelike.util.JsonNBT;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.IWorldEditor;
import greymerk.roguelike.worldgen.MetaBlock;
import greymerk.roguelike.worldgen.Spawner;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.MobSpawnerBaseLogic;
import net.minecraft.tileentity.TileEntityMobSpawner;

public class Spawnable {
    private boolean equip;
    private String name;
    private NBTTagCompound meta;

    public Spawnable(JsonObject data) {
        this.name = data.get("name").getAsString();
        boolean bl = this.equip = data.has("equip") ? data.get("equip").getAsBoolean() : true;
        if (data.has("meta")) {
            this.meta = JsonNBT.jsonToCompound(data.get("meta"));
        }
    }

    public void generate(IWorldEditor editor, Random rand, Coord cursor, int level) {
        if (!new MetaBlock(Blocks.field_150474_ac).set(editor, cursor)) {
            return;
        }
        TileEntityMobSpawner spawner = (TileEntityMobSpawner)editor.getTileEntity(cursor);
        if (spawner == null) {
            return;
        }
        MobSpawnerBaseLogic logic = spawner.func_145881_a();
        logic.func_98272_a(this.name);
        if (this.meta == null) {
            if (this.equip) {
                Spawner.setRoguelike(logic, level, this.name);
            }
            return;
        }
        Spawner.setMeta(logic, this.meta);
    }
}

