/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.modularui.common.widget.textfield;

import com.gtnewhorizons.modularui.api.GlStateManager;
import com.gtnewhorizons.modularui.api.drawable.GuiHelper;
import com.gtnewhorizons.modularui.api.math.MathExpression;
import com.gtnewhorizons.modularui.api.widget.ISyncedWidget;
import com.gtnewhorizons.modularui.api.widget.Interactable;
import com.gtnewhorizons.modularui.common.internal.network.NetworkUtils;
import com.gtnewhorizons.modularui.common.widget.textfield.BaseTextFieldWidget;
import java.awt.Point;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import net.minecraft.network.PacketBuffer;
import org.jetbrains.annotations.NotNull;

public class TextFieldWidget
extends BaseTextFieldWidget
implements ISyncedWidget {
    private boolean needsUpdate;
    private Supplier<String> getter;
    private Consumer<String> setter;
    private Function<String, String> validator = val -> val;
    private BiFunction<String, Integer, String> onScroll;
    private boolean syncsToServer = true;
    private boolean syncsToClient = true;

    public static Number parse(String num) {
        try {
            return format.parse(num);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return 0;
        }
    }

    @Override
    public void onInit() {
    }

    @Override
    public void draw(float partialTicks) {
        Point draggableTranslate = this.getDraggableTranslate();
        GuiHelper.useScissor(this.pos.x + draggableTranslate.x, this.pos.y + draggableTranslate.y, this.size.width, this.size.height, () -> {
            GlStateManager.pushMatrix();
            GlStateManager.translate(1 - this.scrollOffset, 1.0f, 0.0f);
            this.renderer.setSimulate(false);
            this.renderer.setScale(this.scale);
            this.renderer.setAlignment(this.textAlignment, this.scrollBar == null ? (float)(this.size.width - 2) : -1.0f, this.size.height);
            this.renderer.draw(this.handler.getText());
            GlStateManager.popMatrix();
        });
    }

    @NotNull
    public String getText() {
        if (this.handler.getText().isEmpty()) {
            return "";
        }
        if (this.handler.getText().size() > 1) {
            throw new IllegalStateException("TextFieldWidget can only have one line!");
        }
        return this.handler.getText().get(0);
    }

    public void setText(@NotNull String text) {
        if (this.handler.getText().isEmpty()) {
            this.handler.getText().add(text);
        } else {
            this.handler.getText().set(0, text);
        }
    }

    @Override
    public void onRemoveFocus() {
        super.onRemoveFocus();
        if (this.handler.getText().size() > 1) {
            throw new IllegalStateException("TextFieldWidget can only have one line!");
        }
        this.setText(this.validator.apply(this.getText()));
        if (this.setter != null) {
            this.setter.accept(this.getText());
        }
        if (this.syncsToServer()) {
            this.syncToServer(1, buffer -> NetworkUtils.writeStringSafe(buffer, this.getText()));
        }
    }

    @Override
    public boolean onMouseScroll(int direction) {
        if (!this.isFocused()) {
            return false;
        }
        if (this.onScroll != null) {
            this.setText(this.validator.apply(this.onScroll.apply(this.getText(), direction)));
            if (this.setter != null) {
                this.setter.accept(this.getText());
            }
            if (this.syncsToServer()) {
                this.syncToServer(1, buffer -> NetworkUtils.writeStringSafe(buffer, this.getText()));
            }
            return true;
        }
        return false;
    }

    @Override
    public void detectAndSendChanges(boolean init) {
        if (this.syncsToClient() && this.getter != null) {
            String val = this.getter.get();
            if (init || !this.getText().equals(val)) {
                this.setText(val);
                this.syncToClient(1, buffer -> {
                    buffer.writeBoolean(init);
                    NetworkUtils.writeStringSafe(buffer, this.getText());
                });
                this.markForUpdate();
            }
        }
    }

    @Override
    public void readOnClient(int id, PacketBuffer buf) {
        boolean init;
        if (id == 1 && ((init = buf.readBoolean()) || !this.isFocused())) {
            this.setText(NetworkUtils.readStringSafe(buf));
            if (init) {
                this.lastText = new ArrayList<String>(this.handler.getText());
                if (this.focusOnGuiOpen) {
                    this.forceFocus();
                }
            }
            if (!(this.setter == null || this.getter != null && this.getText().equals(this.getter.get()))) {
                this.setter.accept(this.getText());
            }
        }
    }

    @Override
    public void readOnServer(int id, PacketBuffer buf) {
        if (id == 1) {
            this.setText(NetworkUtils.readStringSafe(buf));
            if (this.setter != null) {
                this.setter.accept(this.getText());
            }
            this.markForUpdate();
        }
    }

    @Override
    public void markForUpdate() {
        this.needsUpdate = true;
    }

    @Override
    public void unMarkForUpdate() {
        this.needsUpdate = false;
    }

    @Override
    public boolean isMarkedForUpdate() {
        return this.needsUpdate;
    }

    public boolean syncsToClient() {
        return this.syncsToClient;
    }

    public boolean syncsToServer() {
        return this.syncsToServer;
    }

    public TextFieldWidget setSynced(boolean syncsToClient, boolean syncsToServer) {
        this.syncsToClient = syncsToClient;
        this.syncsToServer = syncsToServer;
        return this;
    }

    public TextFieldWidget setMaxLength(int maxLength) {
        this.handler.setMaxCharacters(maxLength);
        return this;
    }

    public TextFieldWidget setSetter(Consumer<String> setter) {
        this.setter = setter;
        return this;
    }

    public TextFieldWidget setSetterLong(Consumer<Long> setter) {
        this.setter = val -> {
            if (!val.isEmpty()) {
                setter.accept(TextFieldWidget.parse(val).longValue());
            }
        };
        return this;
    }

    public TextFieldWidget setSetterInt(Consumer<Integer> setter) {
        this.setter = val -> {
            if (!val.isEmpty()) {
                setter.accept(TextFieldWidget.parse(val).intValue());
            }
        };
        return this;
    }

    public TextFieldWidget setGetter(Supplier<String> getter) {
        this.getter = getter;
        return this;
    }

    public TextFieldWidget setGetterLong(Supplier<Long> getter) {
        this.getter = () -> String.valueOf(getter.get());
        return this;
    }

    public TextFieldWidget setGetterInt(Supplier<Integer> getter) {
        this.getter = () -> String.valueOf(getter.get());
        return this;
    }

    public TextFieldWidget setPattern(Pattern pattern) {
        this.handler.setPattern(pattern);
        return this;
    }

    @Override
    public TextFieldWidget setTextColor(int textColor) {
        this.renderer.setColor(textColor);
        return this;
    }

    public TextFieldWidget setMarkedColor(int color) {
        this.renderer.setMarkedColor(color);
        return this;
    }

    public TextFieldWidget setValidator(Function<String, String> validator) {
        this.validator = validator;
        return this;
    }

    public TextFieldWidget setNumbersLong(Function<Long, Long> validator) {
        this.setPattern(MATH_EXPRESSION);
        this.setValidator(val -> {
            long num = val.isEmpty() ? 0L : (long)MathExpression.parseMathExpression(val);
            return this.decimalFormat.format(validator.apply(num));
        });
        return this;
    }

    public TextFieldWidget setNumbers(Function<Integer, Integer> validator) {
        this.setPattern(MATH_EXPRESSION);
        return this.setValidator(val -> {
            int num = val.isEmpty() ? 0 : (int)MathExpression.parseMathExpression(val);
            return this.decimalFormat.format(validator.apply(num));
        });
    }

    public TextFieldWidget setNumbersDouble(Function<Double, Double> validator) {
        this.setPattern(MATH_EXPRESSION);
        return this.setValidator(val -> {
            double num = val.isEmpty() ? 0.0 : MathExpression.parseMathExpression(val);
            return this.decimalFormat.format(validator.apply(num));
        });
    }

    public TextFieldWidget setNumbers(Supplier<Integer> min, Supplier<Integer> max) {
        return this.setNumbers(val -> Math.min((Integer)max.get(), Math.max((Integer)min.get(), val)));
    }

    public TextFieldWidget setNumbersLong(Supplier<Long> min, Supplier<Long> max) {
        return this.setNumbersLong(val -> Math.min((Long)max.get(), Math.max((Long)min.get(), val)));
    }

    public TextFieldWidget setNumbers(int min, int max) {
        return this.setNumbers(val -> Math.min(max, Math.max(min, val)));
    }

    public TextFieldWidget setOnScroll(BiFunction<String, Integer, String> onScroll) {
        this.onScroll = onScroll;
        return this;
    }

    public TextFieldWidget setOnScrollNumbers(BiFunction<Integer, Integer, Integer> onScroll) {
        return this.setOnScroll((text, direction) -> this.decimalFormat.format(onScroll.apply((int)MathExpression.parseMathExpression(text), (Integer)direction)));
    }

    public TextFieldWidget setOnScrollNumbers(int baseStep, int ctrlStep, int shiftStep) {
        return this.setOnScrollNumbers((val, direction) -> {
            int step = (Interactable.hasShiftDown() ? shiftStep : (Interactable.hasControlDown() ? ctrlStep : baseStep)) * direction;
            try {
                val = Math.addExact(val, step);
            }
            catch (ArithmeticException ignored) {
                val = Integer.MAX_VALUE;
            }
            return val;
        });
    }

    public TextFieldWidget setOnScrollNumbersDouble(BiFunction<Double, Integer, Double> onScroll) {
        return this.setOnScroll((text, direction) -> this.decimalFormat.format(onScroll.apply(MathExpression.parseMathExpression(text), (Integer)direction)));
    }

    public TextFieldWidget setOnScrollNumbersLong(BiFunction<Long, Integer, Long> onScroll) {
        return this.setOnScroll((text, direction) -> this.decimalFormat.format(onScroll.apply((long)MathExpression.parseMathExpression(text), (Integer)direction)));
    }

    public TextFieldWidget setOnScrollNumbersLong(long baseStep, long ctrlStep, long shiftStep) {
        return this.setOnScrollNumbersLong((val, direction) -> {
            long step = (Interactable.hasShiftDown() ? shiftStep : (Interactable.hasControlDown() ? ctrlStep : baseStep)) * (long)direction.intValue();
            try {
                val = Math.addExact(val, step);
            }
            catch (ArithmeticException ignored) {
                val = Long.MAX_VALUE;
            }
            return val;
        });
    }
}

