/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.modularui.common.widget;

import com.gtnewhorizons.modularui.api.widget.ISyncedWidget;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.widget.Row;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.PacketBuffer;

public class DynamicPositionedRow
extends Row
implements ISyncedWidget {
    private final List<Boolean> childrenEnabledFlags = new ArrayList<Boolean>();
    private boolean needsUpdate;
    private boolean syncsToClient = true;

    public DynamicPositionedRow() {
        this.skipDisabledChild = true;
    }

    @Override
    public void initChildren() {
        for (Widget child : this.getChildren()) {
            this.childrenEnabledFlags.add(child.isEnabled());
        }
    }

    @Override
    public void onScreenUpdate() {
        boolean needsReposition = false;
        for (int i = 0; i < this.getChildren().size(); ++i) {
            if (this.childrenEnabledFlags.get(i).booleanValue() == this.getChildren().get(i).isEnabled()) continue;
            needsReposition = true;
            this.childrenEnabledFlags.set(i, this.getChildren().get(i).isEnabled());
        }
        if (needsReposition) {
            this.layoutChildren(this.getWindow().getSize().width, this.getWindow().getSize().height);
        }
    }

    @Override
    public void detectAndSendChanges(boolean init) {
        if (this.syncsToClient) {
            boolean needsReposition = false;
            for (int i = 0; i < this.getChildren().size(); ++i) {
                if (this.childrenEnabledFlags.get(i).booleanValue() == this.getChildren().get(i).isEnabled()) continue;
                needsReposition = true;
                this.childrenEnabledFlags.set(i, this.getChildren().get(i).isEnabled());
            }
            if (init || needsReposition) {
                this.syncToClient(0, buffer -> {
                    buffer.func_150787_b(this.getChildren().size());
                    for (boolean flag : this.childrenEnabledFlags) {
                        buffer.writeBoolean(flag);
                    }
                });
            }
        }
    }

    @Override
    public void readOnClient(int id, PacketBuffer buf) throws IOException {
        if (id == 0) {
            int length = buf.func_150792_a();
            for (int i = 0; i < length && i < this.childrenEnabledFlags.size(); ++i) {
                boolean flag = buf.readBoolean();
                this.childrenEnabledFlags.set(i, flag);
                this.getChildren().get(i).setEnabledForce(flag);
            }
            this.layoutChildren(this.getWindow().getSize().width, this.getWindow().getSize().height);
        }
    }

    @Override
    public void readOnServer(int id, PacketBuffer buf) throws IOException {
    }

    @Override
    public void markForUpdate() {
        this.needsUpdate = true;
    }

    @Override
    public void unMarkForUpdate() {
        this.needsUpdate = false;
    }

    @Override
    public boolean isMarkedForUpdate() {
        return this.needsUpdate;
    }

    public DynamicPositionedRow setSynced(boolean syncsToClient) {
        this.syncsToClient = syncsToClient;
        return this;
    }
}

