/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.modularui.common.internal.wrapper;

import com.gtnewhorizons.modularui.api.forge.ItemHandlerHelper;
import com.gtnewhorizons.modularui.api.forge.PlayerMainInvWrapper;
import com.gtnewhorizons.modularui.api.screen.ModularUIContext;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.common.internal.wrapper.BaseSlot;
import com.gtnewhorizons.modularui.common.widget.SlotWidget;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class ModularUIContainer
extends Container {
    private final ModularUIContext context;
    private boolean initialisedContainer = false;
    private final List<BaseSlot> sortedShiftClickSlots = new ArrayList<BaseSlot>();
    private final Map<String, List<Slot>> sortingAreas = new HashMap<String, List<Slot>>();
    private final Map<String, Integer> sortRowSizes = new HashMap<String, Integer>();

    public ModularUIContainer(ModularUIContext context, ModularWindow mainWindow, Integer interactionDisabledSlot) {
        this.context = context;
        this.context.initialize(this, mainWindow);
        this.disablePlayerSlotInteraction(interactionDisabledSlot);
        this.checkSlotIds();
        this.sortSlots();
        this.initialisedContainer = true;
    }

    public ModularUIContainer(ModularUIContext context, ModularWindow mainWindow) {
        this(context, mainWindow, null);
    }

    public void sortSlots() {
        this.sortedShiftClickSlots.sort(Comparator.comparingInt(BaseSlot::getShiftClickPriority));
    }

    public ModularUIContext getContext() {
        return this.context;
    }

    public boolean func_75145_c(EntityPlayer playerIn) {
        return playerIn.func_70089_S() && (this.context.getValidator() == null || this.context.getValidator().get() != false);
    }

    private void checkSlotIds() {
        for (int i = 0; i < this.field_75151_b.size(); ++i) {
            ((Slot)this.field_75151_b.get((int)i)).field_75222_d = i;
        }
    }

    public void disablePlayerSlotInteraction(Integer interactionDisabledSlot) {
        Slot slot;
        if (interactionDisabledSlot != null && this.field_75151_b.size() > interactionDisabledSlot && (slot = this.func_75147_a((IInventory)this.getContext().getPlayer().field_71071_by, interactionDisabledSlot)) instanceof BaseSlot && ((BaseSlot)slot).getItemHandler() instanceof PlayerMainInvWrapper) {
            ((BaseSlot)slot).setEnabled(false);
        }
    }

    public Slot func_75146_a(Slot slotIn) {
        if (slotIn instanceof BaseSlot && ((BaseSlot)slotIn).getShiftClickPriority() > Integer.MIN_VALUE) {
            this.sortedShiftClickSlots.add((BaseSlot)slotIn);
        }
        Slot ret = super.func_75146_a(slotIn);
        if (this.initialisedContainer) {
            this.sortSlots();
        }
        return ret;
    }

    public void removeSlot(Slot slot) {
        if (slot != this.field_75151_b.get(slot.field_75222_d)) {
            throw new IllegalStateException("Could not find slot in container!");
        }
        this.field_75151_b.remove(slot.field_75222_d);
        if (slot instanceof BaseSlot && this.sortedShiftClickSlots.remove(slot) && this.initialisedContainer) {
            this.sortSlots();
        }
        this.checkSlotIds();
        for (List<Slot> slots : this.sortingAreas.values()) {
            slots.removeIf(slot1 -> slot1 == slot);
        }
    }

    public void setRowSize(String sortArea, int size) {
        this.sortRowSizes.put(sortArea, size);
    }

    public void setSlotSortable(String area, BaseSlot slot) {
        if (slot != this.field_75151_b.get(slot.field_75222_d)) {
            throw new IllegalArgumentException("Slot is not at the expected index!");
        }
        this.sortingAreas.computeIfAbsent(area, section1 -> new ArrayList()).add(slot);
    }

    public void func_75142_b() {
        if (this.getContext().isClient()) {
            return;
        }
        super.func_75142_b();
        if (this.context.getValidator() != null && !this.context.getValidator().get().booleanValue()) {
            this.context.tryClose();
        }
        this.context.forEachWindowTopToBottom(window -> {
            if (window.isInitialized()) {
                window.serverUpdate();
            }
        });
    }

    public void sendSlotChange(ItemStack stack, int index) {
        for (Object listener : this.field_75149_d) {
            ((ICrafting)listener).func_71111_a((Container)this, index, stack);
        }
    }

    public void func_75141_a(int p_75141_1_, ItemStack p_75141_2_) {
        try {
            super.func_75141_a(p_75141_1_, p_75141_2_);
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace();
        }
    }

    public ItemStack func_75144_a(int slotId, int dragType, int clickTypeIn, EntityPlayer player) {
        Slot slot;
        if (slotId >= 0 && slotId < this.field_75151_b.size() && (slot = (Slot)this.field_75151_b.get(slotId)) instanceof BaseSlot && !((BaseSlot)slot).isEnabled()) {
            return null;
        }
        return super.func_75144_a(slotId, dragType, clickTypeIn, player);
    }

    public boolean func_94531_b(Slot slot) {
        if (slot instanceof BaseSlot && !((BaseSlot)slot).isEnabled()) {
            return false;
        }
        return super.func_94531_b(slot);
    }

    public ItemStack func_82846_b(EntityPlayer playerIn, int index) {
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot instanceof BaseSlot && !((BaseSlot)slot).isPhantom()) {
            if (!slot.func_82869_a(playerIn) || !((BaseSlot)slot).isEnabled()) {
                return null;
            }
            ItemStack stack = slot.func_75211_c();
            if (stack != null) {
                ItemStack original = stack.func_77946_l();
                ItemStack remainder = this.transferItem((BaseSlot)slot, stack.func_77946_l());
                stack.field_77994_a = remainder.field_77994_a;
                if (stack.field_77994_a < 1) {
                    slot.func_75215_d(null);
                }
                if (!ItemStack.func_77989_b((ItemStack)original, (ItemStack)remainder)) {
                    return original;
                }
            }
        }
        return null;
    }

    protected ItemStack transferItem(BaseSlot fromSlot, ItemStack fromStack) {
        ArrayList priorityList = new ArrayList();
        ArrayList<BaseSlot> tmpSlots = new ArrayList<BaseSlot>();
        int lastPriority = Integer.MAX_VALUE;
        for (BaseSlot baseSlot : this.sortedShiftClickSlots) {
            if (fromSlot.getShiftClickPriority() == baseSlot.getShiftClickPriority() && fromSlot.getItemHandler() == baseSlot.getItemHandler() || !baseSlot.canInsert || !baseSlot.isItemValidPhantom(fromStack) || !baseSlot.isEnabled()) continue;
            if (lastPriority != baseSlot.getShiftClickPriority() && !tmpSlots.isEmpty()) {
                priorityList.add(tmpSlots);
                tmpSlots = new ArrayList();
            }
            lastPriority = baseSlot.getShiftClickPriority();
            tmpSlots.add(baseSlot);
        }
        if (!tmpSlots.isEmpty()) {
            priorityList.add(tmpSlots);
        }
        for (List list : priorityList) {
            int toMove;
            int maxSize;
            ItemStack toStack;
            for (BaseSlot toSlot : list) {
                toStack = toSlot.func_75211_c();
                if (toSlot.isPhantom()) {
                    if (!ItemHandlerHelper.canItemStacksStackRelaxed(fromStack, toStack)) continue;
                    ItemStack toPush = fromStack.func_77946_l();
                    toPush.field_77994_a = !((SlotWidget)toSlot.getParentWidget()).canControlAmount() ? 1 : Math.min(fromStack.field_77994_a, toSlot.getItemStackLimit(fromStack));
                    toSlot.func_75215_d(toPush);
                    return fromStack;
                }
                if (toStack == null) continue;
                maxSize = Math.min(toSlot.func_75219_a(), fromStack.func_77976_d());
                if (!ItemHandlerHelper.canItemStacksStackRelaxed(fromStack, toStack)) continue;
                toMove = Math.max(Math.min(maxSize - toStack.field_77994_a, fromStack.field_77994_a), 0);
                fromStack.field_77994_a -= toMove;
                toStack.field_77994_a += toMove;
                toSlot.func_75218_e();
                if (fromStack.field_77994_a >= 1) continue;
                return fromStack;
            }
            for (BaseSlot toSlot : list) {
                toStack = toSlot.func_75211_c();
                if (toStack != null) continue;
                if (toSlot.isPhantom()) {
                    ItemStack toPush = fromStack.func_77946_l();
                    toPush.field_77994_a = !((SlotWidget)toSlot.getParentWidget()).canControlAmount() ? 1 : Math.min(fromStack.field_77994_a, toSlot.getItemStackLimit(fromStack));
                    toSlot.func_75215_d(toPush);
                    return fromStack;
                }
                maxSize = Math.min(toSlot.func_75219_a(), fromStack.func_77976_d());
                toMove = Math.min(maxSize, fromStack.field_77994_a);
                ItemStack newStack = fromStack.func_77946_l();
                fromStack.field_77994_a -= toMove;
                newStack.field_77994_a = toMove;
                toSlot.func_75215_d(newStack);
                if (fromStack.field_77994_a >= 1) continue;
                return fromStack;
            }
        }
        return fromStack;
    }
}

