/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.modularui.api.widget;

import codechicken.nei.recipe.GuiCraftingRecipe;
import codechicken.nei.recipe.GuiUsageRecipe;
import com.google.gson.JsonObject;
import com.gtnewhorizons.modularui.api.GlStateManager;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.drawable.Text;
import com.gtnewhorizons.modularui.api.math.Color;
import com.gtnewhorizons.modularui.api.math.Pos2d;
import com.gtnewhorizons.modularui.api.math.Size;
import com.gtnewhorizons.modularui.api.screen.ModularUIContext;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.widget.IWidgetBuilder;
import com.gtnewhorizons.modularui.api.widget.IWidgetParent;
import com.gtnewhorizons.modularui.api.widget.Interactable;
import com.gtnewhorizons.modularui.common.internal.JsonHelper;
import com.gtnewhorizons.modularui.common.internal.Theme;
import com.gtnewhorizons.modularui.common.widget.FakeSyncWidget;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.util.GTTooltipDataCache;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.StatCollector;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Widget {
    private String name = "";
    private ModularWindow window = null;
    private IWidgetParent parent = null;
    protected Size size = Size.ZERO;
    protected Pos2d relativePos = Pos2d.ZERO;
    protected Pos2d pos = Pos2d.ZERO;
    protected Pos2d fixedPos = null;
    @Nullable
    private SizeProvider sizeProvider;
    @Nullable
    private PosProvider posProvider;
    private boolean fillParent = false;
    private boolean autoSized = true;
    private boolean autoPositioned = true;
    private Function<Widget, Boolean> enabledDynamic = widget -> true;
    private boolean enabledStatic = true;
    private int layer = -1;
    private boolean tooltipDirty = true;
    private boolean firstRebuild = true;
    private Supplier<String> internalName = () -> null;
    @NotNull
    private Supplier<IDrawable[]> background = () -> null;
    private final List<Text> additionalTooltip = new ArrayList<Text>();
    private final List<Text> mainTooltip = new ArrayList<Text>();
    private Supplier<List<String>> dynamicTooltip;
    private final List<Text> additionalTooltipShift = new ArrayList<Text>();
    private final List<Text> mainTooltipShift = new ArrayList<Text>();
    private Supplier<List<String>> dynamicTooltipShift;
    private int tooltipShowUpDelay = 0;
    private boolean updateTooltipEveryTick = false;
    private boolean tooltipHasSpaceAfterFirstLine = true;
    @Nullable
    private String debugLabel;
    @Nullable
    private Consumer<Widget> ticker;
    private boolean respectNEIArea = true;
    private boolean hasTransferRect;
    private String transferRectID;
    private Object[] transferRectArgs;
    private String transferRectTooltip;

    public Widget() {
    }

    public Widget(Size size) {
        this();
        this.setSize(size);
    }

    public Widget(Pos2d pos) {
        this();
        this.setPos(pos);
    }

    public Widget(Size size, Pos2d pos) {
        this();
        this.setSize(size);
        this.setPos(pos);
    }

    public boolean isClient() {
        return this.getContext().isClient();
    }

    public void readJson(JsonObject json, String type) {
        this.name = JsonHelper.getString(json, "", "name");
        this.relativePos = JsonHelper.getElement(json, this.relativePos, Pos2d::ofJson, "pos");
        this.fixedPos = JsonHelper.getElement(json, null, Pos2d::ofJson, "fixedPos");
        this.size = JsonHelper.getElement(json, this.size, Size::ofJson, "size");
        this.fillParent = JsonHelper.getBoolean(json, false, "fillParent");
        this.setEnabled(JsonHelper.getBoolean(json, true, "enabled"));
        this.autoSized = JsonHelper.getBoolean(json, !json.has("size"), "autoSized");
        IDrawable drawable = JsonHelper.getObject(json, null, IDrawable::ofJson, "drawable", "background");
        if (drawable != null) {
            this.setBackground(drawable);
        }
    }

    @ApiStatus.Internal
    public final void initialize(ModularWindow window, IWidgetParent parent, int layer) {
        if (window == null || parent == null || this.isInitialised()) {
            throw new IllegalStateException("Illegal initialise call to widget!! " + this.toString());
        }
        this.window = window;
        this.parent = parent;
        this.layer = layer;
        this.onInit();
        if (this instanceof IWidgetParent) {
            int nextLayer = layer + 1;
            for (Widget widget : ((IWidgetParent)((Object)this)).getChildren()) {
                widget.initialize(this.window, (IWidgetParent)((Object)this), nextLayer);
            }
        }
        this.onPostInit();
    }

    @SideOnly(value=Side.CLIENT)
    @ApiStatus.Internal
    public final void buildTopToBottom(Dimension constraints) {
        if (!this.isInitialised()) {
            return;
        }
        int cw = constraints.width;
        int ch = constraints.height;
        if (this instanceof IWidgetParent) {
            this.modifyConstraints(constraints);
            IWidgetParent parentThis = (IWidgetParent)((Object)this);
            for (Widget widget : parentThis.getChildren()) {
                widget.buildTopToBottom(constraints);
            }
            parentThis.layoutChildren(cw, ch);
        }
        if (this.isAutoSized() && !this.isFillParent()) {
            this.size = this.determineSize(cw, ch);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @ApiStatus.Internal
    public final void buildBottomToTop() {
        if (!this.isInitialised()) {
            return;
        }
        if (this.isAutoSized() && this.isFillParent()) {
            this.size = this.parent.getSize();
        } else if (this.sizeProvider != null) {
            this.size = this.sizeProvider.getSize(this.getContext().getScaledScreenSize(), this.getWindow(), this.parent);
        }
        if (this.isFixed() && !this.isAutoPositioned()) {
            this.relativePos = this.fixedPos.subtract(this.parent.getAbsolutePos());
            this.pos = this.fixedPos;
        } else {
            if (this.posProvider != null) {
                this.relativePos = this.posProvider.getPos(this.getContext().getScaledScreenSize(), this.getWindow(), this.parent);
            }
            this.pos = this.parent.getAbsolutePos().add(this.relativePos);
        }
        if (this instanceof IWidgetParent) {
            IWidgetParent parentThis = (IWidgetParent)((Object)this);
            for (Widget child : parentThis.getChildren()) {
                child.buildBottomToTop();
            }
        }
        if (this.firstRebuild) {
            this.onFirstRebuild();
            this.firstRebuild = false;
        }
        this.onRebuild();
    }

    @SideOnly(value=Side.CLIENT)
    @ApiStatus.Internal
    public final void drawInternal(float partialTicks) {
        this.drawInternal(partialTicks, false);
    }

    @SideOnly(value=Side.CLIENT)
    @ApiStatus.Internal
    public final void drawInternal(float partialTicks, boolean ignoreEnabled) {
        this.onFrameUpdate();
        if (this.isEnabled() || ignoreEnabled) {
            GlStateManager.pushMatrix();
            Pos2d windowPos = this.getWindow().getPos();
            Size windowSize = this.getWindow().getSize();
            int alpha = this.getWindow().getAlpha();
            float scale = this.getWindow().getScale();
            float sf = 1.0f / scale;
            float x = ((float)windowPos.x + (float)windowSize.width / 2.0f * (1.0f - scale) + (float)(this.pos.x - windowPos.x) * scale) * sf;
            float y = ((float)windowPos.y + (float)windowSize.height / 2.0f * (1.0f - scale) + (float)(this.pos.y - windowPos.y) * scale) * sf;
            GlStateManager.translate(x, y, 0.0f);
            IDrawable.applyTintColor(this.getWindow().getGuiTint());
            GlStateManager.enableBlend();
            this.drawBackground(partialTicks);
            this.draw(partialTicks);
            GlStateManager.popMatrix();
            if (this instanceof IWidgetParent) {
                ((IWidgetParent)((Object)this)).drawChildren(partialTicks);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected void modifyConstraints(Dimension constraints) {
    }

    @SideOnly(value=Side.CLIENT)
    @NotNull
    protected Size determineSize(int maxWidth, int maxHeight) {
        return new Size(maxWidth, maxHeight);
    }

    @SideOnly(value=Side.CLIENT)
    @ApiStatus.OverrideOnly
    public void onRebuild() {
    }

    @SideOnly(value=Side.CLIENT)
    @ApiStatus.OverrideOnly
    public void onFirstRebuild() {
    }

    public void checkNeedsRebuild() {
        if (this.isInitialised() && this.isClient()) {
            this.window.markNeedsRebuild();
        }
    }

    @SideOnly(value=Side.CLIENT)
    @ApiStatus.OverrideOnly
    public void onScreenUpdate() {
    }

    @SideOnly(value=Side.CLIENT)
    @ApiStatus.OverrideOnly
    public void onFrameUpdate() {
    }

    @SideOnly(value=Side.CLIENT)
    public void drawBackground(float partialTicks) {
        IDrawable[] background = this.getBackground();
        if (background != null) {
            int themeColor = Theme.INSTANCE.getColor(this.getBackgroundColorKey());
            for (IDrawable drawable : background) {
                if (drawable == null) continue;
                drawable.applyThemeColor(themeColor);
                drawable.draw(Pos2d.ZERO, this.getSize(), partialTicks);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @ApiStatus.OverrideOnly
    public void draw(float partialTicks) {
    }

    @SideOnly(value=Side.CLIENT)
    @ApiStatus.OverrideOnly
    public void drawInForeground(float partialTicks) {
    }

    @SideOnly(value=Side.CLIENT)
    @ApiStatus.OverrideOnly
    public void buildTooltip(List<Text> tooltip) {
        if (this.dynamicTooltip != null) {
            tooltip.addAll(this.dynamicTooltip.get().stream().map(s -> new Text((String)s).color(Color.WHITE.normal)).collect(Collectors.toList()));
        }
    }

    @SideOnly(value=Side.CLIENT)
    @ApiStatus.OverrideOnly
    public void buildTooltipShift(List<Text> tooltipShift) {
        if (this.dynamicTooltipShift != null) {
            tooltipShift.addAll(this.dynamicTooltipShift.get().stream().map(s -> new Text((String)s).color(Color.WHITE.normal)).collect(Collectors.toList()));
        }
    }

    @SideOnly(value=Side.CLIENT)
    @Nullable
    public String getBackgroundColorKey() {
        return "bg";
    }

    @ApiStatus.OverrideOnly
    public void onInit() {
    }

    @ApiStatus.OverrideOnly
    public void onPostInit() {
    }

    @ApiStatus.OverrideOnly
    public void onPause() {
    }

    @ApiStatus.OverrideOnly
    public void onResume() {
    }

    @ApiStatus.OverrideOnly
    public void onDestroy() {
    }

    @SideOnly(value=Side.CLIENT)
    @ApiStatus.OverrideOnly
    public boolean shouldGetFocus() {
        return this instanceof Interactable;
    }

    @SideOnly(value=Side.CLIENT)
    @ApiStatus.OverrideOnly
    public void onRemoveFocus() {
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isFocused() {
        return this.getContext().getCursor().isFocused(this);
    }

    @SideOnly(value=Side.CLIENT)
    public void removeFocus() {
        this.getContext().getCursor().removeFocus(this);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean canHover() {
        return this instanceof Interactable || this.hasTooltip();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isHovering() {
        return this.getContext().getCursor().isHovering(this);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isRightBelowMouse() {
        return this.getContext().getCursor().isRightBelow(this);
    }

    public String toString() {
        if (this.debugLabel == null && this.name.isEmpty()) {
            return this.getClass().getSimpleName();
        }
        if (this.debugLabel == null) {
            return this.getClass().getSimpleName() + "#" + this.name;
        }
        return this.getClass().getSimpleName() + "#" + this.name + "#" + this.debugLabel;
    }

    public boolean isUnderMouse(Pos2d mousePos) {
        return mousePos.isInside(this.pos, this.size);
    }

    public String getName() {
        return this.name;
    }

    public ModularUIContext getContext() {
        return this.window.getContext();
    }

    public ModularWindow getWindow() {
        return this.window;
    }

    public String getInternalName() {
        return this.internalName.get();
    }

    public int getWindowLayer() {
        int i = 0;
        for (ModularWindow window : this.getContext().getOpenWindowsReversed()) {
            if (window == this.getWindow()) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    public IWidgetParent getParent() {
        return this.parent;
    }

    @SideOnly(value=Side.CLIENT)
    public Rectangle getArea() {
        return new Rectangle(this.pos.x, this.pos.y, this.size.width, this.size.height);
    }

    public Pos2d getPos() {
        return this.relativePos;
    }

    public Pos2d getAbsolutePos() {
        return this.pos;
    }

    public Size getSize() {
        return this.size;
    }

    public Rectangle getRenderAbsoluteRectangle() {
        return new Rectangle(this.getAbsolutePos().x, this.getAbsolutePos().y, this.getSize().width, this.getSize().height);
    }

    public boolean isEnabled() {
        return this.enabledStatic && this.enabledDynamic.apply(this) != false;
    }

    public int getLayer() {
        return this.layer;
    }

    public final boolean isInitialised() {
        return this.window != null;
    }

    public boolean isFixed() {
        return this.fixedPos != null;
    }

    public boolean isAutoSized() {
        return this.autoSized;
    }

    public boolean isAutoPositioned() {
        return this.autoPositioned;
    }

    public boolean isFillParent() {
        return this.fillParent;
    }

    @Nullable
    public String getDebugLabel() {
        return this.debugLabel;
    }

    @Nullable
    public IDrawable[] getBackground() {
        return this.background.get();
    }

    public boolean hasNEITransferRect() {
        return this.hasTransferRect;
    }

    @Nullable
    public String getNEITransferRectID() {
        return this.transferRectID;
    }

    @Nullable
    public Object[] getNEITransferRectArgs() {
        return this.transferRectArgs;
    }

    @Nullable
    public String getNEITransferRectTooltip() {
        return this.transferRectTooltip;
    }

    public void handleTransferRectMouseClick(boolean usage) {
        String id = this.getNEITransferRectID();
        Object[] args = this.getNEITransferRectArgs();
        Interactable.playButtonClickSound();
        if (usage) {
            GuiUsageRecipe.openRecipeGui((String)id, (Object[])new Object[0]);
        } else {
            GuiCraftingRecipe.openRecipeGui((String)id, (Object[])args);
        }
    }

    private void checkTooltip() {
        if (this.tooltipDirty || this.updateTooltipEveryTick) {
            this.mainTooltip.clear();
            this.mainTooltipShift.clear();
            this.buildTooltip(this.mainTooltip);
            this.buildTooltipShift(this.mainTooltipShift);
            this.tooltipDirty = false;
        }
    }

    public void notifyTooltipChange() {
        this.tooltipDirty = true;
    }

    public boolean hasTooltip() {
        this.checkTooltip();
        return !this.mainTooltip.isEmpty() || !this.additionalTooltip.isEmpty() || !this.mainTooltipShift.isEmpty() || !this.additionalTooltipShift.isEmpty() || this.hasNEITransferRect();
    }

    public List<Text> getTooltip() {
        ArrayList<Text> tooltip;
        if (!this.hasTooltip()) {
            return Collections.emptyList();
        }
        if (Interactable.hasShiftDown()) {
            tooltip = this.mainTooltipShift.isEmpty() ? new ArrayList<Text>(this.mainTooltip) : new ArrayList<Text>(this.mainTooltipShift);
            if (this.additionalTooltipShift.isEmpty()) {
                tooltip.addAll(this.additionalTooltip);
            } else {
                tooltip.addAll(this.additionalTooltipShift);
            }
        } else {
            tooltip = new ArrayList<Text>(this.mainTooltip);
            tooltip.addAll(this.additionalTooltip);
        }
        return tooltip;
    }

    public int getTooltipShowUpDelay() {
        return this.tooltipShowUpDelay;
    }

    @Nullable
    public Consumer<Widget> getTicker() {
        return this.ticker;
    }

    public boolean intersects(Widget widget) {
        return widget.getAbsolutePos().x <= this.getAbsolutePos().x + this.getSize().width && widget.getAbsolutePos().x + widget.getSize().width >= this.getAbsolutePos().x && widget.getAbsolutePos().y <= this.getAbsolutePos().y + this.getSize().height && widget.getAbsolutePos().y + widget.getSize().height >= this.getAbsolutePos().y;
    }

    public Rectangle getRectangle() {
        return new Rectangle(this.pos.x, this.pos.y, this.size.width, this.size.height);
    }

    public boolean isRespectNEIArea() {
        return this.respectNEIArea;
    }

    public Widget setEnabled(boolean enabled) {
        this.enabledStatic = enabled;
        return this;
    }

    public Widget setEnabled(Function<Widget, Boolean> enabled) {
        this.enabledDynamic = enabled;
        return this;
    }

    public Widget setEnabledForce(boolean enabled) {
        this.setEnabled(enabled);
        this.setEnabled(widget -> enabled);
        return this;
    }

    public Widget setSize(int width, int height) {
        return this.setSize(new Size(width, height));
    }

    public Widget setSize(Size size) {
        this.checkNeedsRebuild();
        this.autoSized = false;
        this.fillParent = false;
        this.size = size;
        return this;
    }

    public Widget setSizeProvider(SizeProvider sizeProvider) {
        this.autoSized = false;
        this.fillParent = false;
        this.sizeProvider = sizeProvider;
        return this;
    }

    public void setSizeSilent(Size size) {
        this.size = size;
    }

    public Widget setPos(int x, int y) {
        return this.setPos(new Pos2d(x, y));
    }

    public Widget setPos(Pos2d relativePos) {
        this.checkNeedsRebuild();
        this.autoPositioned = false;
        this.relativePos = relativePos;
        this.fixedPos = null;
        return this;
    }

    public void setPosSilent(Pos2d relativePos) {
        this.relativePos = relativePos;
        if (this.isInitialised()) {
            this.pos = this.parent.getAbsolutePos().add(this.relativePos);
            if (this instanceof IWidgetParent) {
                for (Widget child : ((IWidgetParent)((Object)this)).getChildren()) {
                    child.setPosSilent(child.getPos());
                }
            }
        }
    }

    public Widget setFixedPos(int x, int y) {
        return this.setFixedPos(new Pos2d(x, y));
    }

    public Widget setFixedPos(@Nullable Pos2d pos) {
        this.checkNeedsRebuild();
        this.autoPositioned = false;
        this.fixedPos = pos;
        return this;
    }

    public Widget setPosProvider(PosProvider posProvider) {
        this.autoPositioned = false;
        this.posProvider = posProvider;
        this.fixedPos = null;
        return this;
    }

    public Widget fillParent() {
        this.fillParent = true;
        this.autoSized = true;
        this.autoPositioned = false;
        return this;
    }

    public Widget setBackground(IDrawable ... drawables) {
        this.background = () -> drawables;
        return this;
    }

    public Widget setBackground(Supplier<IDrawable[]> drawables) {
        this.background = drawables;
        return this;
    }

    public Widget addTooltip(Text tooltip) {
        this.additionalTooltip.add(tooltip);
        return this;
    }

    public Widget addTooltip(String tooltip) {
        return this.addTooltip(new Text(tooltip).color(Color.WHITE.normal));
    }

    public Widget addTooltips(List<String> tooltips) {
        for (String tooltip : tooltips) {
            this.addTooltip(tooltip);
        }
        return this;
    }

    public Widget dynamicTooltip(Supplier<List<String>> dynamicTooltip) {
        this.dynamicTooltip = dynamicTooltip;
        return this;
    }

    public Widget addTooltipShift(Text tooltipShift) {
        this.additionalTooltipShift.add(tooltipShift);
        return this;
    }

    public Widget addTooltipShift(String tooltipShift) {
        return this.addTooltipShift(new Text(tooltipShift).color(Color.WHITE.normal));
    }

    public Widget addTooltipsShift(List<String> tooltipsShift) {
        for (String tooltip : tooltipsShift) {
            this.addTooltipShift(tooltip);
        }
        return this;
    }

    public Widget dynamicTooltipShift(Supplier<List<String>> dynamicTooltipShift) {
        this.dynamicTooltipShift = dynamicTooltipShift;
        return this;
    }

    @Optional.Method(modid="gregtech")
    public Widget setGTTooltip(Supplier<GTTooltipDataCache.TooltipData> tooltipDataGetter) {
        this.dynamicTooltip(() -> ((GTTooltipDataCache.TooltipData)tooltipDataGetter.get()).text);
        this.dynamicTooltipShift(() -> ((GTTooltipDataCache.TooltipData)tooltipDataGetter.get()).shiftText);
        return this;
    }

    public Widget setTooltipShowUpDelay(int tooltipShowUpDelay) {
        this.tooltipShowUpDelay = tooltipShowUpDelay;
        return this;
    }

    public Widget setUpdateTooltipEveryTick(boolean updateTooltipEveryTick) {
        this.updateTooltipEveryTick = updateTooltipEveryTick;
        return this;
    }

    public Widget setTooltipHasSpaceAfterFirstLine(boolean tooltipHasSpaceAfterFirstLine) {
        this.tooltipHasSpaceAfterFirstLine = tooltipHasSpaceAfterFirstLine;
        return this;
    }

    public boolean isTooltipHasSpaceAfterFirstLine() {
        return this.tooltipHasSpaceAfterFirstLine;
    }

    public Widget setDebugLabel(String debugLabel) {
        this.debugLabel = debugLabel;
        return this;
    }

    public Widget setTicker(@Nullable Consumer<Widget> ticker) {
        this.ticker = ticker;
        return this;
    }

    public Widget consume(Consumer<Widget> widgetConsumer) {
        widgetConsumer.accept(this);
        return this;
    }

    public <T> Widget attachSyncer(FakeSyncWidget<T> syncer, IWidgetBuilder<?> builder, BiConsumer<Widget, T> onSync) {
        builder.widget(syncer.setOnClientUpdate(val -> onSync.accept(this, val)));
        return this;
    }

    public <T> Widget attachSyncer(FakeSyncWidget<T> syncer, IWidgetBuilder<?> builder) {
        return this.attachSyncer(syncer, builder, (widget, val) -> {});
    }

    public Widget setRespectNEIArea(boolean doRespect) {
        this.respectNEIArea = doRespect;
        return this;
    }

    public Widget setNEITransferRect(String transferRectID, Object[] transferRectArgs, String transferRectTooltip) {
        this.transferRectID = transferRectID;
        this.transferRectArgs = transferRectArgs;
        this.transferRectTooltip = transferRectTooltip;
        this.hasTransferRect = true;
        return this;
    }

    public Widget setNEITransferRect(String transferRectID, Object[] transferRectArgs) {
        return this.setNEITransferRect(transferRectID, transferRectArgs, StatCollector.func_74838_a((String)"nei.recipe.tooltip"));
    }

    public Widget setNEITransferRect(String transferRectID, String transferRectTooltip) {
        return this.setNEITransferRect(transferRectID, new Object[0], transferRectTooltip);
    }

    public Widget setNEITransferRect(String transferRectID) {
        return this.setNEITransferRect(transferRectID, new Object[0]);
    }

    public Widget setInternalName(String internalName) {
        return this.setInternalName(() -> internalName);
    }

    public Widget setInternalName(Supplier<String> supplier) {
        this.internalName = supplier;
        return this;
    }

    public static class ClickData {
        public final int mouseButton;
        public final boolean doubleClick;
        public final boolean shift;
        public final boolean ctrl;

        public ClickData(int mouseButton, boolean doubleClick, boolean shift, boolean ctrl) {
            this.mouseButton = mouseButton;
            this.doubleClick = doubleClick;
            this.shift = shift;
            this.ctrl = ctrl;
        }

        public void writeToPacket(PacketBuffer buffer) {
            short data = (short)(this.mouseButton & 0xFF);
            if (this.doubleClick) {
                data = (short)(data | 0x100);
            }
            if (this.shift) {
                data = (short)(data | 0x200);
            }
            if (this.ctrl) {
                data = (short)(data | 0x400);
            }
            buffer.writeShort((int)data);
        }

        public static ClickData readPacket(PacketBuffer buffer) {
            short data;
            return new ClickData(data & 0xFF, ((data = buffer.readShort()) & 0x100) > 0, (data & 0x200) > 0, (data & 0x400) > 0);
        }

        @SideOnly(value=Side.CLIENT)
        public static ClickData create(int mouse, boolean doubleClick) {
            return new ClickData(mouse, doubleClick, Interactable.hasShiftDown(), Interactable.hasControlDown());
        }
    }

    public static interface PosProvider {
        public Pos2d getPos(Size var1, ModularWindow var2, IWidgetParent var3);
    }

    public static interface SizeProvider {
        public Size getSize(Size var1, ModularWindow var2, IWidgetParent var3);
    }
}

