/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.structures.courtyard;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import twilightforest.block.TFBlocks;
import twilightforest.structures.StructureTFComponent;
import twilightforest.structures.courtyard.ComponentTFNagaCourtyardDecorator;
import twilightforest.structures.courtyard.ComponentTFNagaCourtyardHedge;
import twilightforest.structures.courtyard.ComponentTFNagaCourtyardHedgePadder;
import twilightforest.structures.courtyard.ComponentTFNagaCourtyardHedgePillar;
import twilightforest.structures.courtyard.ComponentTFNagaCourtyardRotatedAbstract;
import twilightforest.structures.courtyard.ComponentTFNagaCourtyardTerraceAbstract;
import twilightforest.structures.courtyard.ComponentTFNagaCourtyardTerraceBrazier;
import twilightforest.structures.courtyard.ComponentTFNagaCourtyardTerraceDuct;
import twilightforest.structures.courtyard.ComponentTFNagaCourtyardTerraceStatue;
import twilightforest.structures.courtyard.ComponentTFNagaCourtyardWall;
import twilightforest.structures.courtyard.ComponentTFNagaCourtyardWallCornerInner;
import twilightforest.structures.courtyard.ComponentTFNagaCourtyardWallCornerOuter;
import twilightforest.structures.courtyard.ComponentTFNagaCourtyardWallPadder;

public class ComponentTFNagaCourtyardMain
extends StructureTFComponent {
    int tableWidth = ROW_OF_CELLS * 2 - 1;
    int terraceLeft;
    CellType[][] courtyard = new CellType[this.tableWidth][this.tableWidth];
    static int ROW_OF_CELLS = 8;
    static int RADIUS = (int)((float)(ROW_OF_CELLS - 2) / 2.0f * 12.0f + 8.0f);
    static int DIAMETER = 2 * RADIUS + 1;
    static final float HEDGE_FLOOF = 0.5f;
    static final float TERRACE_RATE = 0.2f;

    public ComponentTFNagaCourtyardMain() {
    }

    public ComponentTFNagaCourtyardMain(World world, Random rand, int i, int x, int y, int z) {
        super(i);
        this.setCoordBaseMode(0);
        this.field_74887_e = StructureTFComponent.getComponentToAddBoundingBox(x, y, z, -RADIUS, -1, -RADIUS, RADIUS * 2 + 6, 10, RADIUS * 2 + 6, 0);
    }

    private void fillTable(int startX, int startZ, int finishX, int finishZ, CellType fillCell) {
        for (int i = startX; i <= finishX; ++i) {
            for (int j = startZ; j <= finishZ; ++j) {
                this.courtyard[i][j] = fillCell;
            }
        }
    }

    public void func_74861_a(StructureComponent structurecomponent, List list, Random random) {
        ComponentTFNagaCourtyardWallCornerOuter corner;
        ComponentTFNagaCourtyardWallPadder padder;
        ComponentTFNagaCourtyardWall wall1;
        ComponentTFNagaCourtyardWall wall;
        ComponentTFNagaCourtyardWallCornerOuter corner2;
        ComponentTFNagaCourtyardWall wall2;
        ComponentTFNagaCourtyardWallCornerInner cornerInner;
        ComponentTFNagaCourtyardWall wall12;
        ComponentTFNagaCourtyardWall wall3;
        ComponentTFNagaCourtyardWallPadder padder2;
        ComponentTFNagaCourtyardWallCornerOuter corner3;
        ComponentTFNagaCourtyardRotatedAbstract padder3;
        int z;
        int x;
        super.func_74861_a(structurecomponent, list, random);
        this.courtyard = new CellType[this.tableWidth][this.tableWidth];
        this.fillTable(0, 0, this.tableWidth - 1, this.tableWidth - 1, CellType.EMPTY);
        this.fillTable(0, 0, 1, 1, CellType.OUTSIDE);
        boolean outsideX = random.nextBoolean();
        boolean outsideZ = random.nextBoolean();
        if (outsideX) {
            this.fillTable(2, 0, 3, 1, CellType.OUTSIDE);
        }
        if (outsideZ) {
            this.fillTable(0, 2, 1, 3, CellType.OUTSIDE);
        }
        if (outsideX && outsideZ && random.nextBoolean()) {
            this.fillTable(2, 2, 3, 3, CellType.OUTSIDE);
        }
        this.fillTable(0, this.tableWidth - 2, 1, this.tableWidth - 1, CellType.OUTSIDE);
        outsideX = random.nextBoolean();
        outsideZ = random.nextBoolean();
        if (outsideX) {
            this.fillTable(2, this.tableWidth - 2, 3, this.tableWidth - 1, CellType.OUTSIDE);
        }
        if (outsideZ) {
            this.fillTable(0, this.tableWidth - 4, 1, this.tableWidth - 3, CellType.OUTSIDE);
        }
        if (outsideX && outsideZ && random.nextBoolean()) {
            this.fillTable(2, this.tableWidth - 4, 3, this.tableWidth - 3, CellType.OUTSIDE);
        }
        this.fillTable(this.tableWidth - 2, 0, this.tableWidth - 1, 1, CellType.OUTSIDE);
        outsideX = random.nextBoolean();
        outsideZ = random.nextBoolean();
        if (outsideX) {
            this.fillTable(this.tableWidth - 4, 0, this.tableWidth - 3, 1, CellType.OUTSIDE);
        }
        if (outsideZ) {
            this.fillTable(this.tableWidth - 2, 2, this.tableWidth - 1, 3, CellType.OUTSIDE);
        }
        if (outsideX && outsideZ && random.nextBoolean()) {
            this.fillTable(this.tableWidth - 4, 2, this.tableWidth - 3, 3, CellType.OUTSIDE);
        }
        this.fillTable(this.tableWidth - 2, this.tableWidth - 2, this.tableWidth - 1, this.tableWidth - 1, CellType.OUTSIDE);
        outsideX = random.nextBoolean();
        outsideZ = random.nextBoolean();
        if (outsideX) {
            this.fillTable(this.tableWidth - 4, this.tableWidth - 2, this.tableWidth - 3, this.tableWidth - 1, CellType.OUTSIDE);
        }
        if (outsideZ) {
            this.fillTable(this.tableWidth - 2, this.tableWidth - 4, this.tableWidth - 1, this.tableWidth - 3, CellType.OUTSIDE);
        }
        if (outsideX && outsideZ && random.nextBoolean()) {
            this.fillTable(this.tableWidth - 4, this.tableWidth - 4, this.tableWidth - 3, this.tableWidth - 3, CellType.OUTSIDE);
        }
        int cellsCount = this.countCellsInArea(0, 0, this.tableWidth - 1, this.tableWidth - 1, CellType.EMPTY);
        this.terraceLeft = (int)((float)cellsCount * 0.2f / 9.0f);
        while (this.terraceLeft > 0) {
            boolean buildTerrace;
            x = random.nextInt(this.tableWidth / 2) * 2;
            boolean bl = buildTerrace = !(this.countCellsInArea(x, z = random.nextInt(this.tableWidth / 2) * 2, x + 2, z + 2, CellType.EMPTY) != 9 || x - 3 >= ROW_OF_CELLS && x <= ROW_OF_CELLS || z - 3 >= ROW_OF_CELLS && z <= ROW_OF_CELLS);
            if (buildTerrace) {
                if (x > 0) {
                    boolean bl2 = buildTerrace = buildTerrace && this.countCellsInArea(x - 1, z, x - 1, z + 2, CellType.EMPTY) == 3;
                }
                if (x < this.tableWidth - 3) {
                    boolean bl3 = buildTerrace = buildTerrace && this.countCellsInArea(x + 3, z, x + 3, z + 2, CellType.EMPTY) == 3;
                }
                if (z > 0) {
                    boolean bl4 = buildTerrace = buildTerrace && this.countCellsInArea(x, z - 1, x + 2, z - 1, CellType.EMPTY) == 3;
                }
                if (z < this.tableWidth - 3) {
                    boolean bl5 = buildTerrace = buildTerrace && this.countCellsInArea(x, z + 3, x + 2, z + 3, CellType.EMPTY) == 3;
                }
            }
            if (!buildTerrace) continue;
            ComponentTFNagaCourtyardTerraceAbstract terrace = random.nextInt(150) == 0 ? new ComponentTFNagaCourtyardTerraceStatue(1, this.field_74887_e.field_78897_a + 3 + x * 6, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 3 + z * 6, random.nextInt(4)) : (random.nextBoolean() ? new ComponentTFNagaCourtyardTerraceBrazier(1, this.field_74887_e.field_78897_a + 3 + x * 6, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 3 + z * 6, 0) : new ComponentTFNagaCourtyardTerraceDuct(1, this.field_74887_e.field_78897_a + 3 + x * 6, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 3 + z * 6, random.nextInt(4)));
            list.add(terrace);
            terrace.func_74861_a(this, list, random);
            this.fillTable(x, z, x + 2, z + 2, CellType.TERRACE);
            --this.terraceLeft;
        }
        for (x = 0; x < this.tableWidth; ++x) {
            for (z = 0; z < this.tableWidth; ++z) {
                if (x % 2 != 1 || z % 2 != 1 || this.courtyard[x][z] != CellType.EMPTY || x == z && x == this.tableWidth / 2) continue;
                this.courtyard[x][z] = CellType.HEDGE;
                ComponentTFNagaCourtyardHedge hedge = new ComponentTFNagaCourtyardHedge(1, this.field_74887_e.field_78897_a + 3 + x * 6, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 3 + z * 6, 0);
                list.add(hedge);
                hedge.func_74861_a(this, list, random);
            }
        }
        for (x = 0; x < this.tableWidth; ++x) {
            for (z = 0; z < this.tableWidth; ++z) {
                ArrayList<ConnectionDirection> possibleConnections;
                if (x % 2 != 1 || z % 2 != 1 || this.courtyard[x][z] != CellType.HEDGE || (possibleConnections = this.getPossibleConnections(x, z)).size() <= 0) continue;
                ConnectionDirection direction = possibleConnections.get(random.nextInt(possibleConnections.size()));
                int x1 = x;
                int z1 = z;
                switch (direction) {
                    default: {
                        ++x1;
                        break;
                    }
                    case SOUTH: {
                        --x1;
                        break;
                    }
                    case EAST: {
                        ++z1;
                        break;
                    }
                    case WEST: {
                        --z1;
                    }
                }
                this.courtyard[x1][z1] = CellType.HEDGE;
                ComponentTFNagaCourtyardHedge hedge = new ComponentTFNagaCourtyardHedge(1, this.field_74887_e.field_78897_a + 3 + x1 * 6, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 3 + z1 * 6, 0);
                list.add(hedge);
                hedge.func_74861_a(this, list, random);
            }
        }
        for (x = 0; x < this.tableWidth; ++x) {
            for (z = 0; z < this.tableWidth; ++z) {
                if (this.courtyard[x][z] != CellType.HEDGE) continue;
                if (this.countNeighbours(x, z) == 1 && x != 0 && x != this.tableWidth - 1 && z != 0 && z != this.tableWidth - 1 && random.nextInt(5) < 2) {
                    ComponentTFNagaCourtyardHedgePillar pillar = new ComponentTFNagaCourtyardHedgePillar(1, this.field_74887_e.field_78897_a + 3 + x * 6, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 3 + z * 6, 0);
                    list.add(pillar);
                    pillar.func_74861_a(this, list, random);
                }
                boolean generatePadderNorth = false;
                boolean generatePadderSouth = false;
                boolean generatePadderEast = false;
                boolean generatePadderWest = false;
                if (x == 0) {
                    generatePadderSouth = true;
                } else if (this.courtyard[x - 1][z] == CellType.OUTSIDE) {
                    generatePadderSouth = true;
                }
                if (z == 0) {
                    generatePadderWest = true;
                } else if (this.courtyard[x][z - 1] == CellType.OUTSIDE) {
                    generatePadderWest = true;
                }
                if (this.hasNeighbour(x, z, ConnectionDirection.NORTH) || x == this.tableWidth - 1) {
                    generatePadderNorth = true;
                }
                if (this.hasNeighbour(x, z, ConnectionDirection.EAST) || z == this.tableWidth - 1) {
                    generatePadderEast = true;
                }
                if (generatePadderNorth) {
                    padder3 = new ComponentTFNagaCourtyardHedgePadder(1, this.field_74887_e.field_78897_a + 1 + (x + 1) * 6, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 6 + z * 6, 3);
                    list.add(padder3);
                    padder3.func_74861_a(this, list, random);
                }
                if (generatePadderSouth) {
                    padder3 = new ComponentTFNagaCourtyardHedgePadder(1, this.field_74887_e.field_78897_a + 1 + x * 6, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 6 + z * 6, 3);
                    list.add(padder3);
                    padder3.func_74861_a(this, list, random);
                }
                if (generatePadderEast) {
                    padder3 = new ComponentTFNagaCourtyardHedgePadder(1, this.field_74887_e.field_78897_a + 3 + x * 6, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 2 + (z + 1) * 6, 0);
                    list.add(padder3);
                    padder3.func_74861_a(this, list, random);
                }
                if (!generatePadderWest) continue;
                padder3 = new ComponentTFNagaCourtyardHedgePadder(1, this.field_74887_e.field_78897_a + 3 + x * 6, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 2 + z * 6, 0);
                list.add(padder3);
                padder3.func_74861_a(this, list, random);
            }
        }
        boolean generatingWall = false;
        int i = 0;
        int j = 0;
        int lastOutsideX = 0;
        int firstOutsideX = 0;
        while (!generatingWall) {
            if (this.courtyard[i][0] == CellType.OUTSIDE && this.courtyard[i + 1][0] != CellType.OUTSIDE) {
                generatingWall = true;
                lastOutsideX = i;
                ComponentTFNagaCourtyardWallCornerOuter corner4 = new ComponentTFNagaCourtyardWallCornerOuter(1, this.field_74887_e.field_78897_a + (i + 1) * 6, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c, 0);
                list.add(corner4);
                corner4.func_74861_a(this, list, random);
                padder3 = new ComponentTFNagaCourtyardWallPadder(1, this.field_74887_e.field_78897_a + ((i + 1) * 6 + 5), this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c, 0);
                list.add(padder3);
                padder3.func_74861_a(this, list, random);
                ++i;
            }
            ++i;
        }
        while (generatingWall) {
            ComponentTFNagaCourtyardWall wall4;
            if (this.courtyard[i][0] != CellType.OUTSIDE && this.courtyard[i + 2][0] == CellType.OUTSIDE) {
                generatingWall = false;
                firstOutsideX = i + 2;
                wall4 = new ComponentTFNagaCourtyardWall(1, this.field_74887_e.field_78897_a + i * 6, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c, 0);
                list.add(wall4);
                wall4.func_74861_a(this, list, random);
                padder3 = new ComponentTFNagaCourtyardWallPadder(1, this.field_74887_e.field_78897_a + (i * 6 + 11), this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c, 0);
                list.add(padder3);
                padder3.func_74861_a(this, list, random);
                corner3 = new ComponentTFNagaCourtyardWallCornerOuter(1, this.field_74887_e.field_78897_a + (i * 6 + 12), this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c, 1);
                list.add(corner3);
                corner3.func_74861_a(this, list, random);
            } else {
                wall4 = new ComponentTFNagaCourtyardWall(1, this.field_74887_e.field_78897_a + i * 6, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c, 0);
                list.add(wall4);
                wall4.func_74861_a(this, list, random);
                padder3 = new ComponentTFNagaCourtyardWallPadder(1, this.field_74887_e.field_78897_a + (i * 6 + 11), this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c, 0);
                list.add(padder3);
                padder3.func_74861_a(this, list, random);
                ++i;
            }
            ++i;
        }
        i = lastOutsideX;
        j = 1;
        do {
            padder2 = new ComponentTFNagaCourtyardWallPadder(1, this.field_74887_e.field_78897_a + ((i + 1) * 6 + 2), this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + (j * 6 - 1), 1);
            list.add(padder2);
            padder2.func_74861_a(this, list, random);
            if (this.courtyard[i][j + 1] == CellType.OUTSIDE) {
                wall3 = new ComponentTFNagaCourtyardWall(1, this.field_74887_e.field_78897_a + ((i + 1) * 6 - 8), this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + j * 6, 1);
                list.add(wall3);
                wall3.func_74861_a(this, list, random);
                wall12 = new ComponentTFNagaCourtyardWall(1, this.field_74887_e.field_78897_a + (i + 1) * 6, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + (j * 6 + 8), 3);
                list.add(wall12);
                wall12.func_74861_a(this, list, random);
                padder2 = new ComponentTFNagaCourtyardWallPadder(1, this.field_74887_e.field_78897_a + ((i + 1) * 6 + 2), this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + (j * 6 + 11), 1);
                list.add(padder2);
                padder2.func_74861_a(this, list, random);
                j += 2;
            }
            cornerInner = new ComponentTFNagaCourtyardWallCornerInner(1, this.field_74887_e.field_78897_a + i * 6, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + j * 6, 3);
            list.add(cornerInner);
            cornerInner.func_74861_a(this, list, random);
            padder2 = new ComponentTFNagaCourtyardWallPadder(1, this.field_74887_e.field_78897_a + (i * 6 - 1), this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + (j + 1) * 6, 0);
            list.add(padder2);
            padder2.func_74861_a(this, list, random);
            ++j;
            if (--i == 0) continue;
            if (this.courtyard[i - 1][j] != CellType.OUTSIDE) {
                wall2 = new ComponentTFNagaCourtyardWall(1, this.field_74887_e.field_78897_a + (i * 6 - 6), this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + j * 6, 0);
                list.add(wall2);
                wall2.func_74861_a(this, list, random);
                padder2 = new ComponentTFNagaCourtyardWallPadder(1, this.field_74887_e.field_78897_a + (i * 6 - 7), this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + j * 6, 0);
                list.add(padder2);
                padder2.func_74861_a(this, list, random);
                i -= 2;
                continue;
            }
            corner3 = new ComponentTFNagaCourtyardWallCornerOuter(1, this.field_74887_e.field_78897_a + i * 6, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + j * 6, 0);
            list.add(corner3);
            corner3.func_74861_a(this, list, random);
            ++j;
            --i;
        } while (i > 0);
        i = firstOutsideX;
        j = 1;
        do {
            padder2 = new ComponentTFNagaCourtyardWallPadder(1, this.field_74887_e.field_78893_d - (this.tableWidth - 2 - i) * 6 - 12, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + (j * 6 - 1), 1);
            list.add(padder2);
            padder2.func_74861_a(this, list, random);
            if (this.courtyard[i][j + 1] == CellType.OUTSIDE) {
                wall3 = new ComponentTFNagaCourtyardWall(1, this.field_74887_e.field_78893_d - (this.tableWidth - 2 - i) * 6 - 22, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + j * 6, 1);
                list.add(wall3);
                wall3.func_74861_a(this, list, random);
                wall12 = new ComponentTFNagaCourtyardWall(1, this.field_74887_e.field_78893_d - (this.tableWidth - 2 - i) * 6 - 14, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + (j * 6 + 8), 3);
                list.add(wall12);
                wall12.func_74861_a(this, list, random);
                padder2 = new ComponentTFNagaCourtyardWallPadder(1, this.field_74887_e.field_78893_d - (this.tableWidth - 2 - i) * 6 - 12, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + (j * 6 + 11), 1);
                list.add(padder2);
                padder2.func_74861_a(this, list, random);
                j += 2;
            }
            cornerInner = new ComponentTFNagaCourtyardWallCornerInner(1, this.field_74887_e.field_78893_d - (this.tableWidth - 1 - i) * 6 - 8, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + j * 6, 0);
            list.add(cornerInner);
            cornerInner.func_74861_a(this, list, random);
            padder2 = new ComponentTFNagaCourtyardWallPadder(1, this.field_74887_e.field_78893_d - (this.tableWidth - 1 - i) * 6 + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + (j + 1) * 6, 0);
            list.add(padder2);
            padder2.func_74861_a(this, list, random);
            ++j;
            if (++i == this.tableWidth - 1) continue;
            if (this.courtyard[i + 1][j] != CellType.OUTSIDE) {
                wall2 = new ComponentTFNagaCourtyardWall(1, this.field_74887_e.field_78893_d - (this.tableWidth - 1 - i) * 6 - 4, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + j * 6, 0);
                list.add(wall2);
                wall2.func_74861_a(this, list, random);
                padder2 = new ComponentTFNagaCourtyardWallPadder(1, this.field_74887_e.field_78893_d - (this.tableWidth - 1 - i) * 6 + 7, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + j * 6, 0);
                list.add(padder2);
                padder2.func_74861_a(this, list, random);
                i += 2;
                continue;
            }
            corner3 = new ComponentTFNagaCourtyardWallCornerOuter(1, this.field_74887_e.field_78893_d - (this.tableWidth - 1 - i) * 6 - 4, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + j * 6, 1);
            list.add(corner3);
            corner3.func_74861_a(this, list, random);
            ++j;
            ++i;
        } while (i < this.tableWidth - 1);
        generatingWall = false;
        i = 0;
        while (!generatingWall) {
            if (this.courtyard[i][this.tableWidth - 1] == CellType.OUTSIDE && this.courtyard[i + 1][this.tableWidth - 1] != CellType.OUTSIDE) {
                generatingWall = true;
                lastOutsideX = i;
                corner2 = new ComponentTFNagaCourtyardWallCornerOuter(1, this.field_74887_e.field_78897_a + (i + 1) * 6, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f - 4, 3);
                list.add(corner2);
                corner2.func_74861_a(this, list, random);
                padder3 = new ComponentTFNagaCourtyardWallPadder(1, this.field_74887_e.field_78897_a + ((i + 1) * 6 + 5), this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f - 2, 0);
                list.add(padder3);
                padder3.func_74861_a(this, list, random);
                ++i;
            }
            ++i;
        }
        while (generatingWall) {
            if (this.courtyard[i][this.tableWidth - 1] != CellType.OUTSIDE && this.courtyard[i + 2][this.tableWidth - 1] == CellType.OUTSIDE) {
                generatingWall = false;
                firstOutsideX = i + 2;
                wall = new ComponentTFNagaCourtyardWall(1, this.field_74887_e.field_78897_a + i * 6, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f - 2, 0);
                list.add(wall);
                wall.func_74861_a(this, list, random);
                padder3 = new ComponentTFNagaCourtyardWallPadder(1, this.field_74887_e.field_78897_a + (i * 6 + 11), this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f - 2, 0);
                list.add(padder3);
                padder3.func_74861_a(this, list, random);
                corner3 = new ComponentTFNagaCourtyardWallCornerOuter(1, this.field_74887_e.field_78897_a + (i * 6 + 12), this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f - 4, 2);
                list.add(corner3);
                corner3.func_74861_a(this, list, random);
            } else {
                wall = new ComponentTFNagaCourtyardWall(1, this.field_74887_e.field_78897_a + i * 6, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f - 2, 0);
                list.add(wall);
                wall.func_74861_a(this, list, random);
                padder3 = new ComponentTFNagaCourtyardWallPadder(1, this.field_74887_e.field_78897_a + (i * 6 + 11), this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f - 2, 0);
                list.add(padder3);
                padder3.func_74861_a(this, list, random);
                ++i;
            }
            ++i;
        }
        i = lastOutsideX;
        j = this.tableWidth - 2;
        do {
            padder2 = new ComponentTFNagaCourtyardWallPadder(1, this.field_74887_e.field_78897_a + ((i + 1) * 6 + 2), this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f - ((this.tableWidth - 1 - j) * 6 - 1), 1);
            list.add(padder2);
            padder2.func_74861_a(this, list, random);
            if (this.courtyard[i][j - 1] == CellType.OUTSIDE) {
                wall3 = new ComponentTFNagaCourtyardWall(1, this.field_74887_e.field_78897_a + ((i + 1) * 6 - 8), this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f - (this.tableWidth - 1 - j) * 6 - 10, 1);
                list.add(wall3);
                wall3.func_74861_a(this, list, random);
                wall12 = new ComponentTFNagaCourtyardWall(1, this.field_74887_e.field_78897_a + (i + 1) * 6, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f - ((this.tableWidth - 1 - j) * 6 + 2), 3);
                list.add(wall12);
                wall12.func_74861_a(this, list, random);
                padder2 = new ComponentTFNagaCourtyardWallPadder(1, this.field_74887_e.field_78897_a + ((i + 1) * 6 + 2), this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f - ((this.tableWidth - 1 - j) * 6 + 11), 1);
                list.add(padder2);
                padder2.func_74861_a(this, list, random);
                j -= 2;
            }
            cornerInner = new ComponentTFNagaCourtyardWallCornerInner(1, this.field_74887_e.field_78897_a + i * 6, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f - (this.tableWidth - 1 - j) * 6 - 8, 2);
            list.add(cornerInner);
            cornerInner.func_74861_a(this, list, random);
            padder2 = new ComponentTFNagaCourtyardWallPadder(1, this.field_74887_e.field_78897_a + (i * 6 - 1), this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f - (this.tableWidth - 1 - j) * 6 - 8, 0);
            list.add(padder2);
            padder2.func_74861_a(this, list, random);
            --j;
            if (--i == 0) continue;
            if (this.courtyard[i - 1][j] != CellType.OUTSIDE) {
                wall2 = new ComponentTFNagaCourtyardWall(1, this.field_74887_e.field_78897_a + (i * 6 - 6), this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f - ((this.tableWidth - 1 - j) * 6 + 2), 0);
                list.add(wall2);
                wall2.func_74861_a(this, list, random);
                padder2 = new ComponentTFNagaCourtyardWallPadder(1, this.field_74887_e.field_78897_a + (i * 6 - 7), this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f - ((this.tableWidth - 1 - j) * 6 + 2), 0);
                list.add(padder2);
                padder2.func_74861_a(this, list, random);
                i -= 2;
                continue;
            }
            corner3 = new ComponentTFNagaCourtyardWallCornerOuter(1, this.field_74887_e.field_78897_a + i * 6, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f - ((this.tableWidth - 1 - j) * 6 + 4), 3);
            list.add(corner3);
            corner3.func_74861_a(this, list, random);
            --j;
            --i;
        } while (i > 0);
        i = firstOutsideX;
        j = this.tableWidth - 2;
        do {
            padder2 = new ComponentTFNagaCourtyardWallPadder(1, this.field_74887_e.field_78893_d - (this.tableWidth - 2 - i) * 6 - 12, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f - ((this.tableWidth - 1 - j) * 6 - 1), 1);
            list.add(padder2);
            padder2.func_74861_a(this, list, random);
            if (this.courtyard[i][j - 1] == CellType.OUTSIDE) {
                wall3 = new ComponentTFNagaCourtyardWall(1, this.field_74887_e.field_78893_d - (this.tableWidth - 2 - i) * 6 - 22, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f - (this.tableWidth - 1 - j) * 6 - 10, 1);
                list.add(wall3);
                wall3.func_74861_a(this, list, random);
                wall12 = new ComponentTFNagaCourtyardWall(1, this.field_74887_e.field_78893_d - (this.tableWidth - 2 - i) * 6 - 14, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f - ((this.tableWidth - 1 - j) * 6 + 2), 3);
                list.add(wall12);
                wall12.func_74861_a(this, list, random);
                padder2 = new ComponentTFNagaCourtyardWallPadder(1, this.field_74887_e.field_78893_d - (this.tableWidth - 2 - i) * 6 - 12, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f - ((this.tableWidth - 1 - j) * 6 + 11), 1);
                list.add(padder2);
                padder2.func_74861_a(this, list, random);
                j -= 2;
            }
            cornerInner = new ComponentTFNagaCourtyardWallCornerInner(1, this.field_74887_e.field_78893_d - (this.tableWidth - 1 - i) * 6 - 8, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f - ((this.tableWidth - 1 - j) * 6 + 8), 1);
            list.add(cornerInner);
            cornerInner.func_74861_a(this, list, random);
            padder2 = new ComponentTFNagaCourtyardWallPadder(1, this.field_74887_e.field_78893_d - (this.tableWidth - 1 - i) * 6 + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f - ((this.tableWidth - 1 - j) * 6 + 8), 0);
            list.add(padder2);
            padder2.func_74861_a(this, list, random);
            --j;
            if (++i == this.tableWidth - 1) continue;
            if (this.courtyard[i + 1][j] != CellType.OUTSIDE) {
                wall2 = new ComponentTFNagaCourtyardWall(1, this.field_74887_e.field_78893_d - (this.tableWidth - 1 - i) * 6 - 4, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f - ((this.tableWidth - 1 - j) * 6 + 2), 0);
                list.add(wall2);
                wall2.func_74861_a(this, list, random);
                padder2 = new ComponentTFNagaCourtyardWallPadder(1, this.field_74887_e.field_78893_d - (this.tableWidth - 1 - i) * 6 + 7, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f - ((this.tableWidth - 1 - j) * 6 + 2), 0);
                list.add(padder2);
                padder2.func_74861_a(this, list, random);
                i += 2;
                continue;
            }
            corner3 = new ComponentTFNagaCourtyardWallCornerOuter(1, this.field_74887_e.field_78893_d - (this.tableWidth - 1 - i) * 6 - 4, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f - (this.tableWidth - 1 - j) * 6 - 4, 2);
            list.add(corner3);
            corner3.func_74861_a(this, list, random);
            --j;
            ++i;
        } while (i < this.tableWidth - 1);
        generatingWall = false;
        i = 0;
        while (!generatingWall) {
            if (this.courtyard[0][i] == CellType.OUTSIDE && this.courtyard[0][i + 1] != CellType.OUTSIDE) {
                generatingWall = true;
                corner2 = new ComponentTFNagaCourtyardWallCornerOuter(1, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + (i + 1) * 6, 0);
                list.add(corner2);
                corner2.func_74861_a(this, list, random);
                padder3 = new ComponentTFNagaCourtyardWallPadder(1, this.field_74887_e.field_78897_a + 2, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + ((i + 1) * 6 + 5), 1);
                list.add(padder3);
                padder3.func_74861_a(this, list, random);
                ++i;
            }
            ++i;
        }
        while (generatingWall) {
            if (this.courtyard[0][i] != CellType.OUTSIDE && this.courtyard[0][i + 2] == CellType.OUTSIDE) {
                generatingWall = false;
                wall = new ComponentTFNagaCourtyardWall(1, this.field_74887_e.field_78897_a - 8, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + i * 6, 1);
                list.add(wall);
                wall.func_74861_a(this, list, random);
                wall1 = new ComponentTFNagaCourtyardWall(1, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + (i * 6 + 8), 3);
                list.add(wall1);
                wall1.func_74861_a(this, list, random);
                padder = new ComponentTFNagaCourtyardWallPadder(1, this.field_74887_e.field_78897_a + 2, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + ((i + 1) * 6 + 5), 1);
                list.add(padder);
                padder.func_74861_a(this, list, random);
                corner = new ComponentTFNagaCourtyardWallCornerOuter(1, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + ((i + 1) * 6 + 6), 3);
                list.add(corner);
                corner.func_74861_a(this, list, random);
            } else {
                wall = new ComponentTFNagaCourtyardWall(1, this.field_74887_e.field_78897_a - 8, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + i * 6, 1);
                list.add(wall);
                wall.func_74861_a(this, list, random);
                wall1 = new ComponentTFNagaCourtyardWall(1, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + (i * 6 + 8), 3);
                list.add(wall1);
                wall1.func_74861_a(this, list, random);
                padder = new ComponentTFNagaCourtyardWallPadder(1, this.field_74887_e.field_78897_a + 2, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + ((i + 1) * 6 + 5), 1);
                list.add(padder);
                padder.func_74861_a(this, list, random);
                ++i;
            }
            ++i;
        }
        generatingWall = false;
        i = 0;
        while (!generatingWall) {
            if (this.courtyard[this.tableWidth - 1][i] == CellType.OUTSIDE && this.courtyard[this.tableWidth - 1][i + 1] != CellType.OUTSIDE) {
                generatingWall = true;
                corner2 = new ComponentTFNagaCourtyardWallCornerOuter(1, this.field_74887_e.field_78893_d - 4, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + (i + 1) * 6, 1);
                list.add(corner2);
                corner2.func_74861_a(this, list, random);
                padder3 = new ComponentTFNagaCourtyardWallPadder(1, this.field_74887_e.field_78893_d, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + ((i + 1) * 6 + 5), 1);
                list.add(padder3);
                padder3.func_74861_a(this, list, random);
                ++i;
            }
            ++i;
        }
        while (generatingWall) {
            if (this.courtyard[this.tableWidth - 1][i] != CellType.OUTSIDE && this.courtyard[this.tableWidth - 1][i + 2] == CellType.OUTSIDE) {
                generatingWall = false;
                wall = new ComponentTFNagaCourtyardWall(1, this.field_74887_e.field_78893_d - 10, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + i * 6, 1);
                list.add(wall);
                wall.func_74861_a(this, list, random);
                wall1 = new ComponentTFNagaCourtyardWall(1, this.field_74887_e.field_78893_d - 2, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + (i * 6 + 8), 3);
                list.add(wall1);
                wall1.func_74861_a(this, list, random);
                padder = new ComponentTFNagaCourtyardWallPadder(1, this.field_74887_e.field_78893_d, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + ((i + 1) * 6 + 5), 1);
                list.add(padder);
                padder.func_74861_a(this, list, random);
                corner = new ComponentTFNagaCourtyardWallCornerOuter(1, this.field_74887_e.field_78893_d - 4, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + ((i + 1) * 6 + 6), 2);
                list.add(corner);
                corner.func_74861_a(this, list, random);
            } else {
                wall = new ComponentTFNagaCourtyardWall(1, this.field_74887_e.field_78893_d - 10, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + i * 6, 1);
                list.add(wall);
                wall.func_74861_a(this, list, random);
                wall1 = new ComponentTFNagaCourtyardWall(1, this.field_74887_e.field_78893_d - 2, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + (i * 6 + 8), 3);
                list.add(wall1);
                wall1.func_74861_a(this, list, random);
                padder = new ComponentTFNagaCourtyardWallPadder(1, this.field_74887_e.field_78893_d, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + ((i + 1) * 6 + 5), 1);
                list.add(padder);
                padder.func_74861_a(this, list, random);
                ++i;
            }
            ++i;
        }
        ComponentTFNagaCourtyardDecorator decorator = new ComponentTFNagaCourtyardDecorator(1, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c, this.field_74887_e.func_78883_b(), this.field_74887_e.func_78882_c(), this.field_74887_e.func_78880_d());
        list.add(decorator);
        decorator.func_74861_a(this, list, random);
    }

    @Override
    protected void func_143012_a(NBTTagCompound tag) {
        super.func_143012_a(tag);
        int numBits = this.tableWidth * this.tableWidth;
        byte[] emptySpots = new byte[1 + numBits / 8 + (numBits % 8 > 0 ? 1 : 0)];
        emptySpots[0] = (byte)this.tableWidth;
        for (int x = 0; x < this.tableWidth; ++x) {
            for (int z = 0; z < this.tableWidth; ++z) {
                if (this.courtyard[x][z] != CellType.EMPTY) continue;
                int bitIndex = this.tableWidth * x + z;
                int n = 1 + bitIndex / 8;
                emptySpots[n] = (byte)(emptySpots[n] | 1 << bitIndex % 8);
            }
        }
        tag.func_74773_a("CY", emptySpots);
    }

    @Override
    protected void func_143011_b(NBTTagCompound tag) {
        super.func_143011_b(tag);
        byte[] emptySpots = tag.func_74770_j("CY");
        if (emptySpots.length > 1) {
            this.tableWidth = emptySpots[0];
            this.courtyard = new CellType[this.tableWidth][this.tableWidth];
            int index = 1;
            int shift = 0;
            block0: for (int x = 0; x < this.tableWidth; ++x) {
                for (int z = 0; z < this.tableWidth; ++z) {
                    if (((emptySpots[index] & 0xFF) >> shift++ & 1) == 1) {
                        this.courtyard[x][z] = CellType.EMPTY;
                    }
                    if (shift < 8) continue;
                    shift = 0;
                    if (++index >= emptySpots.length) break block0;
                }
            }
        }
    }

    public boolean func_74875_a(World world, Random rand, StructureBoundingBox sbb) {
        for (int i = 0; i < this.tableWidth; ++i) {
            for (int j = 0; j < this.tableWidth; ++j) {
                if (this.courtyard[i][j] != CellType.EMPTY) continue;
                int startX = 3 + i * 6;
                int startZ = 3 + j * 6;
                for (int k = 0; k < 5; ++k) {
                    for (int l = 0; l < 5; ++l) {
                        if (k == 2 || l == 2) continue;
                        if (this.func_151548_a(world, startX + k, 0, startZ + l, sbb) != Blocks.field_150350_a) {
                            this.func_151550_a(world, TFBlocks.nagastoneEtched, 0, startX + k, 0, startZ + l, sbb);
                            continue;
                        }
                        if (this.func_151548_a(world, startX + k, -1, startZ + l, sbb) == Blocks.field_150350_a) continue;
                        this.func_151550_a(world, TFBlocks.nagastoneEtched, 0, startX + k, -1, startZ + l, sbb);
                    }
                }
                this.func_151549_a(world, sbb, startX, 0, startZ, startX + 1, 0, startZ + 1, TFBlocks.nagastoneEtched, TFBlocks.nagastoneEtched, true);
                this.func_151549_a(world, sbb, startX + 3, 0, startZ, startX + 4, 0, startZ + 1, TFBlocks.nagastoneEtched, TFBlocks.nagastoneEtched, true);
                this.func_151549_a(world, sbb, startX, 0, startZ + 3, startX + 1, 0, startZ + 4, TFBlocks.nagastoneEtched, TFBlocks.nagastoneEtched, true);
                this.func_151549_a(world, sbb, startX + 3, 0, startZ + 3, startX + 4, 0, startZ + 4, TFBlocks.nagastoneEtched, TFBlocks.nagastoneEtched, true);
            }
        }
        this.func_151550_a(world, TFBlocks.bossSpawner, 0, RADIUS + 3, 2, RADIUS + 3, sbb);
        return true;
    }

    private int countCellsInArea(int minX, int minZ, int maxX, int maxZ, CellType countType) {
        int cellsCount = 0;
        for (int i = minX; i <= maxX; ++i) {
            for (int j = minZ; j <= maxZ; ++j) {
                if (this.courtyard[i][j] != countType) continue;
                ++cellsCount;
            }
        }
        return cellsCount;
    }

    private int countNeighbours(int x, int z, CellType neighbour) {
        int neighbours = 0;
        if (x > 0 && this.courtyard[x - 1][z] == neighbour) {
            ++neighbours;
        }
        if (x < this.tableWidth - 1 && this.courtyard[x + 1][z] == neighbour) {
            ++neighbours;
        }
        if (z > 0 && this.courtyard[x][z - 1] == neighbour) {
            ++neighbours;
        }
        if (z < this.tableWidth - 1 && this.courtyard[x][z + 1] == neighbour) {
            ++neighbours;
        }
        return neighbours;
    }

    private int countNeighbours(int x, int z) {
        return this.countNeighbours(x, z, CellType.HEDGE);
    }

    private ArrayList<ConnectionDirection> getPossibleConnections(int x, int z) {
        ArrayList<ConnectionDirection> possibleConnections = new ArrayList<ConnectionDirection>();
        if (x == 5 && z == 11) {
            boolean bl = false;
        }
        if (this.countNeighbours(x, z) < 2) {
            for (int i = 0; i < 4; ++i) {
                ConnectionDirection direction = this.directionFromInt(i);
                if (!this.canConnectTo(x, z, direction)) continue;
                possibleConnections.add(direction);
            }
        }
        return possibleConnections;
    }

    private boolean hasNeighbour(int x, int z, ConnectionDirection direction) {
        switch (direction) {
            default: {
                if (x >= this.tableWidth - 1) break;
                return this.courtyard[x + 1][z] == CellType.HEDGE;
            }
            case SOUTH: {
                if (x <= 0) break;
                return this.courtyard[x - 1][z] == CellType.HEDGE;
            }
            case EAST: {
                if (z >= this.tableWidth - 1) break;
                return this.courtyard[x][z + 1] == CellType.HEDGE;
            }
            case WEST: {
                if (z <= 0) break;
                return this.courtyard[x][z - 1] == CellType.HEDGE;
            }
        }
        return false;
    }

    private ConnectionDirection directionFromInt(int x) {
        switch (x) {
            default: {
                return ConnectionDirection.NORTH;
            }
            case 1: {
                return ConnectionDirection.SOUTH;
            }
            case 2: {
                return ConnectionDirection.EAST;
            }
            case 3: 
        }
        return ConnectionDirection.WEST;
    }

    private ConnectionDirection getOppositeDirection(ConnectionDirection direction) {
        switch (direction) {
            default: {
                return ConnectionDirection.SOUTH;
            }
            case SOUTH: {
                return ConnectionDirection.NORTH;
            }
            case EAST: {
                return ConnectionDirection.WEST;
            }
            case WEST: 
        }
        return ConnectionDirection.EAST;
    }

    private boolean canConnectTo(int x, int z, ConnectionDirection direction) {
        if (this.hasNeighbour(x, z, direction) || this.hasNeighbour(x, z, this.getOppositeDirection(direction))) {
            return false;
        }
        int connectX = x;
        int connectZ = z;
        switch (direction) {
            default: {
                if (z > 1 && this.hasNeighbour(x, z, ConnectionDirection.WEST)) {
                    --connectZ;
                }
                if (z >= this.tableWidth - 2 || !this.hasNeighbour(x, z, ConnectionDirection.EAST)) break;
                ++connectZ;
                break;
            }
            case EAST: 
            case WEST: {
                if (x > 1 && this.hasNeighbour(x, z, ConnectionDirection.SOUTH)) {
                    --connectX;
                }
                if (x >= this.tableWidth - 2 || !this.hasNeighbour(x, z, ConnectionDirection.NORTH)) break;
                ++connectX;
            }
        }
        if (!(connectX == x && connectZ == z || this.countNeighbours(connectX, connectZ) != 2 || this.hasNeighbour(connectX, connectZ, direction))) {
            return false;
        }
        connectX = x;
        connectZ = z;
        switch (direction) {
            default: {
                if (x == this.tableWidth - 2) {
                    return true;
                }
                connectX += 2;
                break;
            }
            case SOUTH: {
                if (x == 1) {
                    return true;
                }
                connectX -= 2;
                break;
            }
            case EAST: {
                if (z == this.tableWidth - 2) {
                    return true;
                }
                connectZ += 2;
                break;
            }
            case WEST: {
                if (z == 1) {
                    return true;
                }
                connectZ -= 2;
            }
        }
        if (this.courtyard[connectX][connectZ] != CellType.HEDGE) {
            return false;
        }
        if (this.courtyard[connectX][connectZ] == CellType.OUTSIDE) {
            return true;
        }
        switch (this.countNeighbours(connectX, connectZ)) {
            case 0: {
                return true;
            }
            case 1: {
                if (this.hasNeighbour(connectX, connectZ, direction)) {
                    return false;
                }
                int connectX1 = connectX;
                int connectZ1 = connectZ;
                switch (direction) {
                    default: {
                        if (this.hasNeighbour(connectX, connectZ, ConnectionDirection.EAST)) {
                            if (connectZ == this.tableWidth - 2) {
                                return true;
                            }
                            connectZ1 += 2;
                            break;
                        }
                        if (connectZ == 1) {
                            return true;
                        }
                        connectZ1 -= 2;
                        break;
                    }
                    case EAST: 
                    case WEST: {
                        if (this.hasNeighbour(connectX, connectZ, ConnectionDirection.NORTH)) {
                            if (connectX == this.tableWidth - 2) {
                                return true;
                            }
                            connectX1 += 2;
                            break;
                        }
                        if (connectX == 1) {
                            return true;
                        }
                        connectX1 -= 2;
                    }
                }
                return this.countNeighbours(connectX1, connectZ1) == 1 || this.hasNeighbour(connectX1, connectZ1, this.getOppositeDirection(direction));
            }
        }
        return false;
    }

    public static enum CellType {
        OUTSIDE,
        EMPTY,
        HEDGE,
        TERRACE;

    }

    public static enum ConnectionDirection {
        NORTH,
        SOUTH,
        EAST,
        WEST;

    }
}

