/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.integration;

import baubles.common.container.InventoryBaubles;
import baubles.common.lib.PlayerHandler;
import java.io.File;
import java.util.HashMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import twilightforest.TFEventListener;
import twilightforest.TwilightForestMod;

public class TFBaublesIntegration {
    public static HashMap<String, InventoryBaubles> playerBaublesMap = new HashMap();

    public static void clearPlayerMap(EntityPlayer player) {
        if (TwilightForestMod.areBaublesLoaded) {
            playerBaublesMap.remove(player.func_70005_c_());
        }
    }

    public static InventoryBaubles getPlayerKeepBaubles(EntityPlayer player) {
        if (!playerBaublesMap.containsKey(player.func_70005_c_())) {
            InventoryBaubles inventory = new InventoryBaubles(player);
            playerBaublesMap.put(player.func_70005_c_(), inventory);
        }
        return playerBaublesMap.get(player.func_70005_c_());
    }

    public static void setPlayerKeepBaubles(EntityPlayer player, InventoryBaubles inventory) {
        playerBaublesMap.put(player.func_70005_c_(), inventory);
    }

    public static void loadPlayerKeepBaubles(EntityPlayer player, NBTTagCompound data) {
        if (TwilightForestMod.areBaublesLoaded) {
            InventoryBaubles keepBaubles = new InventoryBaubles(player);
            keepBaubles.readNBT(data);
            playerBaublesMap.put(player.func_70005_c_(), keepBaubles);
        }
    }

    public static void savePlayerKeepBaubles(EntityPlayer player, NBTTagCompound data) {
        if (TwilightForestMod.areBaublesLoaded) {
            InventoryBaubles inventory = TFBaublesIntegration.getPlayerKeepBaubles(player);
            inventory.saveNBT(data);
        }
    }

    public static Boolean consumeBaublesItem(EntityPlayer player, Item item) {
        if (TwilightForestMod.areBaublesLoaded) {
            InventoryBaubles inventoryBaubles = PlayerHandler.getPlayerBaubles((EntityPlayer)player);
            for (int a = 0; a < inventoryBaubles.func_70302_i_(); ++a) {
                ItemStack stackInSlot = inventoryBaubles.func_70301_a(a);
                if (stackInSlot == null || stackInSlot.func_77973_b() != item) continue;
                if (--stackInSlot.field_77994_a <= 0) {
                    inventoryBaubles.func_70299_a(a, null);
                }
                return true;
            }
        }
        return false;
    }

    public static ItemStack[] keepAllBaubles(EntityPlayer player) {
        ItemStack[] baublesInventory = null;
        if (TwilightForestMod.areBaublesLoaded) {
            InventoryBaubles inventoryBaubles = PlayerHandler.getPlayerBaubles((EntityPlayer)player);
            baublesInventory = new ItemStack[inventoryBaubles.func_70302_i_()];
            for (int i = 0; i < inventoryBaubles.func_70302_i_(); ++i) {
                baublesInventory[i] = ItemStack.func_77944_b((ItemStack)inventoryBaubles.func_70301_a(i));
                inventoryBaubles.func_70299_a(i, null);
            }
        }
        return baublesInventory;
    }

    public static void restoreBaubles(EntityPlayer player, ItemStack[] baublesInventory) {
        if (TwilightForestMod.areBaublesLoaded && baublesInventory != null) {
            InventoryBaubles inventoryBaubles = PlayerHandler.getPlayerBaubles((EntityPlayer)player);
            for (int i = 0; i < inventoryBaubles.func_70302_i_(); ++i) {
                if (baublesInventory[i] == null) continue;
                inventoryBaubles.func_70299_a(i, baublesInventory[i]);
            }
        }
    }

    public static void playerSaveDo(EntityPlayer player, File directory) {
        if (TwilightForestMod.areBaublesLoaded) {
            PlayerHandler.savePlayerBaubles((EntityPlayer)player, (File)TFEventListener.getPlayerFile(TFEventListener.fileName, directory, player.func_70005_c_()), (File)TFEventListener.getPlayerFile(TFEventListener.fileNameBackup, directory, player.func_70005_c_()));
        }
    }
}

