/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.tools;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import java.util.ArrayList;
import java.util.Random;
import mantle.world.WorldHelper;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import tconstruct.armor.player.TFTPlayerStats;
import tconstruct.library.entity.ProjectileBase;
import tconstruct.library.event.ToolCraftEvent;
import tconstruct.library.tools.AbilityHelper;
import tconstruct.library.weaponry.AmmoItem;
import tconstruct.weaponry.ammo.ArrowAmmo;
import tconstruct.weaponry.ammo.BoltAmmo;
import tconstruct.weaponry.entity.ArrowEntity;
import tconstruct.weaponry.entity.BoltEntity;
import twilightforest.TwilightForestMod;
import twilightforest.integration.TFTinkerConstructIntegration;
import twilightforest.item.TFItems;

public class TFToolEvents {
    Random random = new Random();

    @SubscribeEvent
    public void craftTool(ToolCraftEvent.NormalTool event) {
        NBTTagCompound toolTag = event.toolTag.func_74775_l("InfiTool");
        ArrayList<Integer> twilitMaterials = new ArrayList<Integer>();
        twilitMaterials.add(TFTinkerConstructIntegration.MaterialID.FieryMetal);
        twilitMaterials.add(TFTinkerConstructIntegration.MaterialID.Knightmetal);
        twilitMaterials.add(TFTinkerConstructIntegration.MaterialID.NagaScale);
        twilitMaterials.add(TFTinkerConstructIntegration.MaterialID.Steeleaf);
        boolean hasTwilit = false;
        int twilitID = 5;
        if (twilitMaterials.contains(toolTag.func_74762_e("Head"))) {
            hasTwilit = true;
            twilitID = toolTag.func_74762_e("Head");
        } else if (twilitMaterials.contains(toolTag.func_74762_e("Handle"))) {
            hasTwilit = true;
            twilitID = toolTag.func_74762_e("Handle");
        } else if (twilitMaterials.contains(toolTag.func_74762_e("Accessory"))) {
            hasTwilit = true;
            twilitID = toolTag.func_74762_e("Accessory");
        } else if (twilitMaterials.contains(toolTag.func_74762_e("Extra"))) {
            hasTwilit = true;
            twilitID = toolTag.func_74762_e("Extra");
        } else if (event.tool instanceof AmmoItem && toolTag.func_74762_e("Accessory") == 5) {
            hasTwilit = true;
        }
        if (hasTwilit) {
            toolTag.func_74757_a("IsInTF", true);
            toolTag.func_74768_a("MiningSpeed", toolTag.func_74762_e("MiningSpeed") + 200);
            toolTag.func_74768_a("TwilitID", twilitID);
        }
        if (toolTag.func_74762_e("Head") == TFTinkerConstructIntegration.MaterialID.NagaScale || toolTag.func_74762_e("Handle") == TFTinkerConstructIntegration.MaterialID.NagaScale || toolTag.func_74762_e("Accessory") == TFTinkerConstructIntegration.MaterialID.NagaScale || toolTag.func_74762_e("Extra") == TFTinkerConstructIntegration.MaterialID.NagaScale) {
            toolTag.func_74768_a("PrecipitateSpeed", toolTag.func_74762_e("MiningSpeed"));
        }
        if (toolTag.func_74762_e("Head") == TFTinkerConstructIntegration.MaterialID.Steeleaf || toolTag.func_74762_e("Handle") == TFTinkerConstructIntegration.MaterialID.Steeleaf || toolTag.func_74762_e("Accessory") == TFTinkerConstructIntegration.MaterialID.Steeleaf || toolTag.func_74762_e("Extra") == TFTinkerConstructIntegration.MaterialID.Steeleaf) {
            toolTag.func_74757_a("Synergy", true);
        }
        if (toolTag.func_74762_e("Head") == TFTinkerConstructIntegration.MaterialID.Knightmetal || toolTag.func_74762_e("Handle") == TFTinkerConstructIntegration.MaterialID.Knightmetal || toolTag.func_74762_e("Accessory") == TFTinkerConstructIntegration.MaterialID.Knightmetal || toolTag.func_74762_e("Extra") == TFTinkerConstructIntegration.MaterialID.Knightmetal) {
            toolTag.func_74757_a("Stalwart", true);
        }
        if (toolTag.func_74762_e("Head") == TFTinkerConstructIntegration.MaterialID.FieryMetal || toolTag.func_74762_e("Handle") == TFTinkerConstructIntegration.MaterialID.FieryMetal || toolTag.func_74762_e("Accessory") == TFTinkerConstructIntegration.MaterialID.FieryMetal || toolTag.func_74762_e("Extra") == TFTinkerConstructIntegration.MaterialID.FieryMetal) {
            toolTag.func_74757_a("Lava", true);
            toolTag.func_74757_a("TFFiery", true);
            toolTag.func_74768_a("Fiery", 1);
        }
    }

    @SubscribeEvent
    public void tooltip(ItemTooltipEvent event) {
        if (!(event.itemStack != null && event.itemStack.func_77973_b() != null && event.itemStack.func_77942_o() && event.itemStack.func_77978_p().func_74764_b("InfiTool") && event.itemStack.func_77978_p().func_74775_l("InfiTool").func_74764_b("IsInTF"))) {
            return;
        }
        NBTTagCompound tags = event.itemStack.func_77978_p().func_74775_l("InfiTool");
        int tooltipIndex = 1;
        int lastEmptyIndex = -1;
        int twilitID = tags.func_74762_e("TwilitID");
        EnumChatFormatting color = this.colorFromID(twilitID);
        for (int i = event.toolTip.size() - 1; i > 1; --i) {
            if (((String)event.toolTip.get(i)).contains(color.toString())) {
                tooltipIndex = i;
            }
            if (lastEmptyIndex != -1 || !((String)event.toolTip.get(i)).isEmpty() || ((String)event.toolTip.get(i - 1)).isEmpty()) continue;
            lastEmptyIndex = i;
        }
        if (lastEmptyIndex == -1) {
            lastEmptyIndex = event.toolTip.size();
        }
        if (twilitID == 5) {
            tooltipIndex = lastEmptyIndex;
        }
        event.toolTip.add(tooltipIndex, "" + color + StatCollector.func_74838_a((String)"material.twilit.ability"));
        if ((event.itemStack.func_77973_b() instanceof ArrowAmmo || event.itemStack.func_77973_b() instanceof BoltAmmo) && tags.func_74762_e("Accessory") == 5) {
            event.toolTip.add(lastEmptyIndex + 1, "" + EnumChatFormatting.DARK_GRAY + StatCollector.func_74838_a((String)"material.raven_feather.ability"));
        }
        if (tags.func_74764_b("TFFiery")) {
            event.toolTip.add(tooltipIndex + 1, "" + EnumChatFormatting.GOLD + StatCollector.func_74838_a((String)"modifier.tooltip.Auto-Smelt"));
            event.toolTip.add(tooltipIndex + 2, "" + EnumChatFormatting.GOLD + StatCollector.func_74838_a((String)"modifier.tooltip.Fiery"));
        }
    }

    private EnumChatFormatting colorFromID(int materialID) {
        EnumChatFormatting cf = EnumChatFormatting.DARK_GRAY;
        if (materialID == TFTinkerConstructIntegration.MaterialID.FieryMetal) {
            cf = EnumChatFormatting.GOLD;
        } else if (materialID == TFTinkerConstructIntegration.MaterialID.Knightmetal) {
            cf = EnumChatFormatting.GREEN;
        } else if (materialID == TFTinkerConstructIntegration.MaterialID.NagaScale || materialID == TFTinkerConstructIntegration.MaterialID.Steeleaf) {
            cf = EnumChatFormatting.DARK_GREEN;
        }
        return cf;
    }

    @SubscribeEvent
    public void onArrowSpawn(EntityJoinWorldEvent event) {
        ProjectileBase entity;
        ItemStack entityItem;
        int accessory;
        if ((event.entity instanceof ArrowEntity || event.entity instanceof BoltEntity) && (accessory = (entityItem = (entity = (ProjectileBase)event.entity).getEntityItem()).func_77978_p().func_74775_l("InfiTool").func_74762_e("Accessory")) == 5) {
            entity.func_82142_c(true);
            entity.field_70155_l = 0.0;
        }
    }

    @SubscribeEvent
    public void onProjectileHit(LivingHurtEvent event) {
        DamageSource damageSource = event.source;
        if (damageSource instanceof EntityDamageSourceIndirect) {
            EntityDamageSourceIndirect damageSource2 = (EntityDamageSourceIndirect)damageSource;
            Entity damageSourceEntity = damageSource2.field_76386_o;
            if (damageSourceEntity instanceof ProjectileBase) {
                int accessory;
                Entity indirectEntity;
                ProjectileBase entity = (ProjectileBase)damageSourceEntity;
                ItemStack projectile = entity.getEntityItem();
                if (projectile.func_77978_p().func_74775_l("InfiTool").func_74764_b("Stalwart") && (indirectEntity = damageSource2.field_76387_p) instanceof EntityLivingBase) {
                    EntityLivingBase entityLiving = (EntityLivingBase)indirectEntity;
                    this.stalwartBuff(entityLiving);
                }
                if ((damageSourceEntity instanceof ArrowEntity || damageSourceEntity instanceof BoltEntity) && (accessory = projectile.func_77978_p().func_74775_l("InfiTool").func_74762_e("Accessory")) == 5) {
                    damageSource2.field_76387_p = null;
                }
            }
        }
    }

    private void stalwartBuff(EntityLivingBase entity) {
        if (this.random.nextInt(10) == 0) {
            PotionEffect potionEffect = entity.func_70660_b(Potion.field_76429_m);
            int amplifier = 0;
            int duration = 200;
            if (potionEffect != null) {
                amplifier = potionEffect.func_76458_c() < 2 ? potionEffect.func_76458_c() + 1 : 2;
                duration = potionEffect.func_76459_b() < 401 ? potionEffect.func_76459_b() + 200 : 600;
            }
            entity.func_70690_d(new PotionEffect(Potion.field_76429_m.field_76415_H, duration, amplifier));
        }
    }

    @SubscribeEvent
    public void onProjectileKill(LivingDeathEvent event) {
        DamageSource damageSource = event.source;
        if (damageSource instanceof EntityDamageSourceIndirect) {
            ProjectileBase entity;
            int accessory;
            EntityDamageSourceIndirect damageSource2 = (EntityDamageSourceIndirect)damageSource;
            Entity damageSourceEntity = damageSource2.field_76386_o;
            if ((damageSourceEntity instanceof ArrowEntity || damageSourceEntity instanceof BoltEntity) && (accessory = (entity = (ProjectileBase)damageSourceEntity).getEntityItem().func_77978_p().func_74775_l("InfiTool").func_74762_e("Accessory")) == 5) {
                damageSource2.field_76387_p = null;
            }
        }
    }

    @SubscribeEvent
    public void bucketFill(FillBucketEvent evt) {
        if (evt.current.func_77973_b() == Items.field_151133_ar && evt.target.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            int hitX = evt.target.field_72311_b;
            int hitY = evt.target.field_72312_c;
            int hitZ = evt.target.field_72309_d;
            if (evt.entityPlayer != null && !evt.entityPlayer.func_82247_a(hitX, hitY, hitZ, evt.target.field_72310_e, evt.current)) {
                return;
            }
            Block bID = evt.world.func_147439_a(hitX, hitY, hitZ);
            for (int id = 0; id < TFTinkerConstructIntegration.fluidBlocks.length; ++id) {
                if (bID != TFTinkerConstructIntegration.fluidBlocks[id]) continue;
                if (evt.entityPlayer.field_71075_bZ.field_75098_d) {
                    WorldHelper.setBlockToAir((World)evt.world, (int)hitX, (int)hitY, (int)hitZ);
                    continue;
                }
                WorldHelper.setBlockToAir((World)evt.world, (int)hitX, (int)hitY, (int)hitZ);
                evt.setResult(Event.Result.ALLOW);
                evt.result = new ItemStack(TFTinkerConstructIntegration.buckets, 1, id);
            }
        }
    }

    @SubscribeEvent
    public void onEntityConstructing(EntityEvent.EntityConstructing event) {
        EntityPlayer player;
        if (!TwilightForestMod.enableTiCIntegration) {
            return;
        }
        Entity entity = event.entity;
        if (entity instanceof EntityPlayer && TFTPlayerStats.get(player = (EntityPlayer)entity) == null) {
            TFTPlayerStats.register(player);
        }
    }

    @SubscribeEvent
    public void onItemPickup(EntityItemPickupEvent event) {
        if (!TwilightForestMod.enableTiCIntegration) {
            return;
        }
        Item item = event.item.func_92059_d().func_77973_b();
        EntityPlayer player = event.entityPlayer;
        TFTPlayerStats stats = TFTPlayerStats.get(player);
        if (!(stats.twilightManual || item != TFItems.feather && item != TFItems.nagaScale && item != TFItems.fieryBlood && item != TFItems.fieryTears && item != TFItems.fieryIngot && item != TFItems.steeleafIngot && item != TFItems.armorShard && item != TFItems.shardCluster && item != TFItems.knightMetal)) {
            ItemStack diary = new ItemStack(TFTinkerConstructIntegration.manualBook);
            if (!player.field_71071_by.func_70441_a(diary)) {
                AbilityHelper.spawnItemAtPlayer((EntityPlayer)player, (ItemStack)diary);
            }
            stats.twilightManual = true;
        }
    }

    @SubscribeEvent
    public void onCrafting(PlayerEvent.ItemCraftedEvent event) {
        if (!TwilightForestMod.enableTiCIntegration) {
            return;
        }
        Item item = event.crafting.func_77973_b();
        EntityPlayer player = event.player;
        TFTPlayerStats stats = TFTPlayerStats.get(player);
        if (!(stats.twilightManual || item != TFItems.fieryIngot && item != TFItems.shardCluster && item != TFItems.knightMetal)) {
            ItemStack diary = new ItemStack(TFTinkerConstructIntegration.manualBook);
            if (!player.field_71071_by.func_70441_a(diary)) {
                AbilityHelper.spawnItemAtPlayer((EntityPlayer)player, (ItemStack)diary);
            }
            stats.twilightManual = true;
        }
    }
}

