/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.PriorityQueue;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import vswe.stevesfactory.blocks.ModBlocks;
import vswe.stevesfactory.blocks.TileEntityManager;
import vswe.stevesfactory.blocks.WorldCoordinate;

public class BlockCable
extends Block {
    public BlockCable() {
        super(Material.field_151573_f);
        this.func_149647_a(ModBlocks.creativeTab);
        this.func_149672_a(field_149777_j);
        this.func_149663_c("sfm.BlockCable");
        this.func_149711_c(0.4f);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister register) {
        this.field_149761_L = register.func_94245_a("stevesfactory:cable");
    }

    public void func_149726_b(World world, int x, int y, int z) {
        super.func_149726_b(world, x, y, z);
        this.updateInventories(world, x, y, z);
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        super.func_149695_a(world, x, y, z, block);
        this.updateInventories(world, x, y, z);
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int meta) {
        super.func_149749_a(world, x, y, z, block, meta);
        this.updateInventories(world, x, y, z);
    }

    public void updateInventories(World world, int blockX, int blockY, int blockZ) {
        ArrayList<WorldCoordinate> visited = new ArrayList<WorldCoordinate>();
        PriorityQueue<WorldCoordinate> queue = new PriorityQueue<WorldCoordinate>();
        WorldCoordinate start = new WorldCoordinate(blockX, blockY, blockZ, 0);
        queue.add(start);
        visited.add(start);
        while (!queue.isEmpty()) {
            WorldCoordinate element = (WorldCoordinate)queue.poll();
            for (int x = -1; x <= 1; ++x) {
                for (int y = -1; y <= 1; ++y) {
                    for (int z = -1; z <= 1; ++z) {
                        WorldCoordinate target;
                        if (Math.abs(x) + Math.abs(y) + Math.abs(z) != 1 || visited.contains(target = new WorldCoordinate(element.getX() + x, element.getY() + y, element.getZ() + z, element.getDepth() + 1))) continue;
                        visited.add(target);
                        Block block = world.func_147439_a(target.getX(), target.getY(), target.getZ());
                        int meta = world.func_72805_g(target.getX(), target.getY(), target.getZ());
                        if (block == ModBlocks.blockManager) {
                            TileEntity tileEntity = world.func_147438_o(target.getX(), target.getY(), target.getZ());
                            if (tileEntity == null || !(tileEntity instanceof TileEntityManager)) continue;
                            ((TileEntityManager)tileEntity).updateInventories();
                            continue;
                        }
                        if (!this.isCable(block, meta)) continue;
                        queue.add(target);
                    }
                }
            }
        }
    }

    public boolean isCable(Block block, int meta) {
        return block == ModBlocks.blockCable || block == ModBlocks.blockCableCluster && ModBlocks.blockCableCluster.isAdvanced(meta);
    }
}

