/*
 * Decompiled with CFR 0.152.
 */
package magicbees.item.types;

import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeModifier;
import magicbees.main.utils.LocalizationManager;

public enum HiveFrameType implements IBeeModifier
{
    MAGIC("Magic", 240, 1.0f, 1.0f, 1.0f, 2.0f, 0.6f),
    RESILIENT("Resilient", 800, 1.0f, 1.0f, 1.0f, 2.0f, 0.5f),
    GENTLE("Gentle", 200, 1.0f, 0.7f, 1.5f, 0.4f, 0.01f),
    METABOLIC("Metabolic", 130, 1.0f, 1.8f, 1.0f, 0.2f, 1.0f),
    NECROTIC("Necrotic", 280, 1.0f, 1.0f, 0.3f, -0.25f, 1.2f),
    TEMPORAL("Temporal", 300, 1.0f, 1.0f, 2.5f, 0.0f, 0.8f),
    OBLIVION("Oblivion", 50, 1.0f, 1.0f, 1.0E-4f, -9001.0f, 1.0f);

    private final String frameName;
    public final int maxDamage;
    private final float territoryMod;
    private final float mutationMod;
    private final float lifespanMod;
    private final float productionMod;
    private final float floweringMod;
    private final float geneticDecayMod;
    private final boolean isSealed;
    private final boolean isLit;
    private final boolean isSunlit;
    private final boolean isHellish;

    private HiveFrameType(String name, int damage, float territory, float mutation, float lifespan, float production, float geneticDecay) {
        this(name, damage, territory, mutation, lifespan, production, 1.0f, geneticDecay, false, false, false, false);
    }

    private HiveFrameType(String name, int damage, float territory, float mutation, float lifespan, float production, float flowering, float geneticDecay, boolean sealed, boolean lit, boolean sunlit, boolean hellish) {
        this.frameName = name;
        this.maxDamage = damage;
        this.territoryMod = territory;
        this.mutationMod = mutation;
        this.lifespanMod = lifespan;
        this.productionMod = production;
        this.floweringMod = flowering;
        this.geneticDecayMod = geneticDecay;
        this.isSealed = sealed;
        this.isLit = lit;
        this.isSunlit = sunlit;
        this.isHellish = hellish;
    }

    public String getName() {
        return this.frameName;
    }

    public String getLocalizedName() {
        return LocalizationManager.getLocalizedString("frame." + this.frameName);
    }

    public float getTerritoryModifier(IBeeGenome genome, float currentModifier) {
        return this.territoryMod;
    }

    public float getMutationModifier(IBeeGenome genome, IBeeGenome mate, float currentModifier) {
        return this.mutationMod;
    }

    public float getLifespanModifier(IBeeGenome genome, IBeeGenome mate, float currentModifier) {
        return this.lifespanMod;
    }

    public float getProductionModifier(IBeeGenome genome, float currentModifier) {
        return this.productionMod;
    }

    public float getFloweringModifier(IBeeGenome genome, float currentModifier) {
        return this.floweringMod;
    }

    public float getGeneticDecay(IBeeGenome genome, float currentModifier) {
        return this.geneticDecayMod;
    }

    public boolean isSealed() {
        return this.isSealed;
    }

    public boolean isSelfLighted() {
        return this.isLit;
    }

    public boolean isSunlightSimulated() {
        return this.isSunlit;
    }

    public boolean isHellish() {
        return this.isHellish;
    }
}

