/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.common.storage;

import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import thaumcraft.api.aspects.Aspect;
import thaumicenergistics.common.items.ItemEnum;
import thaumicenergistics.common.registries.ThEStrings;

public enum EnumEssentiaStorageTypes {
    Type_1K(0, 1024L, 12, "1k", EnumRarity.common, 0.5, ThEStrings.Item_EssentiaCell_1k, ThEStrings.Item_StorageComponent_1k),
    Type_4K(1, 4096L, 12, "4k", EnumRarity.uncommon, 1.0, ThEStrings.Item_EssentiaCell_4k, ThEStrings.Item_StorageComponent_4k),
    Type_16K(2, 16384L, 12, "16k", EnumRarity.uncommon, 1.5, ThEStrings.Item_EssentiaCell_16k, ThEStrings.Item_StorageComponent_16k),
    Type_64K(3, 65536L, 12, "64k", EnumRarity.rare, 2.0, ThEStrings.Item_EssentiaCell_64k, ThEStrings.Item_StorageComponent_64k),
    Type_Creative(4, 0L, Aspect.aspects.size(), "creative", EnumRarity.epic, 0.0, ThEStrings.Item_EssentiaCell_Creative, null),
    Type_256K(5, 262144L, 24, "256k", EnumRarity.rare, 2.5, ThEStrings.Item_EssentiaCell_256k, ThEStrings.Item_StorageComponent_256k),
    Type_1024K(6, 0x100000L, 36, "1024k", EnumRarity.rare, 3.0, ThEStrings.Item_EssentiaCell_1024k, ThEStrings.Item_StorageComponent_1024k),
    Type_4096K(7, 0x400000L, 48, "4096k", EnumRarity.epic, 3.5, ThEStrings.Item_EssentiaCell_4096k, ThEStrings.Item_StorageComponent_4096k),
    Type_16384K(8, 0x1000000L, 60, "16384k", EnumRarity.epic, 4.0, ThEStrings.Item_EssentiaCell_16384k, ThEStrings.Item_StorageComponent_16384k),
    Type_QUANTUM(9, 0x7FFFFFFL, 1, "quantum", EnumRarity.epic, 8.0, ThEStrings.Item_EssentiaCell_Quantum, null),
    Type_SINGULARITY(10, 0x1FFFFFFFFFFFFFFFL, 1, "singularity", EnumRarity.epic, 16.0, ThEStrings.Item_EssentiaCell_Singularity, null);

    public static final EnumEssentiaStorageTypes[] fromIndex;
    public final int index;
    public final String suffix;
    public final long capacity;
    public final EnumRarity rarity;
    public final int maxStoredTypes;
    public final double idleAEPowerDrain;
    public final ThEStrings cellName;
    public final ThEStrings componentName;

    private EnumEssentiaStorageTypes(int index, long capacity, int maxStoredTypes, String suffix, EnumRarity rarity, double aeDrain, ThEStrings cellName, ThEStrings componentName) {
        this.index = index;
        this.capacity = capacity;
        this.suffix = suffix;
        this.rarity = rarity;
        this.maxStoredTypes = maxStoredTypes;
        this.idleAEPowerDrain = aeDrain;
        this.cellName = cellName;
        this.componentName = componentName;
    }

    public ItemStack getCell() {
        return ItemEnum.ESSENTIA_CELL.getDMGStack(this.index);
    }

    public ItemStack getComponent(int stackSize) {
        if (this == Type_Creative) {
            return null;
        }
        return ItemEnum.STORAGE_COMPONENT.getDMGStack(this.index, stackSize);
    }

    static {
        fromIndex = new EnumEssentiaStorageTypes[11];
        EnumEssentiaStorageTypes.fromIndex[EnumEssentiaStorageTypes.Type_1K.index] = Type_1K;
        EnumEssentiaStorageTypes.fromIndex[EnumEssentiaStorageTypes.Type_4K.index] = Type_4K;
        EnumEssentiaStorageTypes.fromIndex[EnumEssentiaStorageTypes.Type_16K.index] = Type_16K;
        EnumEssentiaStorageTypes.fromIndex[EnumEssentiaStorageTypes.Type_64K.index] = Type_64K;
        EnumEssentiaStorageTypes.fromIndex[EnumEssentiaStorageTypes.Type_Creative.index] = Type_Creative;
        EnumEssentiaStorageTypes.fromIndex[EnumEssentiaStorageTypes.Type_256K.index] = Type_256K;
        EnumEssentiaStorageTypes.fromIndex[EnumEssentiaStorageTypes.Type_1024K.index] = Type_1024K;
        EnumEssentiaStorageTypes.fromIndex[EnumEssentiaStorageTypes.Type_4096K.index] = Type_4096K;
        EnumEssentiaStorageTypes.fromIndex[EnumEssentiaStorageTypes.Type_16384K.index] = Type_16384K;
        EnumEssentiaStorageTypes.fromIndex[EnumEssentiaStorageTypes.Type_QUANTUM.index] = Type_QUANTUM;
        EnumEssentiaStorageTypes.fromIndex[EnumEssentiaStorageTypes.Type_SINGULARITY.index] = Type_SINGULARITY;
    }
}

