/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.common.fluids;

import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.util.IIcon;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import thaumcraft.api.aspects.Aspect;
import thaumicenergistics.api.IThEEssentiaGas;
import thaumicenergistics.client.textures.BlockTextureManager;
import thaumicenergistics.common.registries.ThEStrings;
import thaumicenergistics.common.utils.ThELog;

public class GaseousEssentia
extends Fluid
implements IThEEssentiaGas {
    public static final LinkedHashMap<Aspect, GaseousEssentia> gasList = new LinkedHashMap();
    private Aspect associatedAspect;

    private GaseousEssentia(String gasName, Aspect aspect) {
        super(gasName);
        this.associatedAspect = aspect;
        this.setLuminosity(7);
        this.setDensity(-4);
        this.setViscosity(3000);
        this.setGaseous(true);
    }

    private static void create(Aspect aspect) {
        if (gasList.containsKey(aspect)) {
            return;
        }
        String gasName = "gaseous" + aspect.getTag() + "essentia";
        GaseousEssentia newGas = new GaseousEssentia(gasName, aspect);
        if (FluidRegistry.registerFluid((Fluid)newGas)) {
            gasList.put(aspect, newGas);
        } else {
            ThELog.warning("Unable to register '%s' as fluid.", aspect.getTag());
        }
    }

    public static GaseousEssentia getGasFromAspect(Aspect aspect) {
        return gasList.get(aspect);
    }

    public static void registerGases() {
        for (Map.Entry aspectType : Aspect.aspects.entrySet()) {
            Aspect aspect = (Aspect)aspectType.getValue();
            GaseousEssentia.create(aspect);
        }
    }

    @Override
    public Aspect getAspect() {
        return this.associatedAspect;
    }

    public int getColor() {
        if (this.associatedAspect != null) {
            return this.associatedAspect.getColor();
        }
        return super.getColor();
    }

    public IIcon getFlowingIcon() {
        return BlockTextureManager.GASEOUS_ESSENTIA.getTexture();
    }

    @Deprecated
    public String getLocalizedName() {
        return this.getLocalizedName(null);
    }

    public String getLocalizedName(FluidStack stack) {
        return this.associatedAspect.getName() + " " + ThEStrings.Fluid_GaseousEssentia.getLocalized();
    }

    public IIcon getStillIcon() {
        return BlockTextureManager.GASEOUS_ESSENTIA.getTexture();
    }
}

