/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.common.features;

import net.minecraft.item.ItemStack;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.research.ResearchPage;
import thaumicenergistics.api.IThEConfig;
import thaumicenergistics.api.ThEApi;
import thaumicenergistics.common.features.CommonDependantItems;
import thaumicenergistics.common.features.ThEThaumcraftResearchFeature;
import thaumicenergistics.common.registries.FeatureRegistry;
import thaumicenergistics.common.registries.RecipeRegistry;
import thaumicenergistics.common.registries.ResearchRegistry;
import thaumicenergistics.fml.ThECore;

public class FeatureGolemBackpack
extends ThEThaumcraftResearchFeature {
    public FeatureGolemBackpack() {
        super(ResearchRegistry.ResearchTypes.GOLEM_BACKPACK.getKey());
    }

    @Override
    protected boolean checkConfigs(IThEConfig theConfig) {
        if (ThECore.golemHooksTransformFailed) {
            return false;
        }
        return theConfig.craftGolemWifiBackpack();
    }

    @Override
    protected Object[] getItemReqs(CommonDependantItems cdi) {
        return new Object[]{cdi.MEInterfacePart, cdi.WirelessReceiver, cdi.FluixCrystal, cdi.MECharger};
    }

    @Override
    protected ThEThaumcraftResearchFeature getParentFeature() {
        return FeatureRegistry.instance().featureConversionCores;
    }

    @Override
    protected void registerCrafting(CommonDependantItems cdi) {
        ItemStack backpack = ThEApi.instance().items().GolemWifiBackpack.getStack();
        AspectList aspects = new AspectList();
        aspects.add(Aspect.AIR, 6);
        aspects.add(Aspect.FIRE, 4);
        aspects.add(Aspect.ORDER, 3);
        Object[] recipe = new Object[]{"TIT", "NWN", "FCF", Character.valueOf('T'), cdi.ThaumiumIngot, Character.valueOf('I'), cdi.MEInterfacePart, Character.valueOf('N'), cdi.Nitor, Character.valueOf('W'), cdi.WirelessReceiver, Character.valueOf('F'), cdi.FluixCrystal, Character.valueOf('C'), cdi.MECharger};
        RecipeRegistry.ITEM_GOLEM_WIFI_BACKPACK = ThaumcraftApi.addArcaneCraftingRecipe((String)this.researchKey, (ItemStack)backpack, (AspectList)aspects, (Object[])recipe);
    }

    @Override
    protected void registerPseudoParents() {
        ResearchRegistry.PseudoResearchTypes.COREGATHER.registerPsudeoResearch();
    }

    @Override
    protected void registerResearch() {
        AspectList aspects = new AspectList();
        aspects.add(Aspect.ENERGY, 5);
        aspects.add(Aspect.AURA, 5);
        aspects.add(Aspect.MIND, 3);
        aspects.add(Aspect.ARMOR, 3);
        aspects.add(Aspect.MOTION, 1);
        aspects.add(Aspect.EXCHANGE, 1);
        ItemStack icon = ThEApi.instance().items().GolemWifiBackpack.getStack();
        ResearchPage[] pages = new ResearchPage[]{new ResearchPage(ResearchRegistry.ResearchTypes.GOLEM_BACKPACK.getPageName(1)), new ResearchPage(RecipeRegistry.ITEM_GOLEM_WIFI_BACKPACK), new ResearchPage(ResearchRegistry.ResearchTypes.GOLEM_BACKPACK.getPageName(2)), new ResearchPage(ResearchRegistry.ResearchTypes.GOLEM_BACKPACK.getPageName(3)), new ResearchPage(ResearchRegistry.ResearchTypes.GOLEM_BACKPACK.getPageName("COREGATHER")), new ResearchPage("COREFILL", ResearchRegistry.ResearchTypes.GOLEM_BACKPACK.getPageName("COREFILL")), new ResearchPage("CORELIQUID", ResearchRegistry.ResearchTypes.GOLEM_BACKPACK.getPageName("CORELIQUID")), new ResearchPage("COREALCHEMY", ResearchRegistry.ResearchTypes.GOLEM_BACKPACK.getPageName("COREALCHEMY")), new ResearchPage("UPGRADEORDER", ResearchRegistry.ResearchTypes.GOLEM_BACKPACK.getPageName("UPGRADEORDER")), new ResearchPage("ADVANCEDGOLEM", ResearchRegistry.ResearchTypes.GOLEM_BACKPACK.getPageName("ADVANCEDGOLEM"))};
        ResearchRegistry.ResearchTypes.GOLEM_BACKPACK.createResearchItem(aspects, 3, icon, pages);
        ResearchRegistry.ResearchTypes.GOLEM_BACKPACK.researchItem.setParents(new String[]{this.getFirstValidParentKey(false), "COREGATHER", ResearchRegistry.PseudoResearchTypes.COREGATHER.getKey()});
        ResearchRegistry.ResearchTypes.GOLEM_BACKPACK.researchItem.setConcealed();
        ResearchRegistry.ResearchTypes.GOLEM_BACKPACK.researchItem.registerResearchItem();
    }
}

