/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.common.container;

import appeng.api.AEApi;
import appeng.api.implementations.guiobjects.IGuiItem;
import appeng.api.implementations.guiobjects.INetworkTool;
import appeng.api.implementations.items.IUpgradeModule;
import appeng.api.util.DimensionalCoord;
import appeng.parts.automation.UpgradeInventory;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import thaumicenergistics.common.container.ContainerWithPlayerInventory;
import thaumicenergistics.common.container.slot.SlotNetworkTool;
import thaumicenergistics.common.container.slot.SlotRestrictive;

public abstract class ContainerWithNetworkTool
extends ContainerWithPlayerInventory {
    private int toolRows;
    private int toolColumns;
    private static final int TOOL_SLOT_X_OFFSET = 187;
    private static final int TOOL_SLOT_Y_OFFSET = 102;
    private static int UPGRADE_Y_POSITION_MULTIPLIER = 18;
    private int firstToolSlotNumber = -1;
    private int lastToolSlotNumber = -1;
    private int firstUpgradeSlot = -1;
    private int lastUpgradeSlot = -1;
    protected boolean hasNetworkTool = false;
    protected boolean isAdvancedNetworkTool = false;

    public ContainerWithNetworkTool(EntityPlayer player) {
        super(player);
    }

    protected void addUpgradeSlots(UpgradeInventory upgradeInventory, int count, int xPosition, int yPosition) {
        SlotRestrictive upgradeSlot = null;
        for (int slotIndex = 0; slotIndex < count; ++slotIndex) {
            upgradeSlot = new SlotRestrictive((IInventory)upgradeInventory, slotIndex, xPosition, yPosition + slotIndex * UPGRADE_Y_POSITION_MULTIPLIER);
            this.func_75146_a(upgradeSlot);
            if (slotIndex != 0) continue;
            this.firstUpgradeSlot = upgradeSlot.field_75222_d;
        }
        if (upgradeSlot != null) {
            this.lastUpgradeSlot = upgradeSlot.field_75222_d;
        }
    }

    protected void removeUpgradeSlots() {
        ArrayList slots = new ArrayList();
        for (int slotIndex = this.firstUpgradeSlot; slotIndex <= this.lastUpgradeSlot; ++slotIndex) {
            slots.add(this.field_75151_b.get(slotIndex));
            this.removeSlot(slotIndex);
        }
        for (Object slot : slots) {
            this.field_75151_b.remove(slot);
        }
    }

    protected boolean haveUpgradeSlots() {
        for (Object inventorySlot : this.field_75151_b) {
            Slot slot = (Slot)inventorySlot;
            if (!(slot.field_75224_c instanceof UpgradeInventory)) continue;
            return true;
        }
        return false;
    }

    protected void bindToNetworkTool(InventoryPlayer playerInventory, DimensionalCoord partLocation, int slotOffsetX, int slotOffsetY) {
        ItemStack nwTool = (ItemStack)AEApi.instance().definitions().items().networkTool().maybeStack(1).orNull();
        if (nwTool == null) {
            nwTool = (ItemStack)AEApi.instance().definitions().items().advancedNetworkTool().maybeStack(1).orNull();
        }
        if (nwTool != null) {
            for (int slotIndex = 0; slotIndex < playerInventory.func_70302_i_(); ++slotIndex) {
                ItemStack stack = playerInventory.func_70301_a(slotIndex);
                if (stack == null) continue;
                if (stack.func_77969_a((ItemStack)AEApi.instance().definitions().items().networkTool().maybeStack(1).get())) {
                    this.toolRows = 3;
                    this.toolColumns = 3;
                } else {
                    if (!stack.func_77969_a((ItemStack)AEApi.instance().definitions().items().advancedNetworkTool().maybeStack(1).get())) continue;
                    this.toolRows = 5;
                    this.toolColumns = 5;
                    this.isAdvancedNetworkTool = true;
                }
                IGuiItem guiItem = (IGuiItem)stack.func_77973_b();
                INetworkTool networkTool = (INetworkTool)guiItem.getGuiObject(stack, partLocation.getWorld(), partLocation.x, partLocation.y, partLocation.z);
                SlotNetworkTool toolSlot = null;
                for (int column = 0; column < this.toolColumns; ++column) {
                    for (int row = 0; row < this.toolRows; ++row) {
                        int slotToolIndex = column + row * this.toolColumns;
                        toolSlot = new SlotNetworkTool(networkTool, slotToolIndex, 187 + slotOffsetX + column * 18, row * 18 + 102 + slotOffsetY);
                        this.func_75146_a(toolSlot);
                        if (slotToolIndex != 0) continue;
                        this.firstToolSlotNumber = toolSlot.field_75222_d;
                    }
                }
                if (toolSlot != null) {
                    this.lastToolSlotNumber = toolSlot.field_75222_d;
                }
                this.hasNetworkTool = true;
                return;
            }
        }
    }

    protected boolean mergeSlotWithNetworkTool(ItemStack slotStack) {
        if (this.hasNetworkTool) {
            if (!(slotStack.func_77973_b() instanceof IUpgradeModule)) {
                return false;
            }
            return this.func_75135_a(slotStack, this.firstToolSlotNumber, this.lastToolSlotNumber + 1, false);
        }
        return false;
    }

    protected boolean mergeSlotWithUpgrades(ItemStack slotStack) {
        if (!(slotStack.func_77973_b() instanceof IUpgradeModule)) {
            return false;
        }
        boolean didMerge = false;
        for (int index = this.firstUpgradeSlot; index <= this.lastUpgradeSlot; ++index) {
            Slot upgradeSlot = (Slot)this.field_75151_b.get(index);
            if (upgradeSlot == null || upgradeSlot.func_75216_d() || !upgradeSlot.func_75214_a(slotStack)) continue;
            ItemStack upgradeStack = slotStack.func_77946_l();
            upgradeStack.field_77994_a = 1;
            upgradeSlot.func_75215_d(upgradeStack);
            --slotStack.field_77994_a;
            didMerge = true;
            if (slotStack.field_77994_a == 0) break;
        }
        return didMerge;
    }

    protected boolean slotClickedWasInNetworkTool(int slotNumber) {
        return this.hasNetworkTool && slotNumber >= this.firstToolSlotNumber && slotNumber <= this.lastToolSlotNumber;
    }

    protected boolean slotClickedWasInUpgrades(int slotNumber) {
        return slotNumber >= this.firstUpgradeSlot && slotNumber <= this.lastUpgradeSlot;
    }

    public boolean hasNetworkTool() {
        return this.hasNetworkTool;
    }

    public boolean isAdvancedNetworkTool() {
        return this.isAdvancedNetworkTool;
    }

    public ItemStack func_82846_b(EntityPlayer player, int slotNumber) {
        Slot slot = this.getSlotOrNull(slotNumber);
        boolean didMerge = false;
        if (slot != null && slot.func_75216_d()) {
            ItemStack slotStack = slot.func_75211_c();
            if (this.slotClickedWasInPlayerInventory(slotNumber) || this.slotClickedWasInHotbarInventory(slotNumber)) {
                didMerge = this.mergeSlotWithUpgrades(slotStack);
                if (!didMerge) {
                    didMerge = this.mergeSlotWithNetworkTool(slotStack);
                }
                if (!didMerge) {
                    didMerge = this.swapSlotInventoryHotbar(slotNumber, slotStack);
                }
            } else if (this.slotClickedWasInUpgrades(slotNumber)) {
                didMerge = this.mergeSlotWithNetworkTool(slotStack);
                if (!didMerge) {
                    didMerge = this.mergeSlotWithPlayerInventory(slotStack);
                }
            } else if (this.hasNetworkTool && this.slotClickedWasInNetworkTool(slotNumber) && !(didMerge = this.mergeSlotWithUpgrades(slotStack))) {
                didMerge = this.mergeSlotWithPlayerInventory(slotStack);
            }
            if (!didMerge) {
                return null;
            }
            if (slotStack.field_77994_a == 0) {
                slot.func_75215_d(null);
            }
            slot.func_75218_e();
            this.func_75142_b();
        }
        return null;
    }
}

