/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.client.gui;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;
import thaumcraft.api.aspects.Aspect;
import thaumicenergistics.api.gui.IAspectSlotGui;
import thaumicenergistics.client.gui.abstraction.ThEBaseGui;
import thaumicenergistics.client.gui.buttons.GuiButtonClearCellPartitioning;
import thaumicenergistics.client.gui.buttons.GuiButtonSetCellPartitioningToCurrent;
import thaumicenergistics.client.gui.widget.AspectWidgetBase;
import thaumicenergistics.client.gui.widget.WidgetAspectSlot;
import thaumicenergistics.client.textures.AEStateIconsEnum;
import thaumicenergistics.client.textures.GuiTextureManager;
import thaumicenergistics.common.container.ContainerEssentiaCellWorkbench;
import thaumicenergistics.common.integration.tc.EssentiaItemContainerHelper;
import thaumicenergistics.common.network.packet.server.Packet_S_EssentiaCellWorkbench;
import thaumicenergistics.common.registries.ThEStrings;
import thaumicenergistics.common.tiles.TileEssentiaCellWorkbench;

@SideOnly(value=Side.CLIENT)
public class GuiEssentiaCellWorkbench
extends ThEBaseGui
implements IAspectSlotGui {
    private static final int GUI_WIDTH = 212;
    private static final int GUI_HEIGHT = 251;
    private static final int TITLE_POS_X = 6;
    private static final int TITLE_POS_Y = 6;
    private static final int WIDGET_POS_X = 7;
    private static final int WIDGET_POS_Y = 28;
    private static final int WIDGETS_PER_ROW = 9;
    private static final int WIDGET_ROWS = 7;
    private static final int NUMBER_OF_WIDGETS = 63;
    private static final AEStateIconsEnum CELL_BG_ICON = AEStateIconsEnum.ME_CELL_BACKGROUND;
    private static final int BUTTON_PARTITION_CURRENT_ID = 0;
    private static final int BUTTON_PARTITION_CURRENT_X = -18;
    private static final int BUTTON_PARTITION_CURRENT_Y = 28;
    private static final int BUTTON_CLEAR_ID = 1;
    private static final int BUTTON_CLEAR_X = -18;
    private static final int BUTTON_CLEAR_Y = 8;
    private final EntityPlayer player;
    private final String title;
    private final SimpleAspectWidget[] partitionWidgets;
    public final TileEssentiaCellWorkbench workbench;

    public GuiEssentiaCellWorkbench(EntityPlayer player, World world, int x, int y, int z) {
        super(new ContainerEssentiaCellWorkbench(player, world, x, y, z));
        this.player = player;
        this.field_146999_f = 212;
        this.field_147000_g = 251;
        this.title = ThEStrings.Gui_TitleEssentiaCellWorkbench.getLocalized();
        this.partitionWidgets = new SimpleAspectWidget[63];
        this.workbench = ((ContainerEssentiaCellWorkbench)this.field_147002_h).workbench;
    }

    protected void func_146976_a(float alpha, int mouseX, int mouseY) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(GuiTextureManager.CELL_WORKBENCH.getTexture());
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, 176, this.field_147000_g);
        if (this.workbench.hasEssentiaCell()) {
            this.func_73729_b(this.field_147003_i + 177, this.field_147009_r, 177, 0, 35, 97);
            this.func_73729_b(this.field_147003_i + 177, this.field_147009_r + 97, 177, 151, 35, 7);
            super.drawAEToolAndUpgradeSlots(alpha, mouseX, mouseY);
        }
        Minecraft.func_71410_x().field_71446_o.func_110577_a(AEStateIconsEnum.AE_STATES_TEXTURE);
        this.func_73729_b(this.field_147003_i + ContainerEssentiaCellWorkbench.CELL_SLOT_X, this.field_147009_r + ContainerEssentiaCellWorkbench.CELL_SLOT_Y, CELL_BG_ICON.getU(), CELL_BG_ICON.getV(), CELL_BG_ICON.getWidth(), CELL_BG_ICON.getHeight());
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(this.title, 6, 6, 0);
        AspectWidgetBase widgetUnderMouse = null;
        for (int index = 0; index < 63; ++index) {
            SimpleAspectWidget currentWidget = this.partitionWidgets[index];
            currentWidget.drawWidget();
            if (widgetUnderMouse != null || !currentWidget.isMouseOverWidget(mouseX, mouseY)) continue;
            widgetUnderMouse = currentWidget;
        }
        if (widgetUnderMouse != null) {
            widgetUnderMouse.getTooltip(this.tooltip);
        }
    }

    @Override
    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        for (SimpleAspectWidget partitionWidget : this.partitionWidgets) {
            if (!partitionWidget.isMouseOverWidget(mouseX, mouseY)) continue;
            Aspect itemAspect = EssentiaItemContainerHelper.INSTANCE.getFilterAspectFromItem(this.field_147012_x == null ? this.player.field_71071_by.func_70445_o() : this.field_147012_x.func_77946_l());
            Aspect widgetAspect = partitionWidget.getAspect();
            if (widgetAspect == null && itemAspect != null) {
                Packet_S_EssentiaCellWorkbench.sendAddAspect(this.player, this.workbench, itemAspect);
                break;
            }
            if (widgetAspect != null && itemAspect == null) {
                Packet_S_EssentiaCellWorkbench.sendRemoveAspect(this.player, this.workbench, widgetAspect);
                break;
            }
            if (widgetAspect == null || itemAspect == null) break;
            Packet_S_EssentiaCellWorkbench.sendReplaceAspect(this.player, this.workbench, widgetAspect, itemAspect);
            break;
        }
        this.field_147012_x = null;
    }

    @Override
    protected void onButtonClicked(GuiButton button, int mouseButton) {
        switch (button.field_146127_k) {
            case 1: {
                Packet_S_EssentiaCellWorkbench.sendClearPartitioning(this.player, this.workbench);
                break;
            }
            case 0: {
                Packet_S_EssentiaCellWorkbench.sendPartitionToContents(this.player, this.workbench);
            }
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        for (int y = 0; y < 7; ++y) {
            int rowYPosition = 28 + y * 18;
            for (int x = 0; x < 9; ++x) {
                int wPosX = 7 + x * 18;
                int wIndex = x + y * 9;
                this.partitionWidgets[wIndex] = new SimpleAspectWidget(wIndex, wPosX, rowYPosition, this.player);
            }
        }
        this.field_146292_n.add(new GuiButtonSetCellPartitioningToCurrent(0, this.field_147003_i + -18, this.field_147009_r + 28));
        this.field_146292_n.add(new GuiButtonClearCellPartitioning(1, this.field_147003_i + -18, this.field_147009_r + 8));
        Packet_S_EssentiaCellWorkbench.sendGetPartitionList(this.player, this.workbench);
    }

    @Override
    public void updateAspects(List<Aspect> aspectList) {
        int index;
        int count = aspectList.size();
        for (index = 0; index < count; ++index) {
            this.partitionWidgets[index].setAspect(aspectList.get(index), 1L, false);
        }
        for (index = count; index < 63; ++index) {
            this.partitionWidgets[index].setAspect(null);
        }
    }

    private class SimpleAspectWidget
    extends WidgetAspectSlot {
        public SimpleAspectWidget(int ID, int posX, int posY, EntityPlayer player) {
            super(GuiEssentiaCellWorkbench.this, player, null, ID, posX, posY);
        }

        @Override
        public void mouseClicked(Aspect withAspect) {
        }
    }
}

