/*
 * Decompiled with CFR 0.152.
 */
package craftpresence.external.me.hypherionmc.moonconfig.core.fields;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.Random;

public class RandomArrayList<E>
extends ArrayList<E> {
    private Optional<E> lastValue = Optional.empty();

    public RandomArrayList(int initialCapacity) {
        super(initialCapacity);
    }

    public RandomArrayList() {
    }

    public RandomArrayList(Collection<? extends E> c) {
        super(c);
    }

    public Optional<E> getNextRandom() {
        if (!this.lastValue.isPresent()) {
            this.lastValue = Optional.ofNullable(this.getRandomValue());
        }
        if (new Random().nextInt(10) == 2) {
            this.lastValue = Optional.ofNullable(this.getRandomValue());
        }
        return this.lastValue;
    }

    private E getRandomValue() {
        if (!this.isEmpty()) {
            return this.get(new Random().nextInt(this.size()));
        }
        return null;
    }

    @SafeVarargs
    public static <T> RandomArrayList<T> of(T ... o) {
        RandomArrayList<T> l = new RandomArrayList<T>();
        l.addAll(Arrays.asList(o));
        return l;
    }
}

