/*
 * Decompiled with CFR 0.152.
 */
package com.pam.harvestcraft.base;

import com.pam.harvestcraft.BlockRegistry;
import com.pam.harvestcraft.HarvestCraft;
import com.pam.harvestcraft.ItemRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFlower;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockGarden
extends BlockFlower {
    protected BlockGarden(int par2) {
        super(par2);
        float f = 0.4f;
        this.func_149676_a(0.5f - f, 0.0f, 0.5f - f, 0.5f + f, f * 2.0f, 0.5f + f);
        this.func_149672_a(Block.field_149779_h);
        this.func_149675_a(true);
        this.func_149647_a(HarvestCraft.tabHarvestCraft2);
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int facing, float xOffset, float yOffset, float zOffset) {
        int meta;
        if (!world.field_72995_K && (meta = world.func_72805_g(x, y, z)) == 0) {
            this.func_149642_a(world, x, y, z, new ItemStack((Block)this, 1, 0));
            world.func_147468_f(x, y, z);
        }
        return true;
    }

    public Item func_149650_a(int meta, Random rand, int fortune) {
        List<Item> dropList = BlockGarden.getDropList((Block)this);
        int i = rand.nextInt(dropList.size());
        return dropList.get(i);
    }

    public int func_149745_a(Random random) {
        return BlockRegistry.gardendropAmount;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int par1, int par2) {
        return this.field_149761_L;
    }

    public Block getPlant(IBlockAccess world, int x, int y, int z) {
        return this;
    }

    public int getPlantMetadata(IBlockAccess world, int x, int y, int z) {
        return world.func_72805_g(x, y, z);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item itemIn, CreativeTabs tab, List<ItemStack> list) {
        for (int i = 0; i < 1; ++i) {
            list.add(new ItemStack(itemIn, 1, i));
        }
    }

    public void func_149674_a(World worldIn, int x, int y, int z, Random rand) {
        if (BlockRegistry.enablegardenSpread && rand.nextInt(BlockRegistry.gardenspreadRate) == 0) {
            int nextY;
            int nextZ;
            int nextX;
            int bound = 4;
            int limit = BlockRegistry.gardenSpreadLimit;
            int meta = this.func_149643_k(worldIn, x, y, z);
            for (nextX = x - bound; nextX <= x + bound; ++nextX) {
                for (nextZ = z - bound; nextZ <= z + bound; ++nextZ) {
                    for (nextY = y - 1; nextY <= y + 1; ++nextY) {
                        if (worldIn.func_72899_e(nextX, nextY, nextZ) && worldIn.func_147439_a(nextX, nextY, nextZ) != this || --limit > 0) continue;
                        return;
                    }
                }
            }
            nextX = x + rand.nextInt(3) - 1;
            nextY = y + rand.nextInt(2) - rand.nextInt(2);
            nextZ = z + rand.nextInt(3) - 1;
            for (int l1 = 0; l1 < 4; ++l1) {
                if (worldIn.func_72899_e(nextX, nextY, nextZ) && worldIn.func_147437_c(nextX, nextY, nextZ) && this.func_149718_j(worldIn, nextX, nextY, nextZ)) {
                    x = nextX;
                    y = nextY;
                    z = nextZ;
                }
                nextX = x + rand.nextInt(3) - 1;
                nextY = y + rand.nextInt(2) - rand.nextInt(2);
                nextZ = z + rand.nextInt(3) - 1;
            }
            if (worldIn.func_72899_e(nextX, nextY, nextZ) && worldIn.func_147437_c(nextX, nextY, nextZ) && this.func_149718_j(worldIn, nextX, nextY, nextZ)) {
                worldIn.func_147465_d(nextX, nextY, nextZ, (Block)this, meta, 2);
            }
        }
    }

    public static List<Item> getDropList(Block block) {
        if (block.equals(BlockRegistry.pamberryGarden)) {
            if (BlockRegistry.gardensdropSeeds) {
                return Arrays.asList(ItemRegistry.blackberryseedItem, ItemRegistry.blueberryseedItem, ItemRegistry.candleberryseedItem, ItemRegistry.raspberryseedItem, ItemRegistry.strawberryseedItem, ItemRegistry.grapeseedItem);
            }
            return Arrays.asList(ItemRegistry.blackberryItem, ItemRegistry.blueberryItem, ItemRegistry.candleberryItem, ItemRegistry.raspberryItem, ItemRegistry.strawberryItem, ItemRegistry.grapeItem);
        }
        if (block.equals(BlockRegistry.pamdesertGarden)) {
            if (BlockRegistry.gardensdropSeeds) {
                return Collections.singletonList(ItemRegistry.cactusfruitseedItem);
            }
            return Arrays.asList(ItemRegistry.cactusfruitItem, Item.func_150898_a((Block)Blocks.field_150434_aF));
        }
        if (block.equals(BlockRegistry.pamgrassGarden)) {
            if (BlockRegistry.gardensdropSeeds) {
                return Arrays.asList(ItemRegistry.asparagusseedItem, ItemRegistry.barleyseedItem, ItemRegistry.oatsseedItem, ItemRegistry.ryeseedItem, ItemRegistry.cornseedItem, ItemRegistry.bambooshootseedItem);
            }
            return Arrays.asList(ItemRegistry.asparagusItem, ItemRegistry.barleyItem, ItemRegistry.oatsItem, ItemRegistry.ryeItem, ItemRegistry.cornItem, ItemRegistry.bambooshootItem);
        }
        if (block.equals(BlockRegistry.pamgourdGarden)) {
            if (BlockRegistry.gardensdropSeeds) {
                return Arrays.asList(ItemRegistry.cantaloupeseedItem, ItemRegistry.cucumberseedItem, ItemRegistry.wintersquashseedItem, ItemRegistry.zucchiniseedItem, Items.field_151080_bb);
            }
            return Arrays.asList(ItemRegistry.cantaloupeItem, ItemRegistry.cucumberItem, ItemRegistry.wintersquashItem, ItemRegistry.zucchiniItem, Item.func_150898_a((Block)Blocks.field_150423_aK));
        }
        if (block.equals(BlockRegistry.pamgroundGarden)) {
            if (BlockRegistry.gardensdropSeeds) {
                return Arrays.asList(ItemRegistry.beetseedItem, ItemRegistry.onionseedItem, ItemRegistry.parsnipseedItem, ItemRegistry.peanutseedItem, ItemRegistry.radishseedItem, ItemRegistry.rutabagaseedItem, ItemRegistry.sweetpotatoseedItem, ItemRegistry.turnipseedItem, ItemRegistry.rhubarbseedItem);
            }
            return Arrays.asList(ItemRegistry.beetItem, ItemRegistry.onionItem, ItemRegistry.parsnipItem, ItemRegistry.peanutItem, ItemRegistry.radishItem, ItemRegistry.rutabagaItem, ItemRegistry.sweetpotatoItem, ItemRegistry.turnipItem, ItemRegistry.rhubarbItem, Items.field_151174_bG, Items.field_151172_bF);
        }
        if (block.equals(BlockRegistry.pamherbGarden)) {
            if (BlockRegistry.gardensdropSeeds) {
                return Arrays.asList(ItemRegistry.celeryseedItem, ItemRegistry.garlicseedItem, ItemRegistry.gingerseedItem, ItemRegistry.spiceleafseedItem, ItemRegistry.teaseedItem, ItemRegistry.coffeeseedItem, ItemRegistry.mustardseedItem);
            }
            return Arrays.asList(ItemRegistry.celeryItem, ItemRegistry.garlicItem, ItemRegistry.gingerItem, ItemRegistry.spiceleafItem, ItemRegistry.ediblerootItem, ItemRegistry.tealeafItem, ItemRegistry.coffeebeanItem, ItemRegistry.mustardseedsItem);
        }
        if (block.equals(BlockRegistry.pamleafyGarden)) {
            if (BlockRegistry.gardensdropSeeds) {
                return Arrays.asList(ItemRegistry.broccoliseedItem, ItemRegistry.cauliflowerseedItem, ItemRegistry.leekseedItem, ItemRegistry.lettuceseedItem, ItemRegistry.scallionseedItem, ItemRegistry.artichokeseedItem, ItemRegistry.brusselsproutseedItem, ItemRegistry.cabbageseedItem, ItemRegistry.spinachseedItem);
            }
            return Arrays.asList(ItemRegistry.broccoliItem, ItemRegistry.cauliflowerItem, ItemRegistry.leekItem, ItemRegistry.lettuceItem, ItemRegistry.scallionItem, ItemRegistry.artichokeItem, ItemRegistry.brusselsproutItem, ItemRegistry.cabbageItem, ItemRegistry.spinachItem);
        }
        if (block.equals(BlockRegistry.pammushroomGarden)) {
            if (BlockRegistry.gardensdropSeeds) {
                return Collections.singletonList(ItemRegistry.whitemushroomseedItem);
            }
            return Arrays.asList(Item.func_150898_a((Block)Blocks.field_150338_P), Item.func_150898_a((Block)Blocks.field_150337_Q), ItemRegistry.whitemushroomItem);
        }
        if (block.equals(BlockRegistry.pamstalkGarden)) {
            if (BlockRegistry.gardensdropSeeds) {
                return Arrays.asList(ItemRegistry.beanseedItem, ItemRegistry.soybeanseedItem, ItemRegistry.bellpepperseedItem, ItemRegistry.chilipepperseedItem, ItemRegistry.eggplantseedItem, ItemRegistry.okraseedItem, ItemRegistry.peasseedItem, ItemRegistry.tomatoseedItem);
            }
            return Arrays.asList(ItemRegistry.beanItem, ItemRegistry.soybeanItem, ItemRegistry.bellpepperItem, ItemRegistry.chilipepperItem, ItemRegistry.eggplantItem, ItemRegistry.okraItem, ItemRegistry.peasItem, ItemRegistry.tomatoItem);
        }
        if (block.equals(BlockRegistry.pamtextileGarden)) {
            if (BlockRegistry.gardensdropSeeds) {
                return Collections.singletonList(ItemRegistry.cottonseedItem);
            }
            return Collections.singletonList(ItemRegistry.cottonItem);
        }
        if (block.equals(BlockRegistry.pamtropicalGarden)) {
            if (BlockRegistry.gardensdropSeeds) {
                return Arrays.asList(ItemRegistry.pineappleseedItem, ItemRegistry.kiwiseedItem, Items.field_151081_bc, ItemRegistry.curryleafseedItem, ItemRegistry.sesameseedsseedItem);
            }
            return Arrays.asList(ItemRegistry.pineappleItem, ItemRegistry.kiwiItem, Items.field_151127_ba, ItemRegistry.curryleafItem, ItemRegistry.sesameseedsItem);
        }
        if (block.equals(BlockRegistry.pamwaterGarden)) {
            if (BlockRegistry.gardensdropSeeds && !BlockRegistry.enablecropspecialplanting) {
                return Arrays.asList(ItemRegistry.cranberryseedItem, ItemRegistry.riceseedItem, ItemRegistry.seaweedseedItem, ItemRegistry.clamrawItem, ItemRegistry.crabrawItem, ItemRegistry.crayfishrawItem, ItemRegistry.frograwItem, ItemRegistry.scalloprawItem, ItemRegistry.shrimprawItem, ItemRegistry.turtlerawItem, ItemRegistry.waterchestnutseedItem, ItemRegistry.snailrawItem, ItemRegistry.greenheartfishItem);
            }
            return Arrays.asList(ItemRegistry.cranberryItem, ItemRegistry.riceItem, ItemRegistry.seaweedItem, ItemRegistry.clamrawItem, ItemRegistry.crabrawItem, ItemRegistry.crayfishrawItem, ItemRegistry.frograwItem, ItemRegistry.scalloprawItem, ItemRegistry.shrimprawItem, ItemRegistry.turtlerawItem, ItemRegistry.waterchestnutItem, ItemRegistry.snailrawItem, ItemRegistry.greenheartfishItem);
        }
        if (block.equals(GameRegistry.findBlock((String)"harvestthenether", (String)"netherGarden"))) {
            if (BlockRegistry.gardensdropSeeds) {
                return Arrays.asList(GameRegistry.findItem((String)"harvestthenether", (String)"bloodleafseedItem"), GameRegistry.findItem((String)"harvestthenether", (String)"fleshrootseedItem"), GameRegistry.findItem((String)"harvestthenether", (String)"marrowberryseedItem"));
            }
            return Arrays.asList(GameRegistry.findItem((String)"harvestthenether", (String)"bloodleafItem"), GameRegistry.findItem((String)"harvestthenether", (String)"fleshrootItem"), GameRegistry.findItem((String)"harvestthenether", (String)"marrowberryItem"));
        }
        return Collections.emptyList();
    }
}

