/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.item;

import baubles.api.BaubleType;
import baubles.api.IBauble;
import cofh.api.energy.ItemEnergyContainer;
import com.enderio.core.api.client.gui.IResourceTooltipProvider;
import com.enderio.core.common.util.ItemUtil;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.EnderIOTab;
import crazypants.enderio.ModObject;
import crazypants.enderio.config.Config;
import crazypants.enderio.item.MagnetController;
import crazypants.enderio.item.darksteel.DarkSteelItems;
import crazypants.enderio.power.PowerDisplayUtil;
import crazypants.util.BaublesUtil;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

@Optional.Interface(iface="baubles.api.IBauble", modid="Baubles|API")
public class ItemMagnet
extends ItemEnergyContainer
implements IResourceTooltipProvider,
IBauble {
    private static final String ACTIVE_KEY = "magnetActive";
    static MagnetController controller = new MagnetController();

    public static void setActive(ItemStack item, boolean active) {
        if (item == null) {
            return;
        }
        NBTTagCompound nbt = ItemUtil.getOrCreateNBT((ItemStack)item);
        nbt.func_74757_a(ACTIVE_KEY, active);
    }

    public static boolean isActive(ItemStack item) {
        if (item == null) {
            return false;
        }
        if (item.field_77990_d == null) {
            return false;
        }
        if (!item.field_77990_d.func_74764_b(ACTIVE_KEY)) {
            return false;
        }
        return item.field_77990_d.func_74767_n(ACTIVE_KEY);
    }

    public static boolean hasPower(ItemStack itemStack) {
        int energyStored = DarkSteelItems.itemMagnet.getEnergyStored(itemStack);
        return energyStored > 0 && energyStored >= Config.magnetPowerUsePerSecondRF;
    }

    public static void drainPerSecondPower(ItemStack itemStack) {
        DarkSteelItems.itemMagnet.extractEnergyInternal(itemStack, Config.magnetPowerUsePerSecondRF, false);
    }

    public static ItemMagnet create() {
        ItemMagnet result = new ItemMagnet();
        result.init();
        FMLCommonHandler.instance().bus().register((Object)controller);
        return result;
    }

    protected ItemMagnet() {
        super(Config.magnetPowerCapacityRF, Config.magnetPowerCapacityRF / 100);
        this.func_77637_a(EnderIOTab.tabEnderIO);
        this.func_77655_b(ModObject.itemMagnet.unlocalisedName);
        this.func_77656_e(16);
        this.func_77625_d(1);
        this.func_77627_a(true);
    }

    protected void init() {
        GameRegistry.registerItem((Item)this, (String)ModObject.itemMagnet.unlocalisedName);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister IIconRegister2) {
        this.field_77791_bV = IIconRegister2.func_94245_a("enderio:magnet");
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs par2CreativeTabs, List<ItemStack> par3List) {
        ItemStack is = new ItemStack((Item)this);
        this.setFull(is);
        par3List.add(is);
        is = new ItemStack((Item)this);
        this.setEnergy(is, 0);
        par3List.add(is);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, EntityPlayer par2EntityPlayer, List<String> list, boolean par4) {
        super.func_77624_a(itemStack, par2EntityPlayer, list, par4);
        String str = PowerDisplayUtil.formatPower(this.getEnergyStored(itemStack)) + "/" + PowerDisplayUtil.formatPower(this.getMaxEnergyStored(itemStack)) + " " + PowerDisplayUtil.abrevation();
        list.add(str);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean hasEffect(ItemStack item, int pass) {
        return ItemMagnet.isActive(item);
    }

    public void func_77622_d(ItemStack itemStack, World world, EntityPlayer entityPlayer) {
        this.setEnergy(itemStack, 0);
    }

    public int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        if (maxReceive < 0) {
            return 0;
        }
        int res = super.receiveEnergy(container, maxReceive, simulate);
        if (res != 0 && !simulate) {
            this.updateDamage(container);
        }
        return res;
    }

    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        if (Config.magnetAllowPowerExtraction) {
            return this.extractEnergyInternal(container, maxExtract, simulate);
        }
        return 0;
    }

    public int extractEnergyInternal(ItemStack container, int maxExtract, boolean simulate) {
        if (maxExtract < 0) {
            return 0;
        }
        int res = super.extractEnergy(container, maxExtract, simulate);
        if (res != 0 && !simulate) {
            this.updateDamage(container);
        }
        return res;
    }

    void setEnergy(ItemStack container, int energy) {
        if (container.field_77990_d == null) {
            container.field_77990_d = new NBTTagCompound();
        }
        container.field_77990_d.func_74768_a("Energy", energy);
        this.updateDamage(container);
    }

    void setFull(ItemStack container) {
        this.setEnergy(container, Config.magnetPowerCapacityRF);
    }

    private void updateDamage(ItemStack stack) {
        float r = (float)this.getEnergyStored(stack) / (float)this.getMaxEnergyStored(stack);
        int res = 16 - (int)(r * 16.0f);
        stack.func_77964_b(res);
    }

    public ItemStack func_77659_a(ItemStack equipped, World world, EntityPlayer player) {
        if (player.func_70093_af()) {
            ItemMagnet.setActive(equipped, !ItemMagnet.isActive(equipped));
        }
        return equipped;
    }

    public String getUnlocalizedNameForTooltip(ItemStack stack) {
        return this.func_77658_a();
    }

    @Optional.Method(modid="Baubles|API")
    public BaubleType getBaubleType(ItemStack itemstack) {
        BaubleType t = null;
        try {
            t = BaubleType.valueOf((String)Config.magnetBaublesType);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return t != null ? t : BaubleType.AMULET;
    }

    @Optional.Method(modid="Baubles|API")
    public void onWornTick(ItemStack itemstack, EntityLivingBase player) {
        if (player instanceof EntityPlayer && ItemMagnet.isActive(itemstack) && ItemMagnet.hasPower(itemstack) && ((EntityPlayer)player).func_110143_aJ() > 0.0f) {
            controller.doHoover((EntityPlayer)player);
            if (!player.field_70170_p.field_72995_K && player.field_70170_p.func_82737_E() % 20L == 0L) {
                ItemMagnet.drainPerSecondPower(itemstack);
                IInventory baubles = BaublesUtil.instance().getBaubles((EntityPlayer)player);
                if (baubles != null) {
                    baubles.func_70296_d();
                }
            }
        }
    }

    @Optional.Method(modid="Baubles|API")
    public void onEquipped(ItemStack itemstack, EntityLivingBase player) {
    }

    @Optional.Method(modid="Baubles|API")
    public void onUnequipped(ItemStack itemstack, EntityLivingBase player) {
    }

    @Optional.Method(modid="Baubles|API")
    public boolean canEquip(ItemStack itemstack, EntityLivingBase player) {
        return Config.magnetAllowInBaublesSlot && (Config.magnetAllowDeactivatedInBaublesSlot || ItemMagnet.isActive(itemstack));
    }

    @Optional.Method(modid="Baubles|API")
    public boolean canUnequip(ItemStack itemstack, EntityLivingBase player) {
        return true;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return Config.renderDurabilityBar && super.showDurabilityBar(stack);
    }
}

