/*
 * Decompiled with CFR 0.152.
 */
package glowredman.amazingtrophies.condition;

import com.google.gson.JsonObject;
import com.gtnewhorizon.gtnhlib.util.map.ItemStackMap;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import glowredman.amazingtrophies.ConfigHandler;
import glowredman.amazingtrophies.api.ConditionHandler;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StringUtils;
import net.minecraftforge.event.entity.item.ItemTossEvent;

public abstract class ItemConditionHandler
extends ConditionHandler {
    public static final String PROPERTY_ITEM = "item";
    public static final String PROPERTY_META = "meta";
    public static final String PROPERTY_NBT = "nbt";
    protected static final int MASK_WILDCARD = 1;
    protected static final int MASK_NBT = 2;
    protected final Map<Integer, Map<ItemStack, Set<String>>> conditions = new HashMap<Integer, Map<ItemStack, Set<String>>>();

    public ItemConditionHandler() {
        this.conditions.put(0, (Map<ItemStack, Set<String>>)new ItemStackMap(false));
        this.conditions.put(1, (Map<ItemStack, Set<String>>)new ItemStackMap(false));
        this.conditions.put(2, (Map<ItemStack, Set<String>>)new ItemStackMap(true));
        this.conditions.put(3, (Map<ItemStack, Set<String>>)new ItemStackMap(true));
    }

    @Override
    public void parse(String id, JsonObject json) {
        String registryName = ConfigHandler.getStringProperty(json, PROPERTY_ITEM);
        int meta = ConfigHandler.getIntegerProperty(json, PROPERTY_META, Short.MAX_VALUE);
        if (meta < 0 || meta > Short.MAX_VALUE) {
            throw new IllegalArgumentException("Illegal meta value (" + meta + ")!");
        }
        String nbt = ConfigHandler.getStringProperty(json, PROPERTY_NBT, null);
        ItemStack stack = GameRegistry.makeItemStack((String)registryName, (int)meta, (int)0, (String)nbt);
        if (stack == null) {
            throw new IllegalArgumentException("Could not find item " + registryName + "!");
        }
        Map<ItemStack, Set<String>> map = this.getMap(meta, nbt);
        Set<String> ids = map.get(stack);
        if (ids == null) {
            ids = new HashSet<String>();
            ids.add(id);
            map.put(stack, ids);
            return;
        }
        ids.add(id);
    }

    protected Map<ItemStack, Set<String>> getMap(int meta, String nbt) {
        int mask = 0;
        if (meta == Short.MAX_VALUE) {
            mask |= 1;
        }
        if (!StringUtils.func_151246_b((String)nbt)) {
            mask |= 2;
        }
        return this.conditions.get(mask);
    }

    protected void trigger(ItemStack stack, EntityPlayer player) {
        for (Map<ItemStack, Set<String>> map : this.conditions.values()) {
            for (String id : (Set)map.getOrDefault(stack, new HashSet())) {
                this.getListener().accept(id, player);
            }
        }
    }

    public static class Smelt
    extends ItemConditionHandler {
        public static final String ID = "item.smelt";

        @Override
        public String getID() {
            return ID;
        }

        @Override
        protected boolean isFMLEventHandler() {
            return this.conditions.values().stream().anyMatch(map -> !map.isEmpty());
        }

        @SubscribeEvent
        public void onItemPickup(PlayerEvent.ItemSmeltedEvent event) {
            this.trigger(event.smelting, event.player);
        }
    }

    public static class Craft
    extends ItemConditionHandler {
        public static final String ID = "item.craft";

        @Override
        public String getID() {
            return ID;
        }

        @Override
        protected boolean isFMLEventHandler() {
            return this.conditions.values().stream().anyMatch(map -> !map.isEmpty());
        }

        @SubscribeEvent
        public void onItemPickup(PlayerEvent.ItemCraftedEvent event) {
            this.trigger(event.crafting, event.player);
        }
    }

    public static class Pickup
    extends ItemConditionHandler {
        public static final String ID = "item.pickup";

        @Override
        public String getID() {
            return ID;
        }

        @Override
        protected boolean isFMLEventHandler() {
            return this.conditions.values().stream().anyMatch(map -> !map.isEmpty());
        }

        @SubscribeEvent
        public void onItemPickup(PlayerEvent.ItemPickupEvent event) {
            this.trigger(event.pickedUp.func_92059_d(), event.player);
        }
    }

    public static class Drop
    extends ItemConditionHandler {
        public static final String ID = "item.drop";

        @Override
        public String getID() {
            return ID;
        }

        @Override
        protected boolean isForgeEventHandler() {
            return this.conditions.values().stream().anyMatch(map -> !map.isEmpty());
        }

        @SubscribeEvent(priority=EventPriority.LOWEST)
        public void onItemDrop(ItemTossEvent event) {
            this.trigger(event.entityItem.func_92059_d(), event.player);
        }
    }
}

