/*
 * Decompiled with CFR 0.152.
 */
package com.bymarcin.openglasses.surface.widgets.component.world;

import com.bymarcin.openglasses.surface.IRenderableWidget;
import com.bymarcin.openglasses.surface.RenderType;
import com.bymarcin.openglasses.surface.WidgetType;
import com.bymarcin.openglasses.surface.widgets.component.world.Triangle3D;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import org.lwjgl.opengl.GL11;

public class Quad3D
extends Triangle3D {
    public Quad3D() {
        this.x = new float[4];
        this.y = new float[4];
        this.z = new float[4];
    }

    @Override
    public void writeData(ByteBuf buff) {
        super.writeData(buff);
        buff.writeFloat(this.x[3]);
        buff.writeFloat(this.y[3]);
        buff.writeFloat(this.z[3]);
    }

    @Override
    public void readData(ByteBuf buff) {
        super.readData(buff);
        this.x[3] = buff.readFloat();
        this.y[3] = buff.readFloat();
        this.z[3] = buff.readFloat();
    }

    @Override
    public WidgetType getType() {
        return WidgetType.QUAD3D;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IRenderableWidget getRenderable() {
        return new RenderQuad3D();
    }

    @SideOnly(value=Side.CLIENT)
    class RenderQuad3D
    implements IRenderableWidget {
        RenderQuad3D() {
        }

        @Override
        public void render(EntityPlayer player, double playerX, double playerY, double playerZ) {
            GL11.glPushMatrix();
            if (Quad3D.this.isThroughVisibility) {
                GL11.glDisable((int)2929);
            } else {
                GL11.glEnable((int)2929);
            }
            GL11.glDisable((int)3553);
            GL11.glBegin((int)8);
            GL11.glColor4f((float)Quad3D.this.r, (float)Quad3D.this.g, (float)Quad3D.this.b, (float)Quad3D.this.alpha);
            GL11.glVertex3f((float)Quad3D.this.x[0], (float)Quad3D.this.y[0], (float)Quad3D.this.z[0]);
            GL11.glVertex3f((float)Quad3D.this.x[1], (float)Quad3D.this.y[1], (float)Quad3D.this.z[1]);
            GL11.glVertex3f((float)Quad3D.this.x[2], (float)Quad3D.this.y[2], (float)Quad3D.this.z[2]);
            GL11.glVertex3f((float)Quad3D.this.x[3], (float)Quad3D.this.y[3], (float)Quad3D.this.z[3]);
            GL11.glVertex3f((float)Quad3D.this.x[0], (float)Quad3D.this.y[0], (float)Quad3D.this.z[0]);
            GL11.glVertex3f((float)Quad3D.this.x[1], (float)Quad3D.this.y[1], (float)Quad3D.this.z[1]);
            GL11.glEnd();
            GL11.glPopMatrix();
            GL11.glEnable((int)2929);
            GL11.glEnable((int)3553);
        }

        @Override
        public RenderType getRenderType() {
            return RenderType.WorldLocated;
        }

        @Override
        public boolean shouldWidgetBeRendered() {
            return Quad3D.this.isVisible();
        }
    }
}

