/*
 * Decompiled with CFR 0.152.
 */
package net.glease.tc4tweak.modules.infusionRecipe;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;
import net.glease.tc4tweak.ConfigurationHandler;
import net.glease.tc4tweak.api.InfusionExtAPI;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import thaumcraft.api.crafting.InfusionRecipe;

public class InfusionRecipeGetOutput {
    private static final ClassValue<Boolean> CLASS_OVERRIDES_GETRECIPEOUTPUT = new ClassValue<Boolean>(){

        @Override
        protected Boolean computeValue(Class<?> c) {
            while (c != InfusionRecipe.class) {
                try {
                    c.getDeclaredMethod("getRecipeOutput", ItemStack.class);
                }
                catch (NoSuchMethodException e) {
                    c = c.getSuperclass();
                    continue;
                }
                return true;
            }
            return false;
        }
    };
    static final WeakHashMap<InfusionRecipe, InfusionExtAPI.RecipeNBTBehavior> overrides = new WeakHashMap();
    private static InfusionExtAPI.RecipeNBTBehavior MERGER;

    public static boolean shouldModify(InfusionRecipe recipe, ItemStack input, ItemStack output) {
        if (!ConfigurationHandler.INSTANCE.isInfusionRecipeNBTCarryOver()) {
            return false;
        }
        if (CLASS_OVERRIDES_GETRECIPEOUTPUT.get(recipe.getClass()).booleanValue()) {
            return false;
        }
        if (!(!ConfigurationHandler.INSTANCE.isInfusionRecipeNBTModifyArmorToolOnly() || InfusionRecipeGetOutput.isArmorOrTool(input) && InfusionRecipeGetOutput.isArmorOrTool(output))) {
            return false;
        }
        return input.func_77942_o() && !input.func_77978_p().func_82582_d();
    }

    private static boolean isArmorOrTool(ItemStack input) {
        Item item = input.func_77973_b();
        return item instanceof ItemArmor || !item.getToolClasses(input).isEmpty();
    }

    public static ItemStack getOutput(InfusionRecipe thiz, ItemStack input, ItemStack output) {
        InfusionExtAPI.RecipeNBTBehavior overridingBehavior = overrides.get(thiz);
        if (overridingBehavior != null) {
            return overridingBehavior.getRecipeOutput(thiz, input, output);
        }
        if (!InfusionRecipeGetOutput.shouldModify(thiz, input, output)) {
            return output;
        }
        return MERGER.getRecipeOutput(thiz, input, output);
    }

    public static void reload() {
        List<String> whitelist = ConfigurationHandler.INSTANCE.getInfusionRecipeNBTWhitelist();
        MERGER = InfusionExtAPI.RecipeNBTBehavior.mergeNBT((Set<String>)(whitelist.isEmpty() ? null : new HashSet<String>(whitelist)));
    }

    static {
        InfusionRecipeGetOutput.reload();
    }

    public static class APIImpl
    implements InfusionExtAPI {
        @Override
        public void setRecipeNBTBehavior(InfusionRecipe recipe, InfusionExtAPI.RecipeNBTBehavior behavior) {
            overrides.put(recipe, behavior);
        }
    }
}

