/*
 * Decompiled with CFR 0.152.
 */
package net.glease.tc4tweak.asm;

import net.glease.tc4tweak.asm.ASMUtils;
import net.glease.tc4tweak.asm.TC4Transformer;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;

class ThaumcraftApiVisitor
extends ClassVisitor {
    public ThaumcraftApiVisitor(int api, ClassVisitor cv) {
        super(api, cv);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        if ("<clinit>".equals(name) && "()V".equals(desc)) {
            TC4Transformer.log.debug("Adding callhook to end of clinit");
            return new ClinitVisitor(this.api, mv);
        }
        if ("getCrucibleRecipeFromHash".equals(name) && "(I)Lthaumcraft/api/crafting/CrucibleRecipe;".equals(desc)) {
            TC4Transformer.log.debug("Replacing getCrucibleRecipeFromHash(I)Lthaumcraft/api/crafting/CrucibleRecipe;");
            ASMUtils.writeOverwrite("net/glease/tc4tweak/asm/ASMCallhookServer", "getCrucibleRecipeFromHash", mv, null, desc);
            return null;
        }
        return mv;
    }

    private static class ClinitVisitor
    extends MethodVisitor {
        public ClinitVisitor(int api, MethodVisitor mv) {
            super(api, mv);
        }

        public void visitInsn(int opcode) {
            if (opcode == 177) {
                this.mv.visitMethodInsn(184, "net/glease/tc4tweak/asm/ASMCallhookServer", "postThaumcraftApiClinit", "()V", false);
            }
            super.visitInsn(opcode);
        }
    }
}

